/*
 * Decompiled with CFR 0.152.
 */
package nts.noad;

import nts.base.Dimen;
import nts.base.Glue;
import nts.base.Num;
import nts.io.CharCode;
import nts.noad.Delimiter;
import nts.noad.TransfConstants;
import nts.node.Box;
import nts.node.FontMetric;
import nts.node.MathWordBuilder;
import nts.node.Node;
import nts.node.TreatNode;

public abstract class ConvStyle
implements TransfConstants {
    private static final byte[] dimFamilies = new byte[23];
    private static final int[] dimFontPars = new int[23];
    public static final byte SYMBOL_FAMILY = 2;
    public static final byte EXTENSION_FAMILY = 3;
    protected final byte style;
    protected final boolean cramped;
    protected final Dimen currMu;

    protected abstract void setupFontSize();

    protected abstract FontMetric fetchFontMetric(byte var1);

    public byte getStyle() {
        return this.style;
    }

    public boolean isCramped() {
        return this.cramped;
    }

    public Dimen muToPt(Dimen dim) {
        return dim.times(this.currMu);
    }

    public Glue muToPt(Glue skip) {
        return skip.timesTheFinite(this.currMu);
    }

    public abstract Node fetchCharNode(byte var1, CharCode var2);

    public abstract Node fetchLargerNode(byte var1, CharCode var2);

    public abstract Node fetchSufficientNode(Delimiter var1, Dimen var2);

    public abstract Box fetchFittingWidthBox(byte var1, CharCode var2, Dimen var3);

    public abstract Dimen skewAmount(byte var1, CharCode var2);

    public abstract Dimen getXHeight(byte var1);

    public abstract Dimen delimiterSize(Dimen var1, Dimen var2);

    public abstract Dimen scriptSpace();

    public abstract Node getSpacing(byte var1, byte var2);

    public abstract Num getPenalty(byte var1, byte var2);

    public abstract boolean isScript();

    public abstract ConvStyle makeNew(byte var1);

    public abstract boolean forcedItalCorr(byte var1);

    public abstract MathWordBuilder getWordBuilder(byte var1, TreatNode var2);

    public ConvStyle derived(byte how) {
        int s = this.style;
        boolean c = this.cramped;
        block0 : switch (how) {
            case 1: {
                c = true;
                break;
            }
            case 2: {
                c = true;
            }
            case 3: {
                switch (this.style) {
                    case 0: 
                    case 1: {
                        s = 2;
                        break block0;
                    }
                }
                s = 3;
                break;
            }
            case 5: {
                c = true;
            }
            case 4: {
                switch (this.style) {
                    case 0: {
                        s = 1;
                        break block0;
                    }
                    case 1: {
                        s = 2;
                        break block0;
                    }
                }
                s = 3;
                break;
            }
        }
        return this.deriveNew((byte)s, c);
    }

    protected abstract ConvStyle deriveNew(byte var1, boolean var2);

    public Dimen getDimPar(int param) {
        return this.fetchFontMetric(dimFamilies[param]).getDimenParam(dimFontPars[param]);
    }

    private static void initSymbolPar(int param, int fontPar) {
        ConvStyle.dimFamilies[param] = 2;
        ConvStyle.dimFontPars[param] = fontPar;
    }

    private static void initExtensionPar(int param, int fontPar) {
        ConvStyle.dimFamilies[param] = 3;
        ConvStyle.dimFontPars[param] = fontPar;
    }

    protected ConvStyle(byte style, boolean cramped) {
        this.style = style;
        this.cramped = cramped;
        this.setupFontSize();
        this.currMu = this.getDimPar(1).over(18);
    }

    static {
        ConvStyle.initSymbolPar(0, 7);
        ConvStyle.initSymbolPar(1, 8);
        ConvStyle.initSymbolPar(2, 9);
        ConvStyle.initSymbolPar(3, 10);
        ConvStyle.initSymbolPar(4, 11);
        ConvStyle.initSymbolPar(5, 12);
        ConvStyle.initSymbolPar(6, 13);
        ConvStyle.initSymbolPar(7, 14);
        ConvStyle.initSymbolPar(8, 15);
        ConvStyle.initSymbolPar(9, 16);
        ConvStyle.initSymbolPar(10, 17);
        ConvStyle.initSymbolPar(11, 18);
        ConvStyle.initSymbolPar(12, 19);
        ConvStyle.initSymbolPar(13, 20);
        ConvStyle.initSymbolPar(14, 21);
        ConvStyle.initSymbolPar(15, 22);
        ConvStyle.initSymbolPar(16, 23);
        ConvStyle.initExtensionPar(17, 24);
        ConvStyle.initExtensionPar(18, 25);
        ConvStyle.initExtensionPar(19, 26);
        ConvStyle.initExtensionPar(20, 27);
        ConvStyle.initExtensionPar(21, 28);
        ConvStyle.initExtensionPar(22, 29);
    }
}

