/*
 * Decompiled with CFR 0.152.
 */
package nts.tfm;

import nts.base.BinFraction;

public final class FixWord
extends BinFraction {
    private static final int POINT_SHIFT = 20;
    private static final int MAX_REPR_VALUE = Integer.MAX_VALUE;
    public static final FixWord NULL;
    public static final FixWord ZERO;
    public static final FixWord UNITY;
    public static final FixWord MAX_VALUE;
    public static final FixWord BAD_VALUE;

    protected final int pointShift() {
        return 20;
    }

    private static int makeRepr(int num) {
        return num << 20;
    }

    private static int makeRepr(int num, int den) {
        return (int)(((long)num << 20) / (long)den);
    }

    private static int makeRepr(BinFraction x) {
        return BinFraction.makeRepr(x, 20);
    }

    public static FixWord valueOf(FixWord d) {
        return new FixWord(d.value);
    }

    public static FixWord valueOf(int num) {
        return new FixWord(FixWord.makeRepr(num));
    }

    public static FixWord valueOf(int num, int den) {
        return new FixWord(FixWord.makeRepr(num, den));
    }

    public static FixWord valueOf(BinFraction x) {
        return new FixWord(FixWord.makeRepr(x));
    }

    public static FixWord shiftedValueOf(int num, int offs) {
        return new FixWord((offs += 20) < 0 ? num >> -offs : num << offs);
    }

    public static FixWord valueOf(String s) throws NumberFormatException {
        boolean negative;
        int pointIndex = s.indexOf(46);
        if (pointIndex < 0) {
            return new FixWord(FixWord.makeRepr(Integer.parseInt(s)));
        }
        long val = Integer.parseInt(s.substring(0, pointIndex));
        int SHIFT = 21;
        int frac = 0;
        int i = pointIndex + 21 + 1;
        if (i > s.length()) {
            i = s.length();
        }
        while (--i > pointIndex) {
            int digit = Character.digit(s.charAt(i), 10);
            if (digit < 0) {
                throw new NumberFormatException(s);
            }
            frac = (frac + (digit << 21)) / 10;
        }
        boolean bl = negative = val < 0L;
        if (negative) {
            val = -val;
        }
        val <<= 20;
        if ((val |= (long)(frac + 1 >>> 1)) > Integer.MAX_VALUE) {
            throw new NumberFormatException(s);
        }
        return new FixWord(negative ? (int)(-val) : (int)val);
    }

    public int sign() {
        return this.value > 0 ? 1 : (this.value < 0 ? -1 : 0);
    }

    public boolean isZero() {
        return this.value == 0;
    }

    public boolean equals(FixWord d) {
        return this.value == d.value;
    }

    public boolean equals(int num) {
        return this.value == FixWord.makeRepr(num);
    }

    public boolean equals(int num, int den) {
        return this.value == FixWord.makeRepr(num, den);
    }

    public boolean equals(BinFraction x) {
        return this.value == FixWord.makeRepr(x);
    }

    public boolean lessThan(FixWord d) {
        return this.value < d.value;
    }

    public boolean lessThan(int num) {
        return this.value < FixWord.makeRepr(num);
    }

    public boolean lessThan(int num, int den) {
        return this.value < FixWord.makeRepr(num, den);
    }

    public boolean lessThan(BinFraction x) {
        return this.value < FixWord.makeRepr(x);
    }

    public boolean moreThan(FixWord d) {
        return this.value > d.value;
    }

    public boolean moreThan(int num) {
        return this.value > FixWord.makeRepr(num);
    }

    public boolean moreThan(int num, int den) {
        return this.value > FixWord.makeRepr(num, den);
    }

    public boolean moreThan(BinFraction x) {
        return this.value > FixWord.makeRepr(x);
    }

    public FixWord negative() {
        return new FixWord(-this.value);
    }

    public FixWord plus(FixWord d) {
        return new FixWord(this.value + d.value);
    }

    public FixWord plus(int num) {
        return new FixWord(this.value + FixWord.makeRepr(num));
    }

    public FixWord plus(int num, int den) {
        return new FixWord(this.value + FixWord.makeRepr(num, den));
    }

    public FixWord plus(BinFraction x) {
        return new FixWord(this.value + FixWord.makeRepr(x));
    }

    public FixWord minus(FixWord d) {
        return new FixWord(this.value - d.value);
    }

    public FixWord minus(int num) {
        return new FixWord(this.value - FixWord.makeRepr(num));
    }

    public FixWord minus(int num, int den) {
        return new FixWord(this.value - FixWord.makeRepr(num, den));
    }

    public FixWord minus(BinFraction x) {
        return new FixWord(this.value - FixWord.makeRepr(x));
    }

    public FixWord times(FixWord d) {
        return new FixWord((int)((long)this.value * (long)d.value >> 20));
    }

    public FixWord times(int num) {
        return new FixWord((int)((long)this.value * (long)num));
    }

    public FixWord times(int num, int den) {
        return new FixWord((int)((long)this.value * (long)num / (long)den));
    }

    public FixWord times(BinFraction x) {
        return new FixWord(this.reprTimes(x));
    }

    public FixWord over(FixWord d) {
        return new FixWord((int)(((long)this.value << 20) / (long)d.value));
    }

    public FixWord over(int num) {
        return new FixWord((int)((long)this.value / (long)num));
    }

    public FixWord over(int num, int den) {
        return new FixWord((int)((long)this.value * (long)den / (long)num));
    }

    public FixWord over(BinFraction x) {
        return new FixWord(this.reprOver(x));
    }

    public FixWord shifted(int offs) {
        return new FixWord(offs < 0 ? this.value >> -offs : this.value << offs);
    }

    public int toInt() {
        return this.value >>> 20;
    }

    public int toInt(int den) {
        return (int)((long)this.value * (long)den >>> 20);
    }

    public String toString(String unit) {
        return this.toString() + unit;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        int v = this.value;
        int UNITY = 0x100000;
        int MASK = 1048575;
        if (v < 0) {
            buf.append('-');
            v = -v;
        }
        buf.append(v >>> 20);
        buf.append('.');
        v = 10 * (v & 0xFFFFF) + 5;
        int delta = 10;
        do {
            if (delta > 0x100000) {
                v += 524288 - delta / 2;
            }
            buf.append(Character.forDigit(v >>> 20, 10));
        } while ((v = 10 * (v & 0xFFFFF)) > (delta *= 10));
        return buf.toString();
    }

    public int hashCode() {
        return 7660 * this.value;
    }

    public boolean equals(Object o) {
        return o != null && o instanceof FixWord && ((FixWord)o).value == this.value;
    }

    private FixWord(int val) {
        super(val);
    }

    static {
        ZERO = FixWord.valueOf(0);
        UNITY = FixWord.valueOf(1);
        MAX_VALUE = new FixWord(Integer.MAX_VALUE);
        BAD_VALUE = new FixWord(Integer.MIN_VALUE);
    }
}

