/**/

call RxFuncAdd 'SysLoadFuncs', 'RexxUtil', 'SysLoadFuncs'
call SysLoadFuncs


parse arg language texmf source options




if language='049' then do

  msg.10 = 'msg:LaTeX2e Tools: Erzeuge Dokumentation'
  msg.11 = 'Lauf'
  msg.12 = 'von'

end
else do

  msg.10 = 'msg:LaTeX2e Tools: creating documentation'
  msg.11 = 'run'
  msg.12 = 'of'

end



say 'msg:LaTeX2e Tools'


bin      = texmf||'\os2tex\bin'
tfm      = texmf||'\fonts\tfm'
tex      = texmf||'\tex'
doc      = texmf||'\doc'
fmt      = bin

target   = texmf||'\tex\latex\tools'

exec     = bin||'\tex.exe'


install = texmf||'\os2tex\install'



if Pos("InstallFiles", options) > 0 then do

   install||'\kdir '||target

   'md '||tex
   'md '||tex||'\latex'
   'md '||tex||'\latex\tools'


   say 'msg:LaTeX2e Tools entpacke Dateien'



   if directory(texmf||'\tex\latex') = '' then do

      exit 1

   end

  

   install||'\unzip '||source||'\l2tools.zip'



   say 'msg:LaTeX2e Tools tools.ins'

   exec||' -pf '||bin||' -po '||target||' -pi '||target||';'||tex||'\latex\base;'||bin||' '||'tools.ins'




end


/* Dokumentation erzeugen */



if SysOS2Ver() = '2.30' then
  top = 48
else
  top = 45



if Pos("CreateObjects", options) > 0 then do

   classname = 'WPFolder'
   objtitle  = 'LaTeX2e Tools'
   location  = '<OS2TEX_DOC_FOLDER>'
   setup     = 'OBJECTID=<OS2TEX_L2TOOLS_FOLDER>;ICONVIEW=MINI,NONFLOWED;ALWAYSSORT=YES;ICONVIEWPOS=50,50,25,'||top
   duplicate = 'replace'


   rc = SysCreateObject(classname,objtitle,location,setup,duplicate)

   if rc = 0 then do
      exit 1
   end
end




if Pos("InstallFiles", options) > 0 then do

   install||'\kdir '||texmf||'\doc\latex\tools'
   'md '||texmf||'\doc'
   'md '||texmf||'\doc\latex'
   'md '||texmf||'\doc\latex\tools'



   call SysFileTree target||'\*.dtx', "filelist.", "FO"

end

else

if Pos("CreateObjects", options) > 0 then do

   call SysFileTree texmf||'\doc\latex\tools\*.dvi', "filelist.", "FO"

end 


do i=1 to filelist.0

  dtx = filespec("N",filelist.i)
  name = substr(dtx,1,length(dtx)-4)
  idx = name||'.idx'
  loc = name||'.loc'
  lof = name||'.lof'
  lot = name||'.lof'
  toc = name||'.toc'
  aux = name||'.aux'
  glo = name||'.glo'



   if Pos("InstallFiles", options) > 0 then do

      say msg.10' 'filespec("N",filelist.i)' 'msg.11' 1 'msg.12' 3'
      exec||' -r -ff latex.fmt -pf '||bin||' -po '||texmf||'\doc\latex\tools -pt '||tfm||' -pi '||target||';'||doc||'\latex\tools;'||tex||' '||filespec("N",filelist.i)

      k = 1
      floc = 0
      faux = 0
      flof = 0
      flot = 0
      ftoc = 0
      fglo = 0
      fidx = 0
      flabel = 0

      if stream(doc||'\latex\tools\'||loc, "C", "QUERY EXISTS") \= '' then floc = 1
      if stream(doc||'\latex\tools\'||aux, "C", "QUERY EXISTS") \= '' then faux = 1
      if stream(doc||'\latex\tools\'||lof, "C", "QUERY EXISTS") \= '' then flof = 1
      if stream(doc||'\latex\tools\'||lot, "C", "QUERY EXISTS") \= '' then flot = 1
      if stream(doc||'\latex\tools\'||toc, "C", "QUERY EXISTS") \= '' then ftoc = 1
      if stream(doc||'\latex\tools\'||glo, "C", "QUERY EXISTS") \= '' then fglo = 1
      if stream(doc||'\latex\tools\'||idx, "C", "QUERY EXISTS") \= '' then fidx = 1

/*

  if faux = 1 then do
    if SysFileSearch("\newlabel", doc||'\latex\tools\'||aux, "") \= '' then flabel = 1
  end


  if fidx + flabel > 0 & ftoc + flof + flot > 0 then k = 3

*/

      k = 3

      do j=2 to k
         say msg.10' 'filespec("N",filelist.i)' 'msg.11' 'j' 'msg.12' 'k

         if fidx = 1 & j = k then do
            bin||'\makeindex -c -l '||doc||'\latex\tools\'||idx
         end

         exec||' -r -ff latex.fmt -pf '||bin||' -po '||texmf||'\doc\latex\tools -pt '||tfm||' -pi '||target||';'||doc||'\latex\tools;'||tex||' '||filespec("N",filelist.i)
      end

   end


   if Pos("CreateObjects", options) > 0 then do


      classname = 'WPProgram'
      objtitle  = translate(name,xrange('a','z'),xrange('A','Z'))
      location  = '<OS2TEX_L2TOOLS_FOLDER>'
      setup     = 'EXENAME='texmf'\os2tex\bin\dvi.exe;PROGTYPE=PM;STARTUPDIR='texmf'\os2tex\bin;OBJECTID=<OS2TEX_'name'.dvi>;PARAMETERS='doc'\latex\tools\'name'.dvi'
      duplicate = 'replace'


      rc = SysCreateObject(classname,objtitle,location,setup,duplicate)

      if rc = 0 then do
         exit 1
      end
   end


end






