/*
 File: yacco2_terminals.h
 Date and Time: Sun Apr 20 13:54:30 2014 
*/
#include "yacco2.h"
#include "yacco2_T_enumeration.h"
#include "yacco2_k_symbols.h"
#include "yacco2_err_symbols.h"
#ifndef __yacco2_terminals_h__
#define __yacco2_terminals_h__ 1
namespace NS_yacco2_terminals{
  using namespace NS_yacco2_T_enum;
  
using namespace std;
using namespace NS_yacco2_err_symbols;
using namespace yacco2;
struct T_called_thread_eosubrule;
struct T_c_literal;
struct T_identifier;
struct T_syntax_code;
struct T_fsm_class_phrase;
struct T_fsm_class;
struct T_fsm_phrase;
struct T_parallel_parser_phrase;
struct T_enum_phrase;
struct T_error_symbols_phrase;
struct T_rc_phrase;
struct T_lr1_k_phrase;
struct T_terminals_phrase;
struct T_rules_phrase;
struct T_subrules_phrase;
struct T_rhs_bnd;
struct refered_rule;
struct rule_def;
struct refered_T;
struct T_in_stbl;
struct rule_in_stbl;
extern yacco2::CAbs_lr1_sym* PTR_lint__;
extern yacco2::CAbs_lr1_sym* PTR_ws__;
extern yacco2::CAbs_lr1_sym* PTR_eol__;
	
  struct T_option_t:public yacco2::CAbs_lr1_sym{
    T_option_t();
  };
  struct T_option_p:public yacco2::CAbs_lr1_sym{
    T_option_p();
  };
  struct T_option_err:public yacco2::CAbs_lr1_sym{
    T_option_err();
  };
  struct T_esc_seq:public yacco2::CAbs_lr1_sym{

    public:
    T_esc_seq(const char* Esc_data);
    std::string* esc_data();
    private:std::string esc_data_;
    };
  struct T_eol:public yacco2::CAbs_lr1_sym{

    public:
    T_eol();
    };
  struct T_basic_char:public yacco2::CAbs_lr1_sym{

    public:
    T_basic_char(CAbs_lr1_sym* Basic_char);
    CAbs_lr1_sym* basic_char()const;
    void zero_out_basic_char();
    private:CAbs_lr1_sym* basic_char_;
    static void dtor_T_basic_char(yacco2::VOIDP This,yacco2::VOIDP P);
  };
  struct T_raw_char:public yacco2::CAbs_lr1_sym{

    public:
    T_raw_char(CAbs_lr1_sym* Raw_char);
    CAbs_lr1_sym* raw_char()const;
    void zero_out_raw_char();
    private:CAbs_lr1_sym* raw_char_;
    static void dtor_T_raw_char(yacco2::VOIDP This,yacco2::VOIDP P);
  };
  struct T_comment:public yacco2::CAbs_lr1_sym{

    public:
    T_comment(const std::string& Comment_data);
    std::string* comment_data();
    private:std::string comment_data_;
    };
  struct T_ws:public yacco2::CAbs_lr1_sym{

    public:
    T_ws(const std::string& White_space_data);
    T_ws();
    std::string* ws_data();
    private:std::string ws_data_;
    };
  struct T_angled_string:public yacco2::CAbs_lr1_sym{

    public:
    T_angled_string(const std::string& Angled_string);
    std::string* angled_string();
    private:std::string angled_string_;
    };
  struct T_c_literal:public yacco2::CAbs_lr1_sym{

    public:
    T_c_literal(const std::string& C_literal);
    std::string* c_literal();
    private:std::string c_literal_;
    };
  struct T_c_string:public yacco2::CAbs_lr1_sym{

    public:
    T_c_string(const std::string& C_string);
    std::string* c_string();
    private:std::string c_string_;
    };
  struct T_xc_str:public yacco2::CAbs_lr1_sym{

    public:
    T_xc_str(const std::string& C_string);
    std::string* c_string();
    private:std::string c_string_;
    };
  struct T_unquoted_string:public yacco2::CAbs_lr1_sym{

    public:
    T_unquoted_string(const std::string& String);
    std::string* unquoted_string();
    private:std::string unquoted_string_;
    };
  struct T_file_inclusion:public yacco2::CAbs_lr1_sym{

    public:
    T_file_inclusion(T_c_string* File_name_,CAbs_lr1_sym* Error);
    ~T_file_inclusion();
    T_c_string* file_name();
    CAbs_lr1_sym* error_sym();
    void error_sym(CAbs_lr1_sym* Error);
    private:T_c_string* file_name_;
    CAbs_lr1_sym* error_sym_;
    };
  struct T_identifier:public yacco2::CAbs_lr1_sym{

    public:
    T_identifier(yacco2::KCHARP Identifier);
    std::string* identifier();
    private:std::string identifier_;
    };
  struct T_int_no:public yacco2::CAbs_lr1_sym{

    public:
    T_int_no(long S_no);
    long no();
    private:
    long  no_;
    };
  struct T_raw_characters:public yacco2::CAbs_lr1_sym{

    public:
    T_raw_characters();
    void rc_phrase(T_rc_phrase* Phrase);
    T_rc_phrase* rc_phrase();
    private:T_rc_phrase* rc_phrase_;
    static void dtor_T_raw_characters(yacco2::VOIDP This,yacco2::VOIDP P);
  };
  struct T_lr1_constant_symbols:public yacco2::CAbs_lr1_sym{

    public:
    T_lr1_constant_symbols();
    void lr1_k_phrase(T_lr1_k_phrase* Phrase);
    T_lr1_k_phrase* lr1_k_phrase();
    private:T_lr1_k_phrase* lr1_k_phrase_;
    static void dtor_T_lr1_constant_symbols(yacco2::VOIDP This,yacco2::VOIDP P);
  };
  struct T_error_symbols:public yacco2::CAbs_lr1_sym{

    public:
    T_error_symbols();
    void error_symbols_phrase(T_error_symbols_phrase* Phrase);
    T_error_symbols_phrase* error_symbols_phrase();
    private:T_error_symbols_phrase* error_symbols_phrase_;
    static void dtor_T_error_symbols(yacco2::VOIDP This,yacco2::VOIDP P);
  };
  struct T_eocode:public yacco2::CAbs_lr1_sym{
    T_eocode();
  };
  struct T_AD:public yacco2::CAbs_lr1_sym{
    T_AD();
  };
  struct T_AB:public yacco2::CAbs_lr1_sym{
    T_AB();
  };
  struct T_parallel_la_boundary:public yacco2::CAbs_lr1_sym{

    public:
    T_parallel_la_boundary();
    void la_first_set(std::set<T_in_stbl*>& Supplier);
    std::set<T_in_stbl*>* la_first_set();
    void la_supplier(yacco2::TOKEN_GAGGLE* Supplier);
    yacco2::TOKEN_GAGGLE* la_supplier();
    void add_cweb_marker(AST* Cweb);
    AST* cweb_marker();
    void cweb_la_srce_expr(const char* Srce_expr);
    std::string* cweb_la_srce_expr();
    private:
    std::set<T_in_stbl*> la_first_set_;
    std::string cweb_la_srce_expr_;
    AST* cweb_marker_;
    yacco2::TOKEN_GAGGLE* la_supplier_;
    };
  struct T_arbitrator_code:public yacco2::CAbs_lr1_sym{

    public:
    T_arbitrator_code();
    void syntax_code(T_syntax_code* Stc);
    T_syntax_code* syntax_code();
    void add_cweb_marker(AST* Cweb);
    AST* cweb_marker();
    private:T_syntax_code* syntax_code_;
        AST* cweb_marker_;
    };
  struct T_parallel_parser:public yacco2::CAbs_lr1_sym{

    public:
    T_parallel_parser();
    void parallel_parser_phrase(T_parallel_parser_phrase* Phrase);
    T_parallel_parser_phrase* parallel_parser_phrase();
    private:T_parallel_parser_phrase* parallel_parser_phrase_;
    static void dtor_T_parallel_parser(yacco2::VOIDP This,yacco2::VOIDP P);
  };
  struct T_parallel_thread_function:public yacco2::CAbs_lr1_sym{

    public:
    T_parallel_thread_function();
    void identifier(T_identifier* Id);
    T_identifier* identifier();
    void add_cweb_marker(AST* Cweb);
    AST* cweb_marker();
    private:T_identifier* id_;
        AST* cweb_marker_;
    };
  struct T_parallel_control_monitor:public yacco2::CAbs_lr1_sym{
    T_parallel_control_monitor();
  };
  struct T_fsm:public yacco2::CAbs_lr1_sym{

    public:
    T_fsm();
    void fsm_phrase(T_fsm_phrase* Phrase);
    T_fsm_phrase* fsm_phrase();
    private:T_fsm_phrase* fsm_phrase_;
    static void dtor_T_fsm(yacco2::VOIDP This,yacco2::VOIDP P);
  };
  struct T_fsm_id:public yacco2::CAbs_lr1_sym{
    T_fsm_id();
  };
  struct T_fsm_filename:public yacco2::CAbs_lr1_sym{
    T_fsm_filename();
  };
  struct T_fsm_namespace:public yacco2::CAbs_lr1_sym{
    T_fsm_namespace();
  };
  struct T_fsm_class:public yacco2::CAbs_lr1_sym{
    T_fsm_class();
  };
  struct T_fsm_version:public yacco2::CAbs_lr1_sym{
    T_fsm_version();
  };
  struct T_fsm_date:public yacco2::CAbs_lr1_sym{
    T_fsm_date();
  };
  struct T_fsm_debug:public yacco2::CAbs_lr1_sym{
    T_fsm_debug();
  };
  struct T_fsm_comments:public yacco2::CAbs_lr1_sym{
    T_fsm_comments();
  };
  struct T_terminals:public yacco2::CAbs_lr1_sym{

    public:
    T_terminals();
    void terminals_phrase(T_terminals_phrase* Phrase);
    T_terminals_phrase* terminals_phrase();
    private:T_terminals_phrase* terminals_phrase_;
    static void dtor_T_terminals(yacco2::VOIDP This,yacco2::VOIDP P);
  };
  struct T_enumeration:public yacco2::CAbs_lr1_sym{

    public:
    T_enumeration();
    void enum_phrase(T_enum_phrase* Phrase);
    T_enum_phrase* enum_phrase();
    private:T_enum_phrase* enum_phrase_;
    static void dtor_T_enumeration(yacco2::VOIDP This,yacco2::VOIDP P);
  };
  struct T_file_name:public yacco2::CAbs_lr1_sym{
    T_file_name();
  };
  struct T_name_space:public yacco2::CAbs_lr1_sym{
    T_name_space();
  };
  struct T_sym_class:public yacco2::CAbs_lr1_sym{
    T_sym_class();
  };
  struct T_rules:public yacco2::CAbs_lr1_sym{

    public:
    T_rules();
    void rules_phrase(T_rules_phrase* Phrase);
    T_rules_phrase* rules_phrase();
    private:T_rules_phrase* rules_phrase_;
    static void dtor_T_rules(yacco2::VOIDP This,yacco2::VOIDP P);
  };
  struct T_lhs:public yacco2::CAbs_lr1_sym{
    T_lhs();
  };
  struct T_user_declaration:public yacco2::CAbs_lr1_sym{

    public:
    T_user_declaration();
    void syntax_code(T_syntax_code* Stc);
    T_syntax_code* syntax_code();
    private:T_syntax_code* syntax_code_;
    };
  struct T_user_prefix_declaration:public yacco2::CAbs_lr1_sym{

    public:
    T_user_prefix_declaration();
    void syntax_code(T_syntax_code* Stc);
    T_syntax_code* syntax_code();
    private:T_syntax_code* syntax_code_;
    };
  struct T_user_suffix_declaration:public yacco2::CAbs_lr1_sym{

    public:
    T_user_suffix_declaration();
    void syntax_code(T_syntax_code* Stc);
    T_syntax_code* syntax_code();
    private:T_syntax_code* syntax_code_;
    };
  struct T_constructor:public yacco2::CAbs_lr1_sym{

    public:
    T_constructor();
    void syntax_code(T_syntax_code* Stc);
    T_syntax_code* syntax_code();
    private:T_syntax_code* syntax_code_;
    };
  struct T_destructor:public yacco2::CAbs_lr1_sym{

    public:
    T_destructor();
    void syntax_code(T_syntax_code* Stc);
    T_syntax_code* syntax_code();
    private:T_syntax_code* syntax_code_;
    };
  struct T_op:public yacco2::CAbs_lr1_sym{

    public:
    T_op();
    void syntax_code(T_syntax_code* Stc);
    T_syntax_code* syntax_code();
    private:T_syntax_code* syntax_code_;
    };
  struct T_failed:public yacco2::CAbs_lr1_sym{

    public:
    T_failed();
    void syntax_code(T_syntax_code* Stc);
    T_syntax_code* syntax_code();
    private:T_syntax_code* syntax_code_;
    };
  struct T_user_implementation:public yacco2::CAbs_lr1_sym{

    public:
    T_user_implementation();
    void syntax_code(T_syntax_code* Stc);
    T_syntax_code* syntax_code();
    private:T_syntax_code* syntax_code_;
    };
  struct T_user_imp_tbl:public yacco2::CAbs_lr1_sym{

    public:
    T_user_imp_tbl();
    void syntax_code(T_syntax_code* Stc);
    T_syntax_code* syntax_code();
    private:T_syntax_code* syntax_code_;
    };
  struct T_user_imp_sym:public yacco2::CAbs_lr1_sym{

    public:
    T_user_imp_sym();
    void syntax_code(T_syntax_code* Stc);
    T_syntax_code* syntax_code();
    private:T_syntax_code* syntax_code_;
    };
  struct T_constant_defs:public yacco2::CAbs_lr1_sym{
    T_constant_defs();
  };
  struct T_terminals_refs:public yacco2::CAbs_lr1_sym{
    T_terminals_refs();
  };
  struct T_terminals_sufx:public yacco2::CAbs_lr1_sym{
    T_terminals_sufx();
  };
  struct T_lrk_sufx:public yacco2::CAbs_lr1_sym{
    T_lrk_sufx();
  };
  struct T_selector:public yacco2::CAbs_lr1_sym{
    T_selector();
  };
  struct T_NULL:public yacco2::CAbs_lr1_sym{
    T_NULL();
  };
  struct T_2colon:public yacco2::CAbs_lr1_sym{
    T_2colon();
  };
  struct T_block:public yacco2::CAbs_lr1_sym{

    public:
    T_block(yacco2::AST* Ast);
    yacco2::AST* ast();
    private: yacco2::AST* ast_;
    static void dtor_T_block(yacco2::VOIDP This,yacco2::VOIDP P);
  };
  struct T_syntax_code:public yacco2::CAbs_lr1_sym{

    public:
    T_syntax_code(const char* Syntax_code);
    void add_cweb_marker(AST* Cweb);
    AST* cweb_marker();
    std::string* syntax_code();
    private:std::string syntax_code_;
    AST* cweb_marker_;
    };
  struct T_fsm_class_phrase:public yacco2::CAbs_lr1_sym{

    public:
    T_fsm_class_phrase();
    T_identifier* identifier();
    void identifier(T_identifier* Id);
    void remove_directives_from_map();
    std::map<std::string,CAbs_lr1_sym*>* directives_map();
    CAbs_lr1_sym* // 0 - ok, or error 
    add_directive_to_map(CAbs_lr1_sym* Directive,yacco2::Parser* P);
    void phrase_tree(AST* Tree);
    AST* phrase_tree();
    private: 
      T_identifier* identifier_;
      std::map<std::string,CAbs_lr1_sym*> directives_map_;
      AST* phrase_tree_;
    static void dtor_T_fsm_class_phrase(yacco2::VOIDP This,yacco2::VOIDP P);
  };
  struct T_fsm_phrase:public yacco2::CAbs_lr1_sym{

    public:
    T_fsm_phrase();
    T_c_string* fsm_id();
    void fsm_id(T_c_string* Id);
    T_identifier* filename_id();
    void filename_id(T_identifier* Id);
    T_identifier* namespace_id();
    void namespace_id(T_identifier* Id);
    T_fsm_class_phrase* fsm_class_phrase();
    void fsm_class_phrase(T_fsm_class_phrase* Id);
    T_c_string* version();
    void version(T_c_string* Id);
    T_c_string* date();
    void date(T_c_string* Id);
    T_c_string* debug();
    void debug(T_c_string* Id);
    T_c_string* comment();
    void comment(T_c_string* Id);
    void phrase_tree(AST* Tree);
    AST* phrase_tree();
    void add_cweb_marker(AST* Cweb);
    AST* cweb_marker();
    private: 
      T_c_string* fsm_id_;
      T_identifier* filename_id_;
      string filename_no_ext_;
      T_identifier* namespace_id_;
      T_fsm_class_phrase* fsm_class_phrase_;
      T_c_string* version_;
      T_c_string* date_;
      T_c_string* debug_;
      T_c_string* comment_;
      AST* phrase_tree_;
      AST* cweb_marker_;
    static void dtor_T_fsm_phrase(yacco2::VOIDP This,yacco2::VOIDP P);
  };
  struct T_parallel_parser_phrase:public yacco2::CAbs_lr1_sym{

    public:
    T_parallel_parser_phrase();
    T_parallel_thread_function* pp_funct();
    void pp_funct(T_parallel_thread_function* PP_fnct);
    T_parallel_la_boundary* la_bndry();
    void la_bndry(T_parallel_la_boundary* La_bndry);
    void phrase_tree(AST* Tree);
    AST* phrase_tree();
    void add_cweb_marker(AST* Cweb);
    AST* cweb_marker();
    private: 
      T_parallel_thread_function* pp_funct_;
      T_parallel_la_boundary* la_bndry_;
      AST* phrase_tree_;
      AST* cweb_marker_;
    static void dtor_T_parallel_parser_phrase(yacco2::VOIDP This,yacco2::VOIDP P);
  };
  struct T_enum_phrase:public yacco2::CAbs_lr1_sym{

    public:
    T_enum_phrase();
    T_identifier* filename_id();
    void filename_id(T_identifier* Id);
    T_identifier* namespace_id();
    void namespace_id(T_identifier* Id);
    T_syntax_code* kdefs();
    void kdefs(T_syntax_code* Kdefs);
    void start_lrk_enumerate(int Enum);
    void stop_lrk_enumerate(int Enum);
    int start_lrk_enumerate();
    int stop_lrk_enumerate();
    void start_err_enumerate(int Enum);
    void stop_err_enumerate(int Enum);
    int start_err_enumerate();
    int stop_err_enumerate();
    void start_rc_enumerate(int Enum);
    void stop_rc_enumerate(int Enum);
    int start_rc_enumerate();
    int stop_rc_enumerate();
    void start_T_enumerate(int Enum);
    void stop_T_enumerate(int Enum);
    int start_T_enumerate();
    int stop_T_enumerate();

    int total_T_enumerate();
    void total_T_enumerate(int Enum);
    int total_rc_enumerate();
    void total_rc_enumerate(int Enum);
    int total_err_enumerate();
    void total_err_enumerate(int Enum);
    int total_lrk_enumerate();
    void total_lrk_enumerate(int Enum);
    void total_enumerate(int Enum);
    int total_enumerate();
    void phrase_tree(AST* Tree);
    AST* phrase_tree();
    void add_cweb_marker(AST* Cweb);
    AST* cweb_marker();
    int total_no_subrules();
    void total_no_subrules(int Total_subrules);
    private: 
      T_syntax_code* kdefs_;
      T_identifier* filename_id_;
      T_identifier* namespace_id_;
		int start_lrk_enumerate_;
		int stop_lrk_enumerate_;
		int start_err_enumerate_;
		int stop_err_enumerate_;
		int start_rc_enumerate_;
		int stop_rc_enumerate_;
		int start_T_enumerate_;
		int stop_T_enumerate_;
		int total_enumerate_;
		int total_T_enumerate_;
		int total_rc_enumerate_;
		int total_err_enumerate_;
		int total_lrk_enumerate_;
		int total_no_subrules_;
      AST* phrase_tree_;
      AST* cweb_marker_;
    static void dtor_T_enum_phrase(yacco2::VOIDP This,yacco2::VOIDP P);
  };
  struct T_terminal_def:public yacco2::CAbs_lr1_sym{

    public:
    enum classification_typ {not_classed,err,rc,lrk,t};
    T_terminal_def();
    void remove_directives_from_map();
    std::map<std::string,CAbs_lr1_sym*>* directives_map();
    CAbs_lr1_sym* // 0 - ok, or error 
    add_directive_to_map(CAbs_lr1_sym* Directive,yacco2::Parser* P);

    std::string* t_name();
    void t_name(const char* Id);
    std::string* classsym();
    void classsym(const char* Id);
    bool autodelete();
    void autodelete(bool Ton); 
    bool autoabort();
    void autoabort(bool Ton); 
    classification_typ classification();      
    void classification(classification_typ C);
    void add_cweb_marker(AST* Cweb);
    AST* cweb_marker();
    void enum_id(int Id);
    int enum_id();
    private: 
      std::string t_name_;
      std::string class_sym_;
      bool auto_delete_;
      bool auto_abort_;
      map<std::string,CAbs_lr1_sym*> directives_map_;
      classification_typ classification_;
      AST* cweb_marker_;
      int enum_id_; 
    static void dtor_T_terminal_def(yacco2::VOIDP This,yacco2::VOIDP P);
  };
  struct table_entry:public yacco2::CAbs_lr1_sym{

    public:
	enum entry_typ {terminal,rule,keyword,unknown,thread};
	enum defined_or_used_typ {defed,used};
	table_entry();
	bool vacant_;
	bool defined_;
	bool used_;
	entry_typ type_;
	CAbs_lr1_sym* symbol_;
	const char* key_;
	int pos_;
    int key_len_;
    };
  struct T_sym_tbl_report_card:public yacco2::CAbs_lr1_sym{

    public:
    enum status {okay,failure,fatal};
    enum action {not_fnd,fnd,inserted,aborted,unknown};
    T_sym_tbl_report_card();
    T_sym_tbl_report_card::status status_;
    T_sym_tbl_report_card::action action_;
    table_entry* tbl_entry_;
    CAbs_lr1_sym* err_entry_;
    int pos_;
    int key_len_;
    };
  struct T_terminals_phrase:public yacco2::CAbs_lr1_sym{

    public:
    T_terminals_phrase();
    T_identifier* filename_id();
    void filename_id(T_identifier* Id);
    T_identifier* namespace_id();
    void namespace_id(T_identifier* Id);
    void destroy_alphabet();
    std::map<std::string,NS_yacco2_terminals::T_terminal_def*>* alphabet();
    CAbs_lr1_sym* add_t_to_alphabet(T_terminal_def* T,yacco2::Parser* P);
    std::vector<T_terminal_def*>* crt_order();
    T_syntax_code* terminals_refs_code();
    void terminals_refs_code(T_syntax_code* Code);
    T_syntax_code* terminals_sufx_code();
    void terminals_sufx_code(T_syntax_code* Code);
    void phrase_tree(AST* Tree);
    AST* phrase_tree();
    void add_cweb_marker(AST* Cweb);
    AST* cweb_marker();
    private: 
      T_identifier* filename_id_;
      T_identifier* namespace_id_;
      std::map<std::string,NS_yacco2_terminals::T_terminal_def*> alphabet_;
      std::vector<T_terminal_def*> crt_order_;
      T_syntax_code* terminals_refs_code_;
      T_syntax_code* terminals_sufx_code_;
      AST* phrase_tree_;
      AST* cweb_marker_;
    static void dtor_T_terminals_phrase(yacco2::VOIDP This,yacco2::VOIDP P);
  };
  struct T_error_symbols_phrase:public yacco2::CAbs_lr1_sym{

    public:
    T_error_symbols_phrase();
    T_identifier* filename_id();
    void filename_id(T_identifier* Id);
    T_identifier* namespace_id();
    void namespace_id(T_identifier* Id);
    void destroy_alphabet();
    std::map<std::string,NS_yacco2_terminals::T_terminal_def*>* alphabet();
    CAbs_lr1_sym* add_t_to_alphabet(T_terminal_def* T,yacco2::Parser* P);
    std::vector<T_terminal_def*>* crt_order();
    void phrase_tree(AST* Tree);
    AST* phrase_tree();
    void add_cweb_marker(AST* Cweb);
    AST* cweb_marker();
    private: 
      T_identifier* filename_id_;
      T_identifier* namespace_id_;
      std::map<std::string,NS_yacco2_terminals::T_terminal_def*> alphabet_;
      std::vector<T_terminal_def*> crt_order_;
      AST* phrase_tree_;
      AST* cweb_marker_;
    static void dtor_T_error_symbols_phrase(yacco2::VOIDP This,yacco2::VOIDP P);
  };
  struct T_lr1_k_phrase:public yacco2::CAbs_lr1_sym{

    public:
    T_lr1_k_phrase();
    T_identifier* filename_id();
    void filename_id(T_identifier* Id);
    T_identifier* namespace_id();
    void namespace_id(T_identifier* Id);
    void destroy_alphabet();
    std::map<std::string,NS_yacco2_terminals::T_terminal_def*>* alphabet();
    CAbs_lr1_sym* add_t_to_alphabet(T_terminal_def* T,yacco2::Parser* P);
    std::vector<T_terminal_def*>* crt_order();
    T_syntax_code* lrk_sufx_code();
    void lrk_sufx_code(T_syntax_code* Code);
    void phrase_tree(AST* Tree);
    AST* phrase_tree();
    void add_cweb_marker(AST* Cweb);
    AST* cweb_marker();
    private: 
      T_identifier* filename_id_;
      T_identifier* namespace_id_;
      std::map<std::string,NS_yacco2_terminals::T_terminal_def*> alphabet_;
      std::vector<T_terminal_def*> crt_order_;
      T_syntax_code* lrk_sufx_code_;
      AST* phrase_tree_;
      AST* cweb_marker_;
    static void dtor_T_lr1_k_phrase(yacco2::VOIDP This,yacco2::VOIDP P);
  };
  struct T_rc_phrase:public yacco2::CAbs_lr1_sym{

    public:
    T_rc_phrase();
    T_identifier* filename_id();
    void filename_id(T_identifier* Id);
    T_identifier* namespace_id();
    void namespace_id(T_identifier* Id);
    void destroy_alphabet();
    std::map<std::string,NS_yacco2_terminals::T_terminal_def*>* alphabet();
    CAbs_lr1_sym* add_t_to_alphabet(T_terminal_def* T,yacco2::Parser* P);
    std::vector<T_terminal_def*>* crt_order();
    void phrase_tree(AST* Tree);
    AST* phrase_tree();
    void add_cweb_marker(AST* Cweb);
    AST* cweb_marker();
    private: 
      T_identifier* filename_id_;
      T_identifier* namespace_id_;
      std::map<std::string,NS_yacco2_terminals::T_terminal_def*> alphabet_;
      std::vector<T_terminal_def*> crt_order_;
      AST* phrase_tree_;
      AST* cweb_marker_;
    static void dtor_T_rc_phrase(yacco2::VOIDP This,yacco2::VOIDP P);
  };
  struct T_rule_lhs_phrase:public yacco2::CAbs_lr1_sym{

    public:
    T_rule_lhs_phrase();
    void remove_lhs_directives();
    std::map<std::string,CAbs_lr1_sym*>* lhs_directives_map();
    CAbs_lr1_sym* // 0 - ok, or error 
    add_directive_to_lhs(CAbs_lr1_sym* Directive,yacco2::Parser* P);
    void phrase_tree(AST* Tree);
    AST* phrase_tree();
    void add_cweb_marker(AST* Cweb);
    AST* cweb_marker();
    private: 
      map<std::string,CAbs_lr1_sym*> lhs_directives_map_;
      AST* phrase_tree_;
      AST* cweb_marker_;
    static void dtor_T_rule_lhs_phrase(yacco2::VOIDP This,yacco2::VOIDP P);
  };
  struct T_parallel_monitor_phrase:public yacco2::CAbs_lr1_sym{

    public:
    T_parallel_monitor_phrase();
    void remove_mntr_directives();
    std::map<std::string,CAbs_lr1_sym*>* mntr_directives_map();
    CAbs_lr1_sym* // 0 - ok, or error 
    add_directive_to_mntr(CAbs_lr1_sym* Directive,yacco2::Parser* P);
    void phrase_tree(AST* Tree);
    AST* phrase_tree();
    private: 
      map<std::string,CAbs_lr1_sym*> mntr_directives_map_;
      AST* phrase_tree_;
    static void dtor_T_parallel_monitor_phrase(yacco2::VOIDP This,yacco2::VOIDP P);
  };
  struct rule_def:public yacco2::CAbs_lr1_sym{

    public:
    rule_def(const char* Key);
    T_rule_lhs_phrase* rule_lhs();
    void rule_lhs(T_rule_lhs_phrase* Lhs);
	int rule_no();
	void rule_no(int Rule_no);
	int lhs_use_cnt();
	void lhs_use_cnt(int Use_cnt);
	int rhs_use_cnt();
	void rhs_use_cnt(int Use_cnt);
	bool recursive();
	void recursive(bool Recursive);
    
    void parallel_mntr(T_parallel_monitor_phrase* Mntr);
    T_parallel_monitor_phrase* parallel_mntr();
    T_subrules_phrase* subrules();
    void subrules(T_subrules_phrase* Subrules);

    std::string* rule_name();
    bool autodelete();
    void autodelete(bool Ton); 
    bool autoabort();
    void autoabort(bool Ton); 
    bool epsilon();
    void epsilon(bool Ton); 
    bool derive_t();
    void derive_t(bool Ton); 
    void add_cweb_marker(AST* Cweb);
    AST* cweb_marker();
    void bld_its_tree();
    AST* rule_s_tree();
    void enum_id(int Id);
    int enum_id();
    std::set<T_in_stbl*>* first_set();
    void add_to_first_set(T_in_stbl& T);
    std::set<T_called_thread_eosubrule*>* called_thread_first_set();
    void add_to_called_thread_first_set(T_called_thread_eosubrule* T);
    std::string* grammar_s_enumerate();
    void grammar_s_enumerate(const char* Enumerate);
    void add_closure_rule_making_up_first_set(rule_in_stbl* Rule);
    std::set<rule_in_stbl*>* closure_rules_making_up_first_set();
    void add_rule_adding_T_in_first_set(T_in_stbl* T,std::string* Rule_enumerate);
    std::map<T_in_stbl*,std::set<std::string*> >* rule_adding_T_in_first_set();
    AST* rule_use_skeleton(); 
    void rule_use_skeleton(AST* Tree);  
    private: 
      std::string rule_name_;
      T_parallel_monitor_phrase* parallel_mntr_;
      T_subrules_phrase* subrules_;
      T_rule_lhs_phrase* rule_lhs_;
      bool auto_delete_;
      bool auto_abort_;
      AST* cweb_marker_;
      AST* its_tree_;
      int enum_id_;
	  int rule_no_;
	  int lhs_use_cnt_;// for rule recycling
	  int rhs_use_cnt_;// for rule recycling
	  bool recursive_;
      bool epsilon_;
      bool derive_t_;
      std::string grammar_s_enumerate_;
      std::set<T_in_stbl*> first_set_;
      std::set<T_called_thread_eosubrule*> called_thread_first_set_;
      std::set<rule_in_stbl*> closure_rules_making_up_first_set_;
      std::map<T_in_stbl*,std::set<std::string*> > rules_adding_T_in_first_set_;
      AST* rule_use_skeleton_;
     static void dtor_rule_def(yacco2::VOIDP This,yacco2::VOIDP P);
  };
  struct T_rules_phrase:public yacco2::CAbs_lr1_sym{

    public:
    T_rules_phrase();
    void destroy_rules_alphabet();
    std::map<std::string,rule_def*>* rules_alphabet();
    CAbs_lr1_sym* add_r_to_alphabet(rule_def* R,yacco2::Parser* P);
    std::vector<rule_def*>* crt_order();
    void rules_tree(AST* Tree);
    void phrase_tree(AST* Tree);
    AST* phrase_tree();
    void add_cweb_marker(AST* Cweb);
    AST* cweb_marker();
    private: 
      std::map<std::string,rule_def*> rules_alphabet_;
      std::vector<rule_def*> crt_order_;
      AST* phrase_tree_;
      AST* cweb_marker_;
    static void dtor_T_rules_phrase(yacco2::VOIDP This,yacco2::VOIDP P);
  };
  struct T_subrule_def:public yacco2::CAbs_lr1_sym{

    public:
    T_subrule_def();
    int subrule_no_of_rule();
    void subrule_no_of_rule(int Subrule_no);
    void remove_subrule_directives();
    std::map<std::string,CAbs_lr1_sym*>* subrule_directives();
    CAbs_lr1_sym* // 0 - ok, or error 
    add_directive_to_subrule(CAbs_lr1_sym* Directive,yacco2::Parser* P);
	std::vector<CAbs_lr1_sym*>* subrule_elems();
	void add_elem_to_subrule_vector(CAbs_lr1_sym* Elem);
	int no_of_elems();
    void remove_subrule_elems_from_vector();
    bool epsilon();
    void epsilon(bool Epsilon);
    bool derive_t();
    void derive_t(bool Epsilon);
    rule_def* its_rule_def();
    void its_rule_def(rule_def* Its_rule_def);
    void add_cweb_marker(AST* Cweb);
    AST* cweb_marker();
    void bld_its_tree();
    AST* subrule_s_tree();
    std::string* grammar_s_enumerate();
    void grammar_s_enumerate(const char* Enumerate);
    int its_grammar_s_pos(); 
    void its_grammar_s_pos(int Pos);  
    private: 
      std::map<std::string,CAbs_lr1_sym*> subrule_directives_;
      std::vector<CAbs_lr1_sym*> subrule_elems_;
      int subrule_no_of_rule_;// rel 1
      int no_of_elems_;
      bool epsilon_;
      bool derive_t_;
      rule_def* its_rule_def_;
      AST* cweb_marker_;
      AST* its_tree_;
      int its_grammar_s_pos_;
      std::string grammar_s_enumerate_;
     static void dtor_T_subrule_def(yacco2::VOIDP This,yacco2::VOIDP P);
  };
  struct T_subrules_phrase:public yacco2::CAbs_lr1_sym{

    public:
    T_subrules_phrase();
    void destroy_subrules();
    std::vector<T_subrule_def*>* subrules();
    void add_sr_to_subrules(T_subrule_def* R);
    int no_subrules();
    void phrase_tree(AST* Tree);
    AST* phrase_tree();
    private: 
      std::vector<T_subrule_def*> subrules_;
      int no_subrules_;
      AST* phrase_tree_;
    static void dtor_T_subrules_phrase(yacco2::VOIDP This,yacco2::VOIDP P);
  };
  struct T_in_stbl:public yacco2::CAbs_lr1_sym{

    public:
    T_in_stbl(T_terminal_def* Fnd_T_in_stbl,CAbs_lr1_sym* Rc,yacco2::Parser* P);
    T_terminal_def* t_def();
    std::list<refered_T*>* xref_t();
    void add_T_into_xref(refered_T& T);
    void stbl_idx(yacco2::UINT Idx);
    int stbl_idx();
    private: 
      T_terminal_def* t_def_;
      std::list<refered_T*> xref_t_;
      int stbl_idx_;
    };
  struct refered_T:public yacco2::CAbs_lr1_sym{

    public:
    refered_T(T_in_stbl& Term_in_stbl);
    T_in_stbl* t_in_stbl();
    T_terminal_def* its_t_def();
    T_subrule_def* its_subrule_def();
    void its_subrule_def(T_subrule_def* Its_subrule);
    std::string* grammar_s_enumerate();
    void grammar_s_enumerate(const char* Enumerate);
    AST* tree_node();
    void tree_node(AST* Tree_node);
    rule_def* its_rule_def();
    int element_pos();
    void element_pos(int Pos);

    private: 
      T_in_stbl* t_in_stbl_;
      T_subrule_def* its_subrule_def_;
      std::string grammar_s_enumerate_;
      AST* tree_node_;
      int element_pos_;
    };
  struct rule_in_stbl:public yacco2::CAbs_lr1_sym{

    public:
    rule_in_stbl(rule_def& Rule_def);
    rule_def* r_def();
    std::list<refered_rule*>* xref_r();
    void add_R_into_xref(refered_rule& R);
    void stbl_idx(yacco2::UINT Idx);
    int stbl_idx();
    private:
      rule_def* r_def_;
      std::list<refered_rule*> xref_r_;
      int stbl_idx_;
    };
  struct refered_rule:public yacco2::CAbs_lr1_sym{

    public:
    refered_rule(rule_in_stbl& Rule_in_stbl);
    rule_in_stbl* Rule_in_stbl();
    T_subrule_def* its_subrule_def();
    void its_subrule_def(T_subrule_def* Its_subrule);
    std::string* grammar_s_enumerate();
    void grammar_s_enumerate(const char* Enumerate);
    AST* tree_node();
    void tree_node(AST* Tree_node);
    rule_def* its_rule_def();
    int element_pos();
    void element_pos(int Pos);
   private: 
      rule_in_stbl* rule_in_stbl_;
      T_subrule_def* its_subrule_def_;
      std::string grammar_s_enumerate_;
      AST* tree_node_;
      int element_pos_;
    };
  struct T_transitive:public yacco2::CAbs_lr1_sym{
    T_transitive();
  };
  struct T_grammar_name:public yacco2::CAbs_lr1_sym{
    T_grammar_name();
  };
  struct T_thread_name:public yacco2::CAbs_lr1_sym{
    T_thread_name();
  };
  struct T_monolithic:public yacco2::CAbs_lr1_sym{
    T_monolithic();
  };
  struct T_no_of_T:public yacco2::CAbs_lr1_sym{
    T_no_of_T();
  };
  struct T_list_of_native_first_set_terminals:public yacco2::CAbs_lr1_sym{
    T_list_of_native_first_set_terminals();
  };
  struct T_end_list_of_native_first_set_terminals:public yacco2::CAbs_lr1_sym{
    T_end_list_of_native_first_set_terminals();
  };
  struct T_list_of_transitive_threads:public yacco2::CAbs_lr1_sym{
    T_list_of_transitive_threads();
  };
  struct T_end_list_of_transitive_threads:public yacco2::CAbs_lr1_sym{
    T_end_list_of_transitive_threads();
  };
  struct T_emitfile:public yacco2::CAbs_lr1_sym{
    T_emitfile();
  };
  struct T_preamble:public yacco2::CAbs_lr1_sym{
    T_preamble();
  };
  struct T_end_preamble:public yacco2::CAbs_lr1_sym{
    T_end_preamble();
  };
  struct T_T_alphabet:public yacco2::CAbs_lr1_sym{
    T_T_alphabet();
  };
  struct T_end_T_alphabet:public yacco2::CAbs_lr1_sym{
    T_end_T_alphabet();
  };
  struct T_file_of_T_alphabet:public yacco2::CAbs_lr1_sym{
    T_file_of_T_alphabet();
  };
  struct T_attributes:public yacco2::CAbs_lr1_sym{

	 public:
T_attributes(const char* Fully_qualified_T_name,int Enum);
std::string fully_qualified_T_name_;
		int T_enum_;		
    };
  struct tth_in_stbl:public yacco2::CAbs_lr1_sym{

    public:
    tth_in_stbl(T_attributes* Fnd_T_in_stbl,CAbs_lr1_sym* Rc,yacco2::Parser* P);
    T_attributes* t_in_stbl();
    void stbl_idx(yacco2::UINT Idx);
    int stbl_idx();
    private: 
      T_attributes* t_in_stbl_;
      int stbl_idx_;
    };
  struct thread_attributes:public yacco2::CAbs_lr1_sym{

	 public:
	thread_attributes(const char* Fully_qualified_th_name);
	thread_attributes
		(const char* Fully_qualified_th_name
		,char Transitive
		,T_c_string* Grammar_name
		,T_c_string* Name_space_name
		,T_c_string* Thread_name
		,char Monolithic
		,T_c_string* File_name
		,std::vector<int>& List_of_Ts
		,std::vector<thread_attributes*>& List_of_transitive_thds
                 ,T_c_string* Fsm_comments);
            std::string fully_qualified_th_name_;
		char transitive_;
		T_c_string* grammar_file_name_;
		T_c_string* name_space_name_;
		T_c_string* thread_name_;
		char monolithic_;
		T_c_string* file_name_;
		std::vector<int> list_of_Ts_;
		std::set<int> fs_;
		std::vector<thread_attributes*> list_of_transitive_threads_;
		int th_enum_;	
		T_c_string* fsm_comments_;
		AST* called_thread_graph_;
	
    };
  struct th_in_stbl:public yacco2::CAbs_lr1_sym{

    public:
    th_in_stbl(thread_attributes* Fnd_th_in_stbl);
    thread_attributes* thread_in_stbl();
    void stbl_idx(yacco2::UINT Idx);
    int stbl_idx();
    private: 
      thread_attributes* th_in_stbl_;
      int stbl_idx_;
    };
  struct kw_in_stbl:public yacco2::CAbs_lr1_sym{

    public:
    kw_in_stbl(CAbs_lr1_sym* Fnd_kw_in_stbl);
    CAbs_lr1_sym* keyword_in_stbl();
    void stbl_idx(yacco2::UINT Idx);
    int stbl_idx();
    private: 
      CAbs_lr1_sym* kw_in_stbl_;
      int stbl_idx_;
    };
  struct T_la_expr_src:public yacco2::CAbs_lr1_sym{

    public:
    T_la_expr_src();
    yacco2::TOKEN_GAGGLE* la_tok_can();
    void zero_la_tok_can();
    private: 
      yacco2::TOKEN_GAGGLE* la_tok_can_;
    };
  struct T_eosubrule:public yacco2::CAbs_lr1_sym{

    public:
    T_eosubrule();
    T_subrule_def* its_subrule_def();
    void its_subrule_def(T_subrule_def* Its_subrule);
    std::string* grammar_s_enumerate();
    void grammar_s_enumerate(const char* Enumerate);
    AST* tree_node();
    void tree_node(AST* Tree_node);
    rule_def* its_rule_def();
    int element_pos();
    void element_pos(int Pos);

    private: 
      T_subrule_def* its_subrule_def_;
      std::string grammar_s_enumerate_;
      AST* tree_node_;
     int element_pos_;
    };
  struct T_called_thread_eosubrule:public yacco2::CAbs_lr1_sym{

    public:
    T_called_thread_eosubrule(T_identifier* Ns,T_identifier* Thread_name);
    T_subrule_def* its_subrule_def();
    void its_subrule_def(T_subrule_def* Its_subrule);
    std::string* grammar_s_enumerate();
    void grammar_s_enumerate(const char* Enumerate);
    AST* tree_node();
    void tree_node(AST* Tree_node);
    rule_def* its_rule_def();
      T_identifier* ns();
      T_identifier* called_thread_name();
    int element_pos();
    void element_pos(int Pos);
    private: 
      T_subrule_def* its_subrule_def_;
      std::string grammar_s_enumerate_;
      AST* tree_node_;
      T_identifier* ns_;
      T_identifier* called_thread_name_;
     int element_pos_;
    };
  struct T_null_call_thread_eosubrule:public yacco2::CAbs_lr1_sym{

    public:
    T_null_call_thread_eosubrule();
    T_subrule_def* its_subrule_def();
    void its_subrule_def(T_subrule_def* Its_subrule);
    std::string* grammar_s_enumerate();
    void grammar_s_enumerate(const char* Enumerate);
    AST* tree_node();
    void tree_node(AST* Tree_node);
    rule_def* its_rule_def();
    int element_pos();
    void element_pos(int Pos);
   private: 
      T_subrule_def* its_subrule_def_;
      std::string grammar_s_enumerate_;
      AST* tree_node_;
     int element_pos_;
    };
  struct T_cweb_comment:public yacco2::CAbs_lr1_sym{

    public:
    T_cweb_comment(const std::string& Comment_data);
    std::string* comment_data();
    private:std::string comment_data_;
    };
  struct T_grammar_phrase:public yacco2::CAbs_lr1_sym{
    T_grammar_phrase();
  };
  struct T_cweb_marker:public yacco2::CAbs_lr1_sym{

    public:
    T_cweb_marker(AST* Node);
    T_cweb_marker();
    AST* ast();
    private:AST* ast_;
    };
  struct T_lint:public yacco2::CAbs_lr1_sym{

    T_lint();
    };
  struct T_list_of_used_threads:public yacco2::CAbs_lr1_sym{
    T_list_of_used_threads();
  };
  struct T_end_list_of_used_threads:public yacco2::CAbs_lr1_sym{
    T_end_list_of_used_threads();
  };
}//namespace
#endif
