# frozen_string_literal: true

class DropMessageFromVulnerabilityOccurrences < Gitlab::Database::Migration[2.1]
  disable_ddl_transaction!

  def up
    remove_column :vulnerability_occurrences, :message
  end

  def down
    unless column_exists?(:vulnerability_occurrences, :message)
      add_column :vulnerability_occurrences, :message, :text  # rubocop:disable Migration/SchemaAdditionMethodsNoPost
    end

    add_check_constraint(:vulnerability_occurrences, 'char_length(message) <= 3000', 'check_df6dd20219')
  end
end
