# frozen_string_literal: true

# Placeholder class for model that is implemented in EE
class Vulnerability < ApplicationRecord
  include EachBatch

  alias_attribute :vulnerability_id, :id

  scope :with_projects, -> { includes(:project) }

  validates :cvss, json_schema: { filename: "vulnerability_cvss_vectors", draft: 7 }
  attribute :cvss, :ind_jsonb

  def self.link_reference_pattern
    nil
  end

  def self.reference_prefix
    '[vulnerability:'
  end

  def self.reference_postfix
    ']'
  end
end

Vulnerability.prepend_mod
