# frozen_string_literal: true

class IndexVulnerabilityFindingSignaturesOnProjectId < Gitlab::Database::Migration[2.2]
  milestone '17.2'
  disable_ddl_transaction!

  INDEX_NAME = 'index_vulnerability_finding_signatures_on_project_id'

  def up
    add_concurrent_index :vulnerability_finding_signatures, :project_id, name: INDEX_NAME
  end

  def down
    remove_concurrent_index_by_name :vulnerability_finding_signatures, INDEX_NAME
  end
end
