#! /bin/sh
#
# CDDL HEADER START
#
# The contents of this file are subject to the terms of the
# Common Development and Distribution License (the "License").
# You may not use this file except in compliance with the License.
#
# You can obtain a copy of the license at usr/src/OPENSOLARIS.LICENSE
# or http://www.opensolaris.org/os/licensing.
# See the License for the specific language governing permissions
# and limitations under the License.
#
# When distributing Covered Code, include this CDDL HEADER in each
# file and include the License file at usr/src/OPENSOLARIS.LICENSE.
# If applicable, add the following below this CDDL HEADER, with the
# fields enclosed by brackets "[]" replaced with your own identifying
# information: Portions Copyright [yyyy] [name of copyright owner]
#
# CDDL HEADER END
#
# Copyright 2003 Sun Microsystems, Inc. All rights reserved.
# Use is subject to license terms.
#
# @(#)options.sh 1.27 06/12/12
#

##-----------------------------------------------------------------
##  Build options
##  TeamWare can be built with different options:
##	OPTION				DEFAULT	SWITCH
##	-g debugging 		OFF	debug-$variant.opt
##	-g & -DDEBUG debugging	OFF	DEBUG-$variant.opt
##	licensing enabled		ON	no_license.opt
##	build source browser info	OFF	sb-$variant.opt
##	usage tracking enabled	OFF	usage_tracking.opt
##
## Note that those with $variant in their names are variant-specific.
## 
##  To change the default value of any option, create a file in $(TOP) with the
##  name of the switch.  E.g., to create a workspace with debugging enabled,
##  create the file
##	$(TOP)/debug.opt
##  before doing a make.  The make need not be done for the entire workspace.
##
##  Switches are set in places where they are needed.
##
## Note that the ability to disable licensing is commented out in the places
## where it is (currently, Jan 24 1996, used): lib/{cli,mgui}/src/Makefile
## so that we don't accidentally ship with licensing disabled.  You also will have
## to manually make the switch in $(TOP)/exe executable.


echo '# This file is generated by $(TOP)/exe/options.sh'
echo "# *** DO NOT EDIT THIS FILE DIRECTLY ***"

TOP=$1
VARIANT=$2

echo " "
echo "#	Debug options"
echo "#"
if [ -f $TOP/DEBUG-$VARIANT.opt ]; then
  echo CFLAGS +=-g
  echo CCFLAGS +=-g
  echo CPPFLAGS += -DDEBUG
  echo DEBUGLIB = -g
  echo 'MOTIF_LD_RUN_PATH += -R$(CCR_ROOT_AUX)/$(VARIANT)/lib:$(CCR_ROOT)/$(VARIANT)/lib'
elif [ -f $TOP/debug-$VARIANT.opt ]; then
  echo CFLAGS +=-g
  echo CCFLAGS +=-g
  echo DEBUGLIB = -g
  echo 'MOTIF_LD_RUN_PATH += -R$(CCR_ROOT_AUX)/$(VARIANT)/lib:$(CCR_ROOT)/$(VARIANT)/lib'
else
  echo CFLAGS +=-O
  echo CCFLAGS +=-O
  echo CPPFLAGS += -DNDEBUG
  echo LDFLAGS += -norunpath -i -s
  echo BDYNAMIC = -Bdynamic
  echo BSTATIC = -Bstatic
fi

if [ -f $TOP/no_license.opt ]; then
  echo " "
  echo "#	Licensing options"
  echo "#"
  echo -DTW_LICENSE
fi

if [ -f $TOP/sb-$VARIANT.opt ]; then
  echo " "
  echo "#	Source Browser options"
  echo "#"
  echo CFLAGS += -sb
  echo CCFLAGS += -sb
fi

if [ -f $TOP/usage_tracking.opt ]; then
  echo " "
  echo "#	Usage tracking options"
  echo "#"
  echo CPPFLAGS += -DUSAGE_TRACKING
fi

echo CCFLAGS += -D_FILE_OFFSET_BITS=64
