/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.fetch;

import org.eclipse.egit.core.internal.hosts.GitHosts;
import org.eclipse.egit.ui.internal.UIText;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public enum GitServer {
    GITHUB(GitHosts.ServerType.GITHUB){

        @Override
        public String getName() {
            return "GitHub";
        }

        @Override
        public String getProposalLabel() {
            return UIText.GitServer_PullRequestContentAssistLabel;
        }

        @Override
        public String getBranchName() {
            return UIText.GitServer_PullRequestRefNameSuggestion;
        }

        @Override
        public String getChangeLabel() {
            return UIText.GitServer_PullRequestLabel;
        }

        @Override
        public String getChangeNameSingular() {
            return UIText.GitServer_PullRequestSingular;
        }

        @Override
        public String getChangeNamePlural() {
            return UIText.GitServer_PullRequestPlural;
        }

        @Override
        public String getWizardTitle() {
            return UIText.GitServer_WizardTitleGitHub;
        }
    }
    ,
    GITLAB(GitHosts.ServerType.GITLAB){

        @Override
        public String getName() {
            return "GitLab";
        }

        @Override
        public String getProposalLabel() {
            return UIText.GitServer_MergeRequestContentAssistLabel;
        }

        @Override
        public String getBranchName() {
            return UIText.GitServer_MergeRequestRefNameSuggestion;
        }

        @Override
        public String getChangeLabel() {
            return UIText.GitServer_MergeRequestLabel;
        }

        @Override
        public String getChangeNameSingular() {
            return UIText.GitServer_MergeRequestSingular;
        }

        @Override
        public String getChangeNamePlural() {
            return UIText.GitServer_MergeRequestPlural;
        }

        @Override
        public String getWizardTitle() {
            return UIText.GitServer_WizardTitleGitLab;
        }
    }
    ,
    GITEA(GitHosts.ServerType.GITEA){

        @Override
        public String getName() {
            return "Gitea";
        }

        @Override
        public String getProposalLabel() {
            return UIText.GitServer_PullRequestContentAssistLabel;
        }

        @Override
        public String getBranchName() {
            return UIText.GitServer_PullRequestRefNameSuggestion;
        }

        @Override
        public String getChangeLabel() {
            return UIText.GitServer_PullRequestLabel;
        }

        @Override
        public String getChangeNameSingular() {
            return UIText.GitServer_PullRequestSingular;
        }

        @Override
        public String getChangeNamePlural() {
            return UIText.GitServer_PullRequestPlural;
        }

        @Override
        public String getWizardTitle() {
            return UIText.GitServer_WizardTitleGitea;
        }
    };

    private final GitHosts.ServerType serverType;

    private GitServer(GitHosts.ServerType serverType) {
        this.serverType = serverType;
    }

    public GitHosts.ServerType getType() {
        return this.serverType;
    }

    public abstract String getName();

    public abstract String getProposalLabel();

    public abstract String getBranchName();

    public abstract String getChangeLabel();

    public abstract String getChangeNameSingular();

    public abstract String getChangeNamePlural();

    public abstract String getWizardTitle();
}

