/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.application.handlers;

import java.util.Map;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.Status;
import org.eclipse.fordiac.ide.application.Messages;
import org.eclipse.fordiac.ide.application.commands.ResizeGroupOrSubappCommand;
import org.eclipse.fordiac.ide.application.editparts.SubAppForFBNetworkEditPart;
import org.eclipse.fordiac.ide.application.editparts.UISubAppNetworkEditPart;
import org.eclipse.fordiac.ide.model.commands.change.ToggleSubAppRepresentationCommand;
import org.eclipse.fordiac.ide.model.libraryElement.Resource;
import org.eclipse.fordiac.ide.model.libraryElement.SubApp;
import org.eclipse.fordiac.ide.ui.editors.EditorUtils;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.GraphicalViewer;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CommandStack;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.commands.ICommandService;
import org.eclipse.ui.commands.IElementUpdater;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.ui.menus.UIElement;

public class ToggleSubAppRepresentation
extends AbstractHandler
implements IElementUpdater {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        Object object;
        StructuredSelection selection = (StructuredSelection)HandlerUtil.getCurrentSelection((ExecutionEvent)event);
        SubApp subapp = (SubApp)((EditPart)selection.getFirstElement()).getModel();
        Object cmd = new ToggleSubAppRepresentationCommand(subapp);
        if (!subapp.isUnfolded() && (object = selection.getFirstElement()) instanceof SubAppForFBNetworkEditPart) {
            SubAppForFBNetworkEditPart subAppEP = (SubAppForFBNetworkEditPart)object;
            cmd = new ResizeGroupOrSubappCommand((GraphicalEditPart)subAppEP, (Command)cmd);
        }
        CommandStack commandStack = (CommandStack)HandlerUtil.getActiveEditor((ExecutionEvent)event).getAdapter(CommandStack.class);
        if (cmd.canExecute()) {
            commandStack.execute((Command)cmd);
        }
        ToggleSubAppRepresentation.requestChange();
        return Status.OK_STATUS;
    }

    public void setEnabled(Object evaluationContext) {
        Object selection = HandlerUtil.getVariable((Object)evaluationContext, (String)"selection");
        SubApp subApp = ToggleSubAppRepresentation.getSelectedSubApp(selection);
        boolean isUntypedSubapp = subApp != null && !subApp.isTyped();
        boolean isInResource = subApp != null && subApp.eContainer().eContainer() instanceof Resource;
        this.setBaseEnabled(isUntypedSubapp && !isInResource);
    }

    public void updateElement(UIElement element, Map parameters) {
        GraphicalViewer viewer;
        EditPart editPart;
        Object object;
        IEditorPart currentActiveEditor = EditorUtils.getCurrentActiveEditor();
        if (currentActiveEditor != null && (object = (editPart = (EditPart)(viewer = (GraphicalViewer)currentActiveEditor.getAdapter(GraphicalViewer.class)).getSelectedEditParts().get(0)).getModel()) instanceof SubApp) {
            SubApp subApp = (SubApp)object;
            if (subApp.isUnfolded()) {
                element.setText(Messages.ToggleSubAppRepresentation_Collapse);
            } else {
                element.setText(Messages.ToggleSubAppRepresentation_Expand);
            }
        }
    }

    private static void requestChange() {
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        ICommandService commandService = (ICommandService)window.getService(ICommandService.class);
        if (commandService != null) {
            commandService.refreshElements("org.eclipse.fordiac.ide.application.commands.expandSubApp", null);
        }
    }

    private static SubApp getSelectedSubApp(Object selection) {
        IStructuredSelection structSel;
        if (selection instanceof IStructuredSelection && !(structSel = (IStructuredSelection)selection).isEmpty() && structSel.size() == 1) {
            return ToggleSubAppRepresentation.getSubApp(structSel.getFirstElement());
        }
        return null;
    }

    private static SubApp getSubApp(Object currentElement) {
        if (currentElement instanceof SubApp) {
            SubApp subApp = (SubApp)currentElement;
            return subApp;
        }
        if (currentElement instanceof SubAppForFBNetworkEditPart) {
            SubAppForFBNetworkEditPart subAppNetworkEP = (SubAppForFBNetworkEditPart)currentElement;
            return subAppNetworkEP.getModel();
        }
        if (currentElement instanceof UISubAppNetworkEditPart) {
            return (SubApp)((UISubAppNetworkEditPart)((Object)currentElement)).getModel().eContainer();
        }
        return null;
    }
}

