/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.application.policies;

import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.fordiac.ide.application.editparts.IContainerEditPart;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.requests.ChangeBoundsRequest;
import org.eclipse.gef.tools.ResizeTracker;

class ContainerResizeTracker
extends ResizeTracker {
    private Rectangle minBounds;

    public ContainerResizeTracker(IContainerEditPart owner, int direction) {
        super((GraphicalEditPart)owner, direction);
    }

    protected IContainerEditPart getOwner() {
        return (IContainerEditPart)super.getOwner();
    }

    protected Dimension getMinimumSizeFor(ChangeBoundsRequest request) {
        Rectangle bounds = this.getOwner().getFigure().getBounds();
        int minWidth = this.getMinWidth(bounds, this.getResizeDirection());
        int minHeight = this.getMinHeight(bounds, this.getResizeDirection());
        return new Dimension(minWidth, minHeight);
    }

    protected boolean handleDragStarted() {
        this.updateMinBounds();
        return super.handleDragStarted();
    }

    private void updateMinBounds() {
        Rectangle containerBounds = this.getOwner().getFigure().getBounds();
        GraphicalEditPart contentEP = this.getOwner().getContentEP();
        if (contentEP != null) {
            Rectangle contentFigureBounds = contentEP.getFigure().getBounds();
            this.minBounds = this.getOwner().getMinContentBounds();
            this.minBounds.x -= contentFigureBounds.x - containerBounds.x;
            this.minBounds.y -= contentFigureBounds.y - containerBounds.y;
            this.minBounds.width += containerBounds.width - contentFigureBounds.width;
            this.minBounds.height += containerBounds.height - contentFigureBounds.height;
        } else {
            this.minBounds = this.getOwner().getDefaultContentBounds();
        }
    }

    private int getMinHeight(Rectangle bounds, int resizeDirection) {
        int height = this.minBounds.height;
        switch (resizeDirection) {
            case 1: 
            case 9: 
            case 17: {
                height += bounds.height - (this.minBounds.y - bounds.y) - this.minBounds.height;
                break;
            }
            case 4: 
            case 12: 
            case 20: {
                height += this.minBounds.y - bounds.y;
                break;
            }
        }
        return height;
    }

    private int getMinWidth(Rectangle bounds, int resizeDirection) {
        int width = this.minBounds.width;
        switch (resizeDirection) {
            case 8: 
            case 9: 
            case 12: {
                width += bounds.width - (this.minBounds.x - bounds.x) - this.minBounds.width;
                break;
            }
            case 16: 
            case 17: 
            case 20: {
                width += this.minBounds.x - bounds.x;
                break;
            }
        }
        return width;
    }
}

