/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.model.eval.st;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.fordiac.ide.model.data.DirectlyDerivedType;
import org.eclipse.fordiac.ide.model.eval.Evaluator;
import org.eclipse.fordiac.ide.model.eval.EvaluatorException;
import org.eclipse.fordiac.ide.model.eval.EvaluatorPrepareException;
import org.eclipse.fordiac.ide.model.eval.st.StructuredTextEvaluator;
import org.eclipse.fordiac.ide.model.eval.value.Value;
import org.eclipse.fordiac.ide.model.eval.variable.Variable;
import org.eclipse.fordiac.ide.model.eval.variable.VariableEvaluator;
import org.eclipse.fordiac.ide.model.eval.variable.VariableOperations;
import org.eclipse.fordiac.ide.model.helpers.PackageNameHelper;
import org.eclipse.fordiac.ide.model.libraryElement.INamedElement;
import org.eclipse.fordiac.ide.model.libraryElement.LibraryElement;
import org.eclipse.fordiac.ide.structuredtextalgorithm.util.StructuredTextParseUtil;
import org.eclipse.fordiac.ide.structuredtextcore.stcore.STInitializerExpressionSource;
import org.eclipse.xtext.EcoreUtil2;

public class DirectlyDerivedTypeEvaluator
extends StructuredTextEvaluator
implements VariableEvaluator {
    private final DirectlyDerivedType directlyDerivedType;
    private STInitializerExpressionSource parseResult;

    public DirectlyDerivedTypeEvaluator(DirectlyDerivedType directlyDerivedType, Variable<?> context, Iterable<Variable<?>> variables, Evaluator parent) {
        super(directlyDerivedType.getName(), context, variables, parent);
        this.directlyDerivedType = directlyDerivedType;
    }

    public void prepare() {
        if (this.parseResult == null && this.directlyDerivedType.getInitialValue() != null && !this.directlyDerivedType.getInitialValue().isBlank()) {
            ArrayList<String> errors = new ArrayList<String>();
            ArrayList<String> warnings = new ArrayList<String>();
            ArrayList<String> infos = new ArrayList<String>();
            this.parseResult = this.parseInitialValue(errors, warnings, infos);
            errors.forEach(error -> this.error("Parse error: " + error));
            warnings.forEach(warning -> this.error("Parse warning: " + warning));
            infos.forEach(info -> this.error("Parse info: " + info));
            if (this.parseResult == null) {
                throw new EvaluatorPrepareException(errors.stream().collect(Collectors.joining(", ")), (Evaluator)this);
            }
        }
    }

    protected STInitializerExpressionSource parseInitialValue(List<String> errors, List<String> warnings, List<String> infos) {
        return StructuredTextParseUtil.parse((String)this.directlyDerivedType.getInitialValue(), (URI)(this.directlyDerivedType.eResource() != null ? this.directlyDerivedType.eResource().getURI() : null), (INamedElement)this.directlyDerivedType.getBaseType(), (LibraryElement)((LibraryElement)EcoreUtil2.getContainerOfType((EObject)this.directlyDerivedType, LibraryElement.class)), null, errors, warnings, infos);
    }

    public Value evaluate() throws EvaluatorException, InterruptedException {
        return this.evaluateVariable().getValue();
    }

    public Variable<?> evaluateVariable() throws EvaluatorException, InterruptedException {
        this.prepare();
        Variable result = VariableOperations.newVariable((String)this.directlyDerivedType.getName(), (INamedElement)this.evaluateResultType());
        if (this.parseResult != null && this.parseResult.getInitializerExpression() != null) {
            this.evaluateInitializerExpression(result, ((STInitializerExpressionSource)this.trap(this.parseResult)).getInitializerExpression());
        }
        return result;
    }

    public boolean validateVariable(List<String> errors, List<String> warnings, List<String> infos) throws EvaluatorException, InterruptedException {
        if (this.directlyDerivedType.getInitialValue() != null && !this.directlyDerivedType.getInitialValue().isBlank()) {
            return this.parseInitialValue(errors, warnings, infos) != null;
        }
        return true;
    }

    public INamedElement evaluateResultType() throws EvaluatorException, InterruptedException {
        return this.directlyDerivedType.getBaseType();
    }

    public boolean validateResultType(List<String> errors, List<String> warnings, List<String> infos) throws EvaluatorException, InterruptedException {
        return true;
    }

    public Set<String> getDependencies() {
        return Stream.concat(this.getTypeDependencies().stream(), this.getInitialValueDependencies().stream()).collect(Collectors.toSet());
    }

    protected Set<String> getTypeDependencies() {
        return Set.of(PackageNameHelper.getFullTypeName((LibraryElement)this.directlyDerivedType.getBaseType()));
    }

    protected Set<String> getInitialValueDependencies() {
        this.prepare();
        if (this.parseResult != null) {
            return StructuredTextParseUtil.collectUsedTypes((EObject)this.parseResult);
        }
        return Collections.emptySet();
    }

    public Object getSourceElement() {
        return this.directlyDerivedType;
    }
}

