/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.model.eval.st;

import java.lang.runtime.SwitchBootstraps;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.fordiac.ide.model.eval.Evaluator;
import org.eclipse.fordiac.ide.model.eval.EvaluatorException;
import org.eclipse.fordiac.ide.model.eval.EvaluatorPrepareException;
import org.eclipse.fordiac.ide.model.eval.st.StructuredTextEvaluator;
import org.eclipse.fordiac.ide.model.eval.value.Value;
import org.eclipse.fordiac.ide.model.eval.variable.Variable;
import org.eclipse.fordiac.ide.model.libraryElement.INamedElement;
import org.eclipse.fordiac.ide.model.libraryElement.LibraryElement;
import org.eclipse.fordiac.ide.structuredtextalgorithm.stalgorithm.STAlgorithm;
import org.eclipse.fordiac.ide.structuredtextalgorithm.stalgorithm.STMethod;
import org.eclipse.fordiac.ide.structuredtextalgorithm.util.StructuredTextParseUtil;
import org.eclipse.fordiac.ide.structuredtextcore.stcore.STExpressionSource;
import org.eclipse.fordiac.ide.structuredtextfunctioneditor.stfunction.STFunction;

public class ScopedExpressionEvaluator
extends StructuredTextEvaluator {
    private final String expression;
    private STExpressionSource parseResult;

    public ScopedExpressionEvaluator(String expression, Variable<?> context, Iterable<Variable<?>> variables, Evaluator parent) {
        super("anonymous", ScopedExpressionEvaluator.getContext(context, parent), ScopedExpressionEvaluator.getVariables(variables, parent), parent);
        this.expression = expression;
    }

    private static Variable<?> getContext(Variable<?> context, Evaluator parent) {
        if (context != null) {
            return context;
        }
        if (parent != null) {
            return parent.getContext();
        }
        return null;
    }

    private static Iterable<Variable<?>> getVariables(Iterable<Variable<?>> variables, Evaluator parent) {
        if (variables != null) {
            return variables;
        }
        if (parent != null) {
            return parent.getVariables().values();
        }
        return null;
    }

    public void prepare() {
        if (this.parseResult == null) {
            ArrayList errors = new ArrayList();
            ArrayList warnings = new ArrayList();
            ArrayList infos = new ArrayList();
            this.parseResult = StructuredTextParseUtil.parse((String)this.expression, null, (LibraryElement)this.getType(), this.getAdditionalScope(), errors, warnings, infos);
            errors.forEach(arg_0 -> ((ScopedExpressionEvaluator)this).error(arg_0));
            warnings.forEach(arg_0 -> ((ScopedExpressionEvaluator)this).warn(arg_0));
            infos.forEach(arg_0 -> ((ScopedExpressionEvaluator)this).info(arg_0));
            if (this.parseResult == null) {
                throw new EvaluatorPrepareException(errors.stream().collect(Collectors.joining(", ")), (Evaluator)this);
            }
        }
    }

    private LibraryElement getType() {
        INamedElement iNamedElement;
        if (this.getContext() != null && (iNamedElement = this.getContext().getType()) instanceof LibraryElement) {
            LibraryElement libraryElement = (LibraryElement)iNamedElement;
            return libraryElement;
        }
        return null;
    }

    protected List<? extends EObject> getAdditionalScope() {
        Evaluator parent = this.getParent();
        if (parent != null) {
            Object object = parent.getSourceElement();
            int n = 0;
            return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{STAlgorithm.class, STMethod.class, STFunction.class}, (Object)object, n)) {
                case 0 -> {
                    STAlgorithm algorithm = (STAlgorithm)object;
                    yield algorithm.getBody().getVarTempDeclarations();
                }
                case 1 -> {
                    STMethod method = (STMethod)object;
                    yield method.getBody().getVarDeclarations();
                }
                case 2 -> {
                    STFunction function = (STFunction)object;
                    yield function.getVarDeclarations();
                }
                default -> Collections.emptyList();
            };
        }
        return Collections.emptyList();
    }

    public Value evaluate() throws EvaluatorException, InterruptedException {
        this.prepare();
        return this.evaluateExpression(this.parseResult.getExpression());
    }

    public String getSourceElement() {
        return this.expression;
    }

    public Set<String> getDependencies() {
        this.prepare();
        if (this.parseResult != null) {
            return StructuredTextParseUtil.collectUsedTypes((EObject)this.parseResult);
        }
        return Collections.emptySet();
    }
}

