/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.library.ui.wizards;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.fordiac.ide.library.LibraryManager;
import org.eclipse.fordiac.ide.library.ui.Messages;
import org.eclipse.fordiac.ide.library.ui.wizards.ArchivedLibraryImportContentProvider;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.TreeViewerColumn;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.TreeItem;

public class ArchivedLibraryImportWizardPage
extends WizardPage {
    protected TreeViewer viewer;
    private Path selectedPath;
    private IProject selectedProject;

    protected ArchivedLibraryImportWizardPage(String pageName, StructuredSelection selection) {
        super(pageName);
        StructuredSelection sel = new StructuredSelection(selection.toList());
        if (!sel.isEmpty()) {
            IFolder folder;
            IContainer iContainer;
            Object object;
            Object object2 = sel.getFirstElement();
            if (object2 instanceof IProject) {
                IProject project;
                this.selectedProject = project = (IProject)object2;
            }
            if ((object = sel.getFirstElement()) instanceof IFolder && (iContainer = (folder = (IFolder)object).getParent()) instanceof IProject) {
                IProject project;
                this.selectedProject = project = (IProject)iContainer;
            }
        }
    }

    public void unzipAndImportArchive() throws IOException {
        LibraryManager.INSTANCE.extractLibrary(this.selectedPath, this.selectedProject, true, true);
    }

    protected void configureSelectionListener() {
        this.viewer.getTree().addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Path path;
                TreeItem item = (TreeItem)e.item;
                Object object = item.getData();
                if (object instanceof Path && !Files.isDirectory(path = (Path)object, new LinkOption[0])) {
                    ArchivedLibraryImportWizardPage.this.selectedPath = path;
                    ArchivedLibraryImportWizardPage.this.setPageComplete(ArchivedLibraryImportWizardPage.this.isComplete());
                }
            }
        });
    }

    public void setVisible(boolean visible) {
        this.viewer.setContentProvider((IContentProvider)new ArchivedLibraryImportContentProvider());
        this.viewer.setInput((Object)LibraryManager.INSTANCE.listDirectoriesContainingArchives());
        super.setVisible(visible);
    }

    public void createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        GridData gd = new GridData(4, 4, true, true);
        container.setLayoutData((Object)gd);
        GridLayout layout = new GridLayout(1, true);
        container.setLayout((Layout)layout);
        this.viewer = new TreeViewer(container, 2816);
        this.viewer.getTree().setHeaderVisible(true);
        this.viewer.getTree().setLinesVisible(true);
        this.viewer.getTree().setLayoutData((Object)new GridData(1808));
        this.configureSelectionListener();
        this.createColumns();
        this.setControl((Control)container);
        this.setPageComplete(false);
    }

    private void createColumns() {
        TreeViewerColumn viewerColumn = new TreeViewerColumn(this.viewer, 0);
        viewerColumn.getColumn().setWidth(500);
        viewerColumn.getColumn().setText(Messages.DirsWithArchives);
        viewerColumn.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                if (element instanceof Path) {
                    Path path = (Path)element;
                    return path.getFileName().toString();
                }
                return "";
            }
        });
    }

    protected boolean isComplete() {
        return !this.viewer.getStructuredSelection().isEmpty();
    }
}

