/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.model.commands.delete;

import java.util.Objects;
import java.util.Set;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.fordiac.ide.model.CheckableStructTreeNode;
import org.eclipse.fordiac.ide.model.commands.ScopedCommand;
import org.eclipse.fordiac.ide.model.commands.change.ChangeStructCommand;
import org.eclipse.fordiac.ide.model.libraryElement.Demultiplexer;
import org.eclipse.fordiac.ide.model.libraryElement.ErrorMarkerInterface;
import org.eclipse.fordiac.ide.model.libraryElement.IInterfaceElement;
import org.eclipse.fordiac.ide.model.libraryElement.MemberVarDeclaration;
import org.eclipse.gef.commands.Command;

public class DeleteDemuxPortCommand
extends Command
implements ScopedCommand {
    private Demultiplexer type;
    private final IInterfaceElement variable;
    private ChangeStructCommand cmd;
    private Demultiplexer oldMux;
    private final CheckableStructTreeNode node;

    public DeleteDemuxPortCommand(Demultiplexer type, CheckableStructTreeNode node) {
        this.type = Objects.requireNonNull(type);
        this.node = Objects.requireNonNull(node);
        this.variable = type.getMemberVars().stream().map(MemberVarDeclaration.class::cast).filter(member -> node.getPinName().equals(member.getName())).findAny().orElse(null);
    }

    public void execute() {
        this.node.updateNode(false);
        String newVisibleChildren = ((CheckableStructTreeNode)this.node.getTree().getRoot()).visibleToString();
        this.cmd = new ChangeStructCommand(this.type, newVisibleChildren);
        if (this.cmd.canExecute()) {
            this.cmd.execute();
        }
        this.oldMux = this.type;
        this.type = (Demultiplexer)this.cmd.getNewMux();
    }

    public boolean canExecute() {
        return this.variable != null && !(this.variable instanceof ErrorMarkerInterface) && this.variable.getOutputConnections().isEmpty();
    }

    public void redo() {
        this.node.updateNode(false);
        this.cmd.redo();
        this.type = (Demultiplexer)this.cmd.getNewMux();
    }

    public void undo() {
        this.node.updateNode(true);
        this.type = this.oldMux;
        this.cmd.undo();
    }

    public Demultiplexer getType() {
        return this.type;
    }

    @Override
    public Set<EObject> getAffectedObjects() {
        if (this.type.getFbNetwork() != null) {
            return Set.of(this.type.getFbNetwork());
        }
        return Set.of(this.type);
    }
}

