/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.ui.contentoutline;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import org.eclipse.core.expressions.Expression;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.Platform;
import org.eclipse.e4.core.contexts.ContextFunction;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.SubActionBars;
import org.eclipse.ui.contexts.IContextService;
import org.eclipse.ui.handlers.IHandlerService;
import org.eclipse.ui.internal.PartSite;
import org.eclipse.ui.internal.PopupMenuExtender;
import org.eclipse.ui.internal.contexts.NestableContextService;
import org.eclipse.ui.internal.expressions.ActivePartExpression;
import org.eclipse.ui.internal.handlers.LegacyHandlerService;
import org.eclipse.ui.internal.part.IPageSiteHolder;
import org.eclipse.ui.internal.services.INestable;
import org.eclipse.ui.internal.services.IServiceLocatorCreator;
import org.eclipse.ui.internal.services.IWorkbenchLocationService;
import org.eclipse.ui.internal.services.ServiceLocator;
import org.eclipse.ui.internal.services.WorkbenchLocationService;
import org.eclipse.ui.part.IPageSite;
import org.eclipse.ui.services.IServiceLocator;

public class MultiPageSite
implements IPageSite,
INestable {
    private ArrayList<PopupMenuExtender> menuExtenders;
    private final IWorkbenchPartSite partSite;
    private final IPageSite parentSite;
    private ISelectionProvider selectionProvider;
    private final ServiceLocator serviceLocator;
    private final SubActionBars subActionBars;
    private final IEclipseContext e4Context;
    private NestableContextService contextService;
    private boolean active = false;

    public MultiPageSite(IPageSite parentPageSite) {
        Assert.isNotNull((Object)parentPageSite);
        this.parentSite = parentPageSite;
        this.partSite = ((IWorkbenchLocationService)this.parentSite.getService(IWorkbenchLocationService.class)).getPartSite();
        this.subActionBars = new SubActionBars(parentPageSite.getActionBars(), (IServiceLocator)this);
        IServiceLocatorCreator slc = (IServiceLocatorCreator)this.parentSite.getService(IServiceLocatorCreator.class);
        this.e4Context = ((IEclipseContext)parentPageSite.getService(IEclipseContext.class)).createChild("PageSite");
        this.serviceLocator = (ServiceLocator)slc.createServiceLocator((IServiceLocator)parentPageSite, null, () -> {}, this.e4Context);
        this.initializeDefaultServices();
    }

    private void initializeDefaultServices() {
        this.serviceLocator.registerService(IWorkbenchLocationService.class, (Object)new WorkbenchLocationService(this.getClass().getName(), this.getWorkbenchWindow().getWorkbench(), this.getWorkbenchWindow(), this.partSite, null, this.parentSite, 4));
        this.serviceLocator.registerService(IPageSiteHolder.class, () -> this);
        LegacyHandlerService handlerService = new LegacyHandlerService(this.e4Context);
        this.e4Context.set(IHandlerService.class, (Object)handlerService);
        this.e4Context.set(IContextService.class.getName(), (Object)new ContextFunction(){

            public Object compute(IEclipseContext context, String contextKey) {
                if (MultiPageSite.this.contextService == null) {
                    MultiPageSite.this.contextService = new NestableContextService((IContextService)context.getParent().get(IContextService.class), (Expression)new ActivePartExpression(MultiPageSite.this.partSite.getPart()));
                }
                return MultiPageSite.this.contextService;
            }
        });
    }

    protected void dispose() {
        if (this.menuExtenders != null) {
            HashSet<MenuManager> managers = HashSet.newHashSet(this.menuExtenders.size());
            Iterator<PopupMenuExtender> iterator = this.menuExtenders.iterator();
            while (iterator.hasNext()) {
                PopupMenuExtender menuExtender;
                PopupMenuExtender ext = menuExtender = iterator.next();
                managers.add(ext.getManager());
                ext.dispose();
            }
            if (!managers.isEmpty()) {
                for (MenuManager mgr : managers) {
                    mgr.dispose();
                }
            }
            this.menuExtenders = null;
        }
        this.subActionBars.dispose();
        if (this.contextService != null) {
            this.contextService.dispose();
        }
        this.serviceLocator.dispose();
        this.e4Context.dispose();
    }

    public SubActionBars getActionBars() {
        return this.subActionBars;
    }

    public <T> T getAdapter(Class<T> adapter) {
        return (T)Platform.getAdapterManager().getAdapter((Object)this, adapter);
    }

    public IWorkbenchPage getPage() {
        return this.parentSite.getPage();
    }

    public ISelectionProvider getSelectionProvider() {
        return this.selectionProvider;
    }

    public final <T> T getService(Class<T> key) {
        Object service = this.serviceLocator.getService(key);
        if (this.active && service instanceof INestable) {
            INestable nestable = (INestable)service;
            nestable.activate();
        }
        return (T)service;
    }

    public Shell getShell() {
        return this.parentSite.getShell();
    }

    public IWorkbenchWindow getWorkbenchWindow() {
        return this.parentSite.getWorkbenchWindow();
    }

    public final boolean hasService(Class<?> key) {
        return this.serviceLocator.hasService(key);
    }

    public void registerContextMenu(String menuID, MenuManager menuMgr, ISelectionProvider selProvider) {
        if (this.menuExtenders == null) {
            this.menuExtenders = new ArrayList(1);
        }
        PartSite.registerContextMenu((String)menuID, (MenuManager)menuMgr, (ISelectionProvider)selProvider, (boolean)false, (IWorkbenchPart)this.partSite.getPart(), (IEclipseContext)this.e4Context, this.menuExtenders);
    }

    public void setSelectionProvider(ISelectionProvider provider) {
        this.selectionProvider = provider;
    }

    public void activate() {
        this.active = true;
        this.serviceLocator.activate();
        if (this.contextService != null) {
            this.contextService.activate();
        }
    }

    public void deactivate() {
        this.active = false;
        if (this.contextService != null) {
            this.contextService.deactivate();
        }
        this.serviceLocator.deactivate();
    }
}

