/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.query.runtime.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.eclipse.acceleo.query.runtime.ICompletionProposal;
import org.eclipse.acceleo.query.runtime.ICompletionResult;
import org.eclipse.acceleo.query.runtime.IProposalFilter;

public class CompletionResult
implements ICompletionResult {
    private final List<ICompletionProposal> proposals;
    private String prefix;
    private String remaining;

    public CompletionResult(List<ICompletionProposal> proposals) {
        this.proposals = proposals;
    }

    @Override
    public List<ICompletionProposal> getProposals(IProposalFilter filter) {
        ArrayList<ICompletionProposal> result = new ArrayList<ICompletionProposal>();
        for (ICompletionProposal proposal : this.proposals) {
            if (!filter.keepProposal(proposal)) continue;
            result.add(proposal);
        }
        return result;
    }

    @Override
    public void sort(Comparator<ICompletionProposal> comparator) {
        Collections.sort(this.proposals, comparator);
    }

    @Override
    public String getPrefix() {
        return this.prefix;
    }

    @Override
    public void setPrefix(String prefix) {
        this.prefix = prefix;
    }

    @Override
    public String getRemaining() {
        return this.remaining;
    }

    @Override
    public void setRemaining(String remaining) {
        this.remaining = remaining;
    }
}

