/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.query.runtime.impl;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.acceleo.query.ast.Error;
import org.eclipse.acceleo.query.parser.CombineIterator;
import org.eclipse.acceleo.query.runtime.AcceleoQueryValidationException;
import org.eclipse.acceleo.query.runtime.IQueryEnvironment;
import org.eclipse.acceleo.query.runtime.IService;
import org.eclipse.acceleo.query.runtime.impl.AbstractLanguageServices;
import org.eclipse.acceleo.query.validation.type.ClassType;
import org.eclipse.acceleo.query.validation.type.EClassifierType;
import org.eclipse.acceleo.query.validation.type.ICollectionType;
import org.eclipse.acceleo.query.validation.type.IType;
import org.eclipse.acceleo.query.validation.type.NothingType;
import org.eclipse.acceleo.query.validation.type.SequenceType;
import org.eclipse.acceleo.query.validation.type.SetType;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EOperation;
import org.eclipse.emf.ecore.EParameter;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.EcorePackage;

public class ValidationServices
extends AbstractLanguageServices {
    public static final String INTERNAL_ERROR_MSG = "An internal error occured during validation of a query";
    private static final String VARIABLE_HAS_NO_TYPES = "The %s variable has no types";

    public ValidationServices(IQueryEnvironment queryEnv, boolean doLog) {
        super(queryEnv, doLog);
    }

    public NothingType nothing(String message, Object ... msgArgs) {
        String formatedMessage = String.format(message, msgArgs);
        return new NothingType(formatedMessage);
    }

    public Set<IType> getVariableTypes(Map<String, Set<IType>> variableTypes, String variableName) {
        try {
            LinkedHashSet<IType> res = new LinkedHashSet<IType>();
            Set<IType> types = variableTypes.get(variableName);
            if (types != null) {
                if (types.size() > 0) {
                    res.addAll(types);
                } else {
                    res.add(this.nothing(VARIABLE_HAS_NO_TYPES, variableName));
                }
            } else {
                res.add(this.nothing("Couldn't find the %s variable", variableName));
            }
            return res;
        }
        catch (NullPointerException e) {
            throw new AcceleoQueryValidationException(INTERNAL_ERROR_MSG, e);
        }
    }

    public Set<IType> featureAccessTypes(Set<IType> receiverTypes, String featureName) {
        try {
            LinkedHashSet<IType> result = new LinkedHashSet<IType>();
            for (IType receiverType : receiverTypes) {
                if (receiverType.getType() instanceof EClass) {
                    EClass eClass = (EClass)receiverType.getType();
                    EStructuralFeature feature = eClass.getEStructuralFeature(featureName);
                    if (feature == null) {
                        result.add(this.nothing("Feature %s not found in EClass %s", featureName, eClass.getName()));
                        continue;
                    }
                    if (feature.isMany()) {
                        result.add(new SequenceType(this.getFeatureBasicType(feature)));
                        continue;
                    }
                    result.add(this.getFeatureBasicType(feature));
                    continue;
                }
                if (receiverType instanceof SequenceType) {
                    result.add(this.getFeatureTypeOnSequence((SequenceType)receiverType, featureName));
                    continue;
                }
                if (receiverType instanceof SetType) {
                    result.add(this.getFeatureTypeOnSet((SetType)receiverType, featureName));
                    continue;
                }
                result.add(this.nothing("Attempt to access feature (%s) on a non ModelObject value (%s).", featureName, receiverType.getType().toString()));
            }
            return result;
        }
        catch (Exception e) {
            throw new AcceleoQueryValidationException(INTERNAL_ERROR_MSG, e);
        }
    }

    private IType getFeatureBasicType(EStructuralFeature feature) {
        return new EClassifierType(feature.getEType());
    }

    private IType getFeatureTypeOnSet(SetType targetType, String featureName) {
        IType basicType = targetType.getCollectionType();
        LinkedHashSet<IType> basicTypes = new LinkedHashSet<IType>();
        basicTypes.add(basicType);
        IType featureAccessType = this.featureAccessTypes(basicTypes, featureName).iterator().next();
        SetType result = featureAccessType instanceof ICollectionType ? new SetType(((ICollectionType)featureAccessType).getCollectionType()) : new SetType(featureAccessType);
        return result;
    }

    private IType getFeatureTypeOnSequence(SequenceType targetType, String featureName) {
        IType basicType = targetType.getCollectionType();
        LinkedHashSet<IType> basicTypes = new LinkedHashSet<IType>();
        basicTypes.add(basicType);
        IType featureAccessType = this.featureAccessTypes(basicTypes, featureName).iterator().next();
        SequenceType result = featureAccessType instanceof ICollectionType ? new SequenceType(((ICollectionType)featureAccessType).getCollectionType()) : new SequenceType(featureAccessType);
        return result;
    }

    public Set<IType> callType(String serviceName, List<Set<IType>> argTypes) {
        if (argTypes.size() == 0) {
            throw new AcceleoQueryValidationException("An internal error occured during validation of a query : at least one argument must be specified for service " + serviceName + ".");
        }
        try {
            LinkedHashSet<IType> result = new LinkedHashSet<IType>();
            CombineIterator it = new CombineIterator(argTypes);
            while (it.hasNext()) {
                Object currentArgTypes = it.next();
                Class<?>[] argumentTypes = this.getArgumentTypes((Collection<IType>)currentArgTypes);
                IService service = this.lookupEngine.lookup(serviceName, argumentTypes);
                if (service == null) {
                    if (((IType)currentArgTypes.get(0)).getType() instanceof EClass) {
                        List<EParameter> eParameters = this.getEParameters((List<IType>)currentArgTypes);
                        EClass reveiverType = (EClass)eParameters.remove(0).getEType();
                        EOperation eOperation = this.ePackageProvider.lookupEOperation(reveiverType, serviceName, eParameters);
                        if (eOperation != null) {
                            result.add(this.getEOperationType(eOperation));
                            continue;
                        }
                        result.add(this.nothing("Couldn't find the %s service or EOperation", this.serviceSignature(serviceName, (List<IType>)currentArgTypes)));
                        continue;
                    }
                    result.add(this.nothing("Couldn't find the %s service", this.serviceSignature(serviceName, (List<IType>)currentArgTypes)));
                    continue;
                }
                result.addAll(this.getServiceType(service, (List<IType>)currentArgTypes));
            }
            return result;
        }
        catch (Exception e) {
            throw new AcceleoQueryValidationException(INTERNAL_ERROR_MSG, e);
        }
    }

    private List<EParameter> getEParameters(List<IType> types) {
        ArrayList<EParameter> result = new ArrayList<EParameter>();
        for (IType type : types) {
            result.add(this.getEParameter(type));
        }
        return result;
    }

    private EParameter getEParameter(IType type) {
        EParameter result;
        if (type instanceof SequenceType) {
            result = EcorePackage.eINSTANCE.getEcoreFactory().createEParameter();
            result.setUpperBound(-1);
            result.setEType(this.getEParameter(((SequenceType)type).getCollectionType()).getEType());
        } else if (type instanceof EClassifierType) {
            result = EcorePackage.eINSTANCE.getEcoreFactory().createEParameter();
            result.setEType(((EClassifierType)type).getType());
        } else if (type instanceof ClassType && type.getType() == null) {
            result = EcorePackage.eINSTANCE.getEcoreFactory().createEParameter();
            result.setEType(null);
        } else {
            throw new IllegalStateException("EParameter with no EClassifier type.");
        }
        return result;
    }

    private Set<IType> getServiceType(IService service, List<IType> argTypes) {
        return service.getType(this, this.ePackageProvider, argTypes);
    }

    private IType getEOperationType(EOperation eOperation) {
        EClassifierType eClassifierType = new EClassifierType(eOperation.getEType());
        IType result = eOperation.isMany() ? new SequenceType(eClassifierType) : eClassifierType;
        return result;
    }

    public Set<IType> callOrApplyTypes(String serviceName, List<Set<IType>> argTypes) {
        try {
            LinkedHashSet<IType> result = new LinkedHashSet<IType>();
            ArrayList<Set<IType>> argTypesNoReceiver = new ArrayList<Set<IType>>(argTypes);
            Set receiverTypes = (Set)argTypesNoReceiver.remove(0);
            for (IType receiverType : receiverTypes) {
                if (receiverType instanceof SequenceType) {
                    result.addAll(this.validateCallOnSequence(serviceName, (SequenceType)receiverType, argTypesNoReceiver));
                    continue;
                }
                if (receiverType instanceof SetType) {
                    result.addAll(this.validateCallOnSet(serviceName, (SetType)receiverType, argTypesNoReceiver));
                    continue;
                }
                ArrayList<Set<IType>> newArgTypes = new ArrayList<Set<IType>>(argTypesNoReceiver);
                LinkedHashSet<IType> newReceiverTypes = new LinkedHashSet<IType>();
                newReceiverTypes.add(receiverType);
                newArgTypes.add(0, newReceiverTypes);
                result.addAll(this.callType(serviceName, newArgTypes));
            }
            return result;
        }
        catch (Exception e) {
            throw new AcceleoQueryValidationException(INTERNAL_ERROR_MSG, e);
        }
    }

    private Set<IType> validateCallOnSequence(String serviceName, SequenceType receiverType, List<Set<IType>> argTypesNoReceiver) {
        LinkedHashSet<IType> result = new LinkedHashSet<IType>();
        try {
            ArrayList<Set<IType>> newArgTypes = new ArrayList<Set<IType>>(argTypesNoReceiver);
            LinkedHashSet<IType> newReceiverTypes = new LinkedHashSet<IType>();
            newReceiverTypes.add(receiverType.getCollectionType());
            newArgTypes.add(0, newReceiverTypes);
            Set<IType> rawResultTypes = this.callOrApplyTypes(serviceName, newArgTypes);
            for (IType rawResultType : rawResultTypes) {
                if (rawResultType instanceof NothingType) continue;
                if (rawResultType instanceof ICollectionType) {
                    result.add(new SequenceType(((ICollectionType)rawResultType).getCollectionType()));
                    continue;
                }
                result.add(new SequenceType(rawResultType));
            }
            if (result.size() == 0) {
                result.add(new NothingType(String.valueOf(serviceName) + " service call on " + receiverType.getCollectionType() + " produce nothing."));
            }
            return result;
        }
        catch (Exception e) {
            throw new AcceleoQueryValidationException("empty argument array passed to callOrApply", e);
        }
    }

    private Set<IType> validateCallOnSet(String serviceName, SetType receiverType, List<Set<IType>> argTypesNoReceiver) {
        LinkedHashSet<IType> result = new LinkedHashSet<IType>();
        try {
            ArrayList<Set<IType>> newArgTypes = new ArrayList<Set<IType>>(argTypesNoReceiver);
            LinkedHashSet<IType> newReceiverTypes = new LinkedHashSet<IType>();
            newReceiverTypes.add(receiverType.getCollectionType());
            newArgTypes.add(0, newReceiverTypes);
            Set<IType> rawResultTypes = this.callOrApplyTypes(serviceName, newArgTypes);
            for (IType rawResultType : rawResultTypes) {
                if (rawResultType instanceof NothingType) continue;
                if (rawResultType instanceof ICollectionType) {
                    result.add(new SetType(((ICollectionType)rawResultType).getCollectionType()));
                    continue;
                }
                result.add(new SetType(rawResultType));
            }
            if (result.size() == 0) {
                result.add(new NothingType(String.valueOf(serviceName) + " service call on " + receiverType.getCollectionType() + " produce nothing."));
            }
            return result;
        }
        catch (Exception e) {
            throw new AcceleoQueryValidationException("empty argument array passed to callOrApply", e);
        }
    }

    public Set<IType> collectionServiceCallTypes(String serviceName, List<Set<IType>> argTypes) {
        ArrayList<Set<IType>> newArguments = new ArrayList<Set<IType>>(argTypes);
        try {
            Set receiverTypes = (Set)newArguments.remove(0);
            LinkedHashSet<IType> newReceiverTypes = new LinkedHashSet<IType>();
            for (IType receiverType : receiverTypes) {
                if (!(receiverType instanceof ICollectionType) && !(receiverTypes instanceof NothingType)) {
                    newReceiverTypes.add(new SetType(receiverType));
                    continue;
                }
                newReceiverTypes.add(receiverType);
            }
            newArguments.add(0, newReceiverTypes);
            return this.callType(serviceName, newArguments);
        }
        catch (Exception e) {
            throw new AcceleoQueryValidationException(INTERNAL_ERROR_MSG, e);
        }
    }

    protected String serviceSignature(String serviceName, List<IType> argumentTypes) {
        StringBuilder builder = new StringBuilder();
        builder.append(serviceName).append('(');
        boolean first = true;
        for (IType argType : argumentTypes) {
            if (!first) {
                builder.append(',');
            } else {
                first = false;
            }
            builder.append(argType.toString());
        }
        return builder.append(')').toString();
    }

    public Set<IType> getIType(Type type) {
        LinkedHashSet<IType> result = new LinkedHashSet<IType>();
        if (type instanceof ParameterizedType) {
            Class cls = (Class)((ParameterizedType)type).getRawType();
            if (List.class.isAssignableFrom(cls)) {
                for (IType t : this.getIType(((ParameterizedType)type).getActualTypeArguments()[0])) {
                    result.add(new SequenceType(t));
                }
            } else if (Set.class.isAssignableFrom(cls)) {
                for (IType t : this.getIType(((ParameterizedType)type).getActualTypeArguments()[0])) {
                    result.add(new SetType(t));
                }
            } else {
                result.add(new SetType(new ClassType(cls)));
            }
        } else if (type instanceof Class) {
            Class cls = (Class)type;
            result.addAll(this.getIType(cls));
        } else {
            result.add(new ClassType(Object.class));
        }
        return result;
    }

    public Set<IType> getIType(Class<?> cls) {
        LinkedHashSet<IType> result = new LinkedHashSet<IType>();
        Set<EClassifier> classifiers = this.ePackageProvider.getEClass(cls);
        if (List.class.isAssignableFrom(cls)) {
            result.add(new SequenceType(new ClassType(Object.class)));
        } else if (Set.class.isAssignableFrom(cls)) {
            result.add(new SetType(new ClassType(Object.class)));
        } else if (classifiers != null) {
            for (EClassifier eCls : classifiers) {
                result.add(new EClassifierType(eCls));
            }
        } else {
            result.add(new ClassType(cls));
        }
        return result;
    }

    public Set<IType> getErrorTypes(Error error) {
        HashSet<IType> result = new HashSet<IType>();
        String message = error.eClass().getName();
        result.add(new NothingType(message));
        return result;
    }
}

