/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.query.runtime.impl;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.acceleo.query.runtime.IReadOnlyQueryEnvironment;
import org.eclipse.acceleo.query.runtime.IService;
import org.eclipse.acceleo.query.runtime.IServiceProvider;
import org.eclipse.acceleo.query.runtime.InvalidAcceleoPackageException;

public abstract class AbstractServiceProvider
implements IServiceProvider {
    private static final String WRONG_IMPLEMENTATION = "Wrong implementation of " + AbstractServiceProvider.class.getName();
    private List<IService> services;

    @Override
    public List<IService> getServices(IReadOnlyQueryEnvironment queryEnvironment) throws InvalidAcceleoPackageException {
        try {
            if (this.services == null) {
                Method[] methods;
                Method getServicesMethod = this.getClass().getMethod("getServices", IReadOnlyQueryEnvironment.class);
                this.services = new ArrayList<IService>();
                Method[] methodArray = methods = this.getClass().getMethods();
                int n = methods.length;
                int n2 = 0;
                while (n2 < n) {
                    IService service;
                    Method method = methodArray[n2];
                    if (queryEnvironment.getLookupEngine().isCrossReferencerMethod(method)) {
                        method.invoke((Object)this, queryEnvironment.getLookupEngine().getCrossReferencer());
                    } else if (queryEnvironment.getLookupEngine().isServiceMethod(this, method) && !getServicesMethod.equals(method) && (service = this.getService(method)) != null) {
                        this.services.add(service);
                    }
                    ++n2;
                }
            }
        }
        catch (IllegalAccessException e) {
            throw new InvalidAcceleoPackageException("Couldn't instantiate class " + this.getClass().getCanonicalName(), e);
        }
        catch (IllegalArgumentException e) {
            throw new InvalidAcceleoPackageException("Couldn't instantiate class " + this.getClass().getCanonicalName(), e);
        }
        catch (InvocationTargetException e) {
            throw new InvalidAcceleoPackageException("Couldn't instantiate class " + this.getClass().getCanonicalName(), e);
        }
        catch (NoSuchMethodException e) {
            throw new InvalidAcceleoPackageException(WRONG_IMPLEMENTATION, e);
        }
        catch (SecurityException e) {
            throw new InvalidAcceleoPackageException(WRONG_IMPLEMENTATION, e);
        }
        return this.services;
    }

    protected abstract IService getService(Method var1);
}

