/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.internal.ide.ui.editors.template.actions.refactor.documentation;

import org.eclipse.acceleo.ide.ui.AcceleoUIActivator;
import org.eclipse.acceleo.internal.ide.ui.editors.template.actions.refactor.AbstractRefactoringAction;
import org.eclipse.acceleo.internal.ide.ui.editors.template.actions.refactor.AcceleoRefactoringUtils;
import org.eclipse.acceleo.internal.ide.ui.editors.template.utils.OpenDeclarationUtils;
import org.eclipse.acceleo.model.mtl.Module;
import org.eclipse.acceleo.model.mtl.Query;
import org.eclipse.acceleo.model.mtl.Template;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.ocl.ecore.Variable;

public class GenerateDocumentationAction
extends AbstractRefactoringAction {
    private static final String LINE_SEPARATOR = System.getProperty("line.separator");
    private static final String SPACE = " ";

    public GenerateDocumentationAction() {
        super(true);
    }

    @Override
    protected void launchRefactoring() {
        if (this.fWindow != null && AcceleoRefactoringUtils.allResourceSaved() && !this.editor.isDirty()) {
            EObject container = OpenDeclarationUtils.findResolvedDeclaration(this.editor);
            while (!(container instanceof Template || container instanceof Query || container instanceof Module || container == null)) {
                container = container.eContainer();
            }
            if (container instanceof Template) {
                Template template = (Template)container;
                this.generateTemplateDocumentation(template);
            } else if (container instanceof Query) {
                Query query = (Query)container;
                this.generateQueryDocumentation(query);
            } else if (container instanceof Module) {
                Module module = (Module)container;
                this.generateModuleDocumentation(module);
            }
            if (container != null) {
                this.editor.doSave((IProgressMonitor)new NullProgressMonitor());
            }
        }
    }

    private void generateModuleDocumentation(Module module) {
        String username = System.getProperty("user.name");
        int startPosition = module.getStartHeaderPosition() - 1;
        IDocument document = this.editor.getDocumentProvider().getDocument((Object)this.editor.getEditorInput());
        StringBuffer newBuffer = new StringBuffer();
        newBuffer.append(String.valueOf(LINE_SEPARATOR) + "[" + "**" + LINE_SEPARATOR);
        newBuffer.append(" * " + LINE_SEPARATOR);
        newBuffer.append(" * @author " + username + LINE_SEPARATOR);
        newBuffer.append(" */]");
        try {
            document.replace(startPosition, 0, newBuffer.toString());
        }
        catch (BadLocationException e) {
            AcceleoUIActivator.getDefault().getLog().log((IStatus)new Status(4, "org.eclipse.acceleo.ide.ui", e.getMessage(), (Throwable)e));
        }
    }

    private void generateQueryDocumentation(Query query) {
        int startPosition = query.getStartPosition() - 1;
        IDocument document = this.editor.getDocumentProvider().getDocument((Object)this.editor.getEditorInput());
        StringBuffer newBuffer = new StringBuffer();
        newBuffer.append(String.valueOf(LINE_SEPARATOR) + "[" + "**" + LINE_SEPARATOR);
        newBuffer.append(" * " + LINE_SEPARATOR);
        newBuffer.append(this.generateParameterDocumentation((EList<Variable>)query.getParameter()));
        newBuffer.append(" */]");
        try {
            document.replace(startPosition, 0, newBuffer.toString());
        }
        catch (BadLocationException e) {
            AcceleoUIActivator.getDefault().getLog().log((IStatus)new Status(4, "org.eclipse.acceleo.ide.ui", e.getMessage(), (Throwable)e));
        }
    }

    private StringBuffer generateParameterDocumentation(EList<Variable> eList) {
        StringBuffer result = new StringBuffer();
        for (Variable variable : eList) {
            result.append(" * @param " + variable.getName() + SPACE + LINE_SEPARATOR);
        }
        return result;
    }

    private void generateTemplateDocumentation(Template template) {
        int startPosition = template.getStartPosition() - 1;
        IDocument document = this.editor.getDocumentProvider().getDocument((Object)this.editor.getEditorInput());
        StringBuffer newBuffer = new StringBuffer();
        newBuffer.append(String.valueOf(LINE_SEPARATOR) + "[" + "**" + LINE_SEPARATOR);
        newBuffer.append(" * " + LINE_SEPARATOR);
        newBuffer.append(this.generateParameterDocumentation((EList<Variable>)template.getParameter()));
        newBuffer.append(" */]");
        try {
            document.replace(startPosition, 0, newBuffer.toString());
        }
        catch (BadLocationException e) {
            AcceleoUIActivator.getDefault().getLog().log((IStatus)new Status(4, "org.eclipse.acceleo.ide.ui", e.getMessage(), (Throwable)e));
        }
    }
}

