/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.tests.utils;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.URIHandler;

public class MemoryURIHandler
implements URIHandler {
    private static final String NOT_OPENABLE_TXT = "notOpenable.txt";
    private static final String NOT_WRITABLE_TXT = "notWritable.txt";
    private static final String NOT_CLOSABLE_TXT = "notClosable.txt";
    private final Map<URI, ByteArrayOutputStream> resources = new HashMap<URI, ByteArrayOutputStream>();

    public void clear() {
        this.resources.clear();
    }

    public boolean canHandle(URI uri) {
        return "acceleotests".equals(uri.scheme());
    }

    public InputStream createInputStream(URI uri, Map<?, ?> options) throws IOException {
        ByteArrayInputStream res;
        ByteArrayOutputStream outputStream = this.resources.get(uri);
        if (outputStream != null) {
            res = new ByteArrayInputStream(outputStream.toByteArray());
        } else if (NOT_OPENABLE_TXT.equals(uri.lastSegment()) || NOT_WRITABLE_TXT.equals(uri.lastSegment()) || NOT_CLOSABLE_TXT.equals(uri.lastSegment())) {
            res = new ByteArrayInputStream(new byte[0]);
        } else {
            throw new IOException("Resource " + String.valueOf(uri) + " doesn't exist in memory.");
        }
        return res;
    }

    public OutputStream createOutputStream(URI uri, Map<?, ?> options) throws IOException {
        OutputStream res;
        if (NOT_OPENABLE_TXT.equals(uri.lastSegment())) {
            throw new IOException("Can't open OutputStream");
        }
        if (NOT_WRITABLE_TXT.equals(uri.lastSegment())) {
            res = new OutputStream(){

                @Override
                public void write(int b) throws IOException {
                    throw new IOException("Can't write to OutputStream");
                }
            };
        } else if (NOT_CLOSABLE_TXT.equals(uri.lastSegment())) {
            res = new OutputStream(){

                @Override
                public void write(int b) throws IOException {
                }

                @Override
                public void close() throws IOException {
                    throw new IOException("Can't close OutputStream");
                }
            };
        } else {
            res = new ByteArrayOutputStream();
            this.resources.put(uri, (ByteArrayOutputStream)res);
        }
        return res;
    }

    public void delete(URI uri, Map<?, ?> options) throws IOException {
        this.resources.remove(uri);
    }

    public Map<String, ?> contentDescription(URI uri, Map<?, ?> options) throws IOException {
        return Collections.emptyMap();
    }

    public boolean exists(URI uri, Map<?, ?> options) {
        return this.resources.containsKey(uri);
    }

    public Map<String, ?> getAttributes(URI uri, Map<?, ?> options) {
        return Collections.emptyMap();
    }

    public void setAttributes(URI uri, Map<String, ?> attributes, Map<?, ?> options) throws IOException {
    }
}

