/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.aql.ls.services.textdocument;

import java.lang.reflect.Method;
import java.net.URISyntaxException;
import java.util.Arrays;
import java.util.Objects;
import java.util.stream.Collectors;
import org.eclipse.acceleo.ASTNode;
import org.eclipse.acceleo.Module;
import org.eclipse.acceleo.aql.location.AcceleoLocationLinkToAcceleo;
import org.eclipse.acceleo.aql.location.aql.AqlLocationLinkToAny;
import org.eclipse.acceleo.aql.location.aql.AqlLocationLinkToAql;
import org.eclipse.acceleo.aql.location.common.AbstractLocationLink;
import org.eclipse.acceleo.aql.ls.common.AcceleoLanguageServerPositionUtils;
import org.eclipse.acceleo.aql.ls.services.textdocument.AcceleoTextDocument;
import org.eclipse.acceleo.aql.ls.services.textdocument.AcceleoTextDocumentService;
import org.eclipse.acceleo.aql.parser.AcceleoAstResult;
import org.eclipse.acceleo.aql.parser.AcceleoAstUtils;
import org.eclipse.acceleo.query.ast.Expression;
import org.eclipse.acceleo.query.ast.VariableDeclaration;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.lsp4j.LocationLink;
import org.eclipse.lsp4j.Position;
import org.eclipse.lsp4j.Range;

public class AcceleoLocationLinkResolver {
    private final AcceleoTextDocumentService owner;

    public AcceleoLocationLinkResolver(AcceleoTextDocumentService acceleoTextDocumentService) {
        this.owner = Objects.requireNonNull(acceleoTextDocumentService);
    }

    public LocationLink transform(AbstractLocationLink<?, ?> locationLinkToTransform) {
        LocationLink locationLink;
        Objects.requireNonNull(locationLinkToTransform);
        if (locationLinkToTransform instanceof AcceleoLocationLinkToAcceleo) {
            locationLink = this.transform((AcceleoLocationLinkToAcceleo)locationLinkToTransform);
        } else if (locationLinkToTransform instanceof AqlLocationLinkToAql) {
            locationLink = this.transform((AqlLocationLinkToAql)locationLinkToTransform);
        } else if (locationLinkToTransform instanceof AqlLocationLinkToAny) {
            locationLink = this.transform((AqlLocationLinkToAny)locationLinkToTransform);
        } else {
            throw new UnsupportedOperationException("Unsupported " + AbstractLocationLink.class.getCanonicalName() + " implementation: " + locationLinkToTransform.toString());
        }
        return locationLink;
    }

    private LocationLink transform(AcceleoLocationLinkToAcceleo acceleoLocationLinkToAcceleo) {
        ASTNode linkOrigin = (ASTNode)acceleoLocationLinkToAcceleo.getOrigin();
        AcceleoTextDocument originTextDocument = this.getAcceleoTextDocumentContaining(linkOrigin);
        ASTNode linkOriginEquivalent = AcceleoAstUtils.getSelfOrEquivalentOf((ASTNode)linkOrigin, (AcceleoAstResult)originTextDocument.getAcceleoAstResult());
        Range originSelectionRange = AcceleoLanguageServerPositionUtils.getRangeOf(linkOriginEquivalent, originTextDocument.getAcceleoAstResult());
        ASTNode destinationAcceleoNode = (ASTNode)acceleoLocationLinkToAcceleo.getDestination();
        return this.createLocationLinkFromRangeToAcceleoDestination(originSelectionRange, destinationAcceleoNode);
    }

    private AcceleoTextDocument getAcceleoTextDocumentContaining(ASTNode astNode) {
        Module containingModule = AcceleoAstUtils.getContainerModule((ASTNode)astNode);
        AcceleoTextDocument containingTextDocument = this.getTextDocumentDefining(containingModule);
        return containingTextDocument;
    }

    private AcceleoTextDocument getTextDocumentDefining(Module acceleoModule) {
        return this.owner.findTextDocumentDefining(acceleoModule);
    }

    private LocationLink transform(AqlLocationLinkToAql aqlLocationLinkToAql) {
        EObject linkOrigin = (EObject)aqlLocationLinkToAql.getOrigin();
        Range originSelectionRange = this.getRangeForAqlAstElement(linkOrigin);
        EObject linkDestination = (EObject)aqlLocationLinkToAql.getDestination();
        return this.createLocationLinkFromRangeToAqlDestination(originSelectionRange, linkDestination);
    }

    private Range getRangeForAqlAstElement(EObject aqlAstElement) {
        Range originSelectionRange;
        ASTNode acceleoNodeContainingLinkOrigin = AcceleoLocationLinkResolver.getAcceleoAstNodeContainingAqlElement(aqlAstElement);
        AcceleoTextDocument originTextDocument = this.getAcceleoTextDocumentContaining(acceleoNodeContainingLinkOrigin);
        if (aqlAstElement instanceof Expression) {
            Expression originAqlExpression = (Expression)aqlAstElement;
            Expression originAqlExpressionEquivalent = (Expression)AcceleoAstUtils.getSelfOrEquivalentOf((EObject)originAqlExpression, (AcceleoAstResult)originTextDocument.getAcceleoAstResult());
            originSelectionRange = AcceleoLanguageServerPositionUtils.getRangeOf(originAqlExpressionEquivalent, originTextDocument.getAcceleoAstResult());
        } else if (aqlAstElement instanceof VariableDeclaration) {
            VariableDeclaration originAqlVariableDeclaration = (VariableDeclaration)aqlAstElement;
            VariableDeclaration originAqlVariableDeclarationEquivalent = (VariableDeclaration)AcceleoAstUtils.getSelfOrEquivalentOf((EObject)originAqlVariableDeclaration, (AcceleoAstResult)originTextDocument.getAcceleoAstResult());
            originSelectionRange = AcceleoLanguageServerPositionUtils.getRangeOf(originAqlVariableDeclarationEquivalent, originTextDocument.getAcceleoAstResult());
        } else {
            throw new IllegalStateException("Expected link origin to be either an AQL Expression or an AQL Variable Declaration but it was: " + aqlAstElement.toString() + ".");
        }
        return originSelectionRange;
    }

    private static ASTNode getAcceleoAstNodeContainingAqlElement(EObject aqlElement) {
        ASTNode acceleoNodeContainingAqlElement;
        if (aqlElement instanceof Expression) {
            Expression originAqlExpression = (Expression)aqlElement;
            acceleoNodeContainingAqlElement = AcceleoAstUtils.getContainerOfAqlAstElement((EObject)originAqlExpression);
        } else if (aqlElement instanceof VariableDeclaration) {
            VariableDeclaration originAqlVariableDeclaration = (VariableDeclaration)aqlElement;
            acceleoNodeContainingAqlElement = AcceleoAstUtils.getContainerOfAqlAstElement((EObject)originAqlVariableDeclaration);
        } else {
            throw new IllegalStateException("Expected AQL element to be either an AQL Expression or an AQL Variable Declaration but it was: " + aqlElement.toString() + ".");
        }
        return acceleoNodeContainingAqlElement;
    }

    private LocationLink transform(AqlLocationLinkToAny aqlLocationLinkToAny) {
        EObject aqlOrigin = (EObject)aqlLocationLinkToAny.getOrigin();
        Range originSelectionRange = this.getRangeForAqlAstElement(aqlOrigin);
        Object destination = aqlLocationLinkToAny.getDestination();
        return this.createLocationLinkFromRangeToAnyDestination(aqlOrigin, originSelectionRange, destination);
    }

    private LocationLink createLocationLinkFromRangeToAnyDestination(EObject linkOrigin, Range originSelectionRange, Object destination) {
        LocationLink locationLink;
        if (destination instanceof ASTNode) {
            ASTNode destinationNode = (ASTNode)destination;
            locationLink = this.createLocationLinkFromRangeToAcceleoDestination(originSelectionRange, destinationNode);
        } else if (destination instanceof Expression || destination instanceof VariableDeclaration) {
            locationLink = this.createLocationLinkFromRangeToAqlDestination(originSelectionRange, (EObject)destination);
        } else if (destination instanceof Class) {
            locationLink = this.createLocationLinkFromRangeToJavaClassDestination(linkOrigin, originSelectionRange, (Class)destination);
        } else if (destination instanceof Method) {
            locationLink = this.createLocationLinkFromRangeToJavaMethodDestination(linkOrigin, originSelectionRange, (Method)destination);
        } else if (destination instanceof EObject) {
            locationLink = this.createLocationLinkFromRangeToEObjectDestination(linkOrigin, originSelectionRange, (EObject)destination);
        } else {
            throw new IllegalStateException("Trying to create a link to destination: " + destination + " but this type of destination is not supported.");
        }
        return locationLink;
    }

    private LocationLink createLocationLinkFromRangeToAqlDestination(Range originSelectionRange, EObject aqlDestination) {
        Range targetRange;
        ASTNode acceleoNodeContainingLinkDestination = AcceleoLocationLinkResolver.getAcceleoAstNodeContainingAqlElement(aqlDestination);
        AcceleoTextDocument destinationTextDocument = this.getAcceleoTextDocumentContaining(acceleoNodeContainingLinkDestination);
        String targetDocumentUri = destinationTextDocument.getUri().toString();
        Range targetSelectionRange = targetRange = this.getRangeForAqlAstElement(aqlDestination);
        LocationLink locationLink = new LocationLink(targetDocumentUri, targetRange, targetSelectionRange, originSelectionRange);
        return locationLink;
    }

    private LocationLink createLocationLinkFromRangeToAcceleoDestination(Range originSelectionRange, ASTNode destinationNode) {
        java.net.URI targetDocumentUri;
        Range targetRange;
        AcceleoTextDocument destinationTextDocument = this.getAcceleoTextDocumentContaining(destinationNode);
        if (destinationTextDocument == null) {
            throw new IllegalArgumentException("Could not find the Acceleo document that defines " + destinationNode.toString());
        }
        AcceleoAstResult destinationAcceleoAstResult = destinationTextDocument.getAcceleoAstResult();
        ASTNode destinationNodeInDestinationTextDocument = AcceleoAstUtils.getSelfOrEquivalentOf((ASTNode)destinationNode, (AcceleoAstResult)destinationAcceleoAstResult);
        Range targetSelectionRange = targetRange = AcceleoLanguageServerPositionUtils.getRangeOf(destinationNodeInDestinationTextDocument, destinationAcceleoAstResult);
        Module destinationModule = destinationTextDocument.getAcceleoAstResult().getModule();
        String qualifiedName = URI.decode((String)destinationModule.eResource().getURI().toString().replaceFirst("acceleoenv::", ""));
        try {
            targetDocumentUri = destinationTextDocument.getAcceleoEnvironment().getModuleResolver().getModuleSourceURL(qualifiedName).toURI();
        }
        catch (URISyntaxException e) {
            targetDocumentUri = null;
        }
        if (targetDocumentUri == null) {
            targetDocumentUri = destinationTextDocument.getUri();
        }
        LocationLink locationLink = new LocationLink(targetDocumentUri.toString(), targetRange, targetSelectionRange, originSelectionRange);
        return locationLink;
    }

    private LocationLink createLocationLinkFromRangeToJavaClassDestination(EObject linkOrigin, Range originSelectionRange, Class<?> destinationJavaClass) {
        Range targetRange;
        String urlToJavadoc;
        ASTNode acceleoAstNode = AcceleoLocationLinkResolver.getAcceleoAstNodeContainingAqlElement(linkOrigin);
        AcceleoTextDocument acceleoTextDocument = this.getAcceleoTextDocumentContaining(acceleoAstNode);
        String urlPrefix = "https://docs.oracle.com/javase/8/docs/api/";
        String urlPostfix = ".html";
        String classNameUrlPart = destinationJavaClass.getCanonicalName().replace('.', '/');
        String targetUri = urlToJavadoc = String.valueOf(urlPrefix) + classNameUrlPart + urlPostfix;
        Range targetSelectionRange = targetRange = new Range(new Position(0, 0), new Position(0, 0));
        LocationLink locationLink = new LocationLink(targetUri, targetRange, targetSelectionRange, originSelectionRange);
        return locationLink;
    }

    private LocationLink createLocationLinkFromRangeToJavaMethodDestination(EObject linkOrigin, Range originSelectionRange, Method destinationJavaMethod) {
        Range targetRange;
        String urlToJavadoc;
        ASTNode acceleoAstNode = AcceleoLocationLinkResolver.getAcceleoAstNodeContainingAqlElement(linkOrigin);
        AcceleoTextDocument acceleoTextDocument = this.getAcceleoTextDocumentContaining(acceleoAstNode);
        String urlPrefix = "https://docs.oracle.com/javase/8/docs/api/";
        String urlPostfix = ".html";
        String classNameUrlPart = destinationJavaMethod.getDeclaringClass().getCanonicalName().replace('.', '/');
        String methodNameUrlPart = destinationJavaMethod.getName();
        String methodParametersUrlPart = Arrays.asList(destinationJavaMethod.getParameterTypes()).stream().map(parameterType -> parameterType.getSimpleName()).collect(Collectors.joining("-"));
        String targetUri = urlToJavadoc = String.valueOf(urlPrefix) + classNameUrlPart + urlPostfix + "#" + methodNameUrlPart + "-" + methodParametersUrlPart;
        Range targetSelectionRange = targetRange = new Range(new Position(0, 0), new Position(0, 0));
        LocationLink locationLink = new LocationLink(targetUri, targetRange, targetSelectionRange, originSelectionRange);
        return locationLink;
    }

    private LocationLink createLocationLinkFromRangeToEObjectDestination(EObject linkOrigin, Range originSelectionRange, EObject destinationEObject) {
        Range targetRange;
        String url;
        ASTNode acceleoAstNode = AcceleoLocationLinkResolver.getAcceleoAstNodeContainingAqlElement(linkOrigin);
        AcceleoTextDocument acceleoTextDocument = this.getAcceleoTextDocumentContaining(acceleoAstNode);
        String targetUri = url = EcoreUtil.getURI((EObject)destinationEObject).toString();
        Range targetSelectionRange = targetRange = new Range(new Position(0, 0), new Position(0, 0));
        LocationLink locationLink = new LocationLink(targetUri, targetRange, targetSelectionRange, originSelectionRange);
        return locationLink;
    }
}

