/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.aql.completion;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.acceleo.ASTNode;
import org.eclipse.acceleo.AcceleoPackage;
import org.eclipse.acceleo.Binding;
import org.eclipse.acceleo.ErrorBinding;
import org.eclipse.acceleo.ErrorBlockComment;
import org.eclipse.acceleo.ErrorComment;
import org.eclipse.acceleo.ErrorExpression;
import org.eclipse.acceleo.ErrorExpressionStatement;
import org.eclipse.acceleo.ErrorFileStatement;
import org.eclipse.acceleo.ErrorForStatement;
import org.eclipse.acceleo.ErrorIfStatement;
import org.eclipse.acceleo.ErrorImport;
import org.eclipse.acceleo.ErrorLetStatement;
import org.eclipse.acceleo.ErrorMetamodel;
import org.eclipse.acceleo.ErrorModule;
import org.eclipse.acceleo.ErrorModuleDocumentation;
import org.eclipse.acceleo.ErrorModuleElementDocumentation;
import org.eclipse.acceleo.ErrorModuleReference;
import org.eclipse.acceleo.ErrorProtectedArea;
import org.eclipse.acceleo.ErrorQuery;
import org.eclipse.acceleo.ErrorTemplate;
import org.eclipse.acceleo.ErrorVariable;
import org.eclipse.acceleo.ForStatement;
import org.eclipse.acceleo.IfStatement;
import org.eclipse.acceleo.LetStatement;
import org.eclipse.acceleo.Module;
import org.eclipse.acceleo.Query;
import org.eclipse.acceleo.Template;
import org.eclipse.acceleo.Variable;
import org.eclipse.acceleo.aql.IAcceleoEnvironment;
import org.eclipse.acceleo.aql.completion.proposals.AcceleoCompletionProposal;
import org.eclipse.acceleo.aql.completion.proposals.AcceleoCompletionProposalsProvider;
import org.eclipse.acceleo.aql.completion.proposals.syntax.AcceleoSyntacticCompletionProposals;
import org.eclipse.acceleo.aql.completion.proposals.templates.AcceleoCodeTemplateCompletionProposal;
import org.eclipse.acceleo.aql.completion.proposals.templates.AcceleoCodeTemplateCompletionProposalsProvider;
import org.eclipse.acceleo.aql.validation.IAcceleoValidationResult;
import org.eclipse.acceleo.query.ast.Error;
import org.eclipse.acceleo.query.parser.AstCompletor;
import org.eclipse.acceleo.query.runtime.ICompletionProposal;
import org.eclipse.acceleo.query.runtime.ICompletionResult;
import org.eclipse.acceleo.query.runtime.IProposalFilter;
import org.eclipse.acceleo.query.runtime.IReadOnlyQueryEnvironment;
import org.eclipse.acceleo.query.runtime.IServiceCompletionProposal;
import org.eclipse.acceleo.query.runtime.IValidationResult;
import org.eclipse.acceleo.query.runtime.impl.BasicFilter;
import org.eclipse.acceleo.query.runtime.impl.CompletionServices;
import org.eclipse.acceleo.query.runtime.impl.QueryCompletionEngine;
import org.eclipse.acceleo.query.runtime.impl.completion.EClassifierCompletionProposal;
import org.eclipse.acceleo.query.runtime.impl.completion.EEnumLiteralCompletionProposal;
import org.eclipse.acceleo.query.runtime.impl.completion.EFeatureCompletionProposal;
import org.eclipse.acceleo.query.runtime.impl.completion.EOperationServiceCompletionProposal;
import org.eclipse.acceleo.query.runtime.impl.completion.VariableCompletionProposal;
import org.eclipse.acceleo.query.runtime.impl.completion.VariableDeclarationCompletionProposal;
import org.eclipse.acceleo.query.validation.type.ClassType;
import org.eclipse.acceleo.query.validation.type.IType;
import org.eclipse.acceleo.util.AcceleoSwitch;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;

public class AcceleoAstCompletor
extends AcceleoSwitch<List<AcceleoCompletionProposal>> {
    private static final Comparator<ICompletionProposal> COMPLETION_PROPOSAL_COMPARATOR = new ProposalComparator();
    private static final String SPACE = " ";
    private final IAcceleoEnvironment acceleoEnvironment;
    private final IAcceleoValidationResult acceleoValidationResult;
    private final QueryCompletionEngine aqlCompletionEngine;
    private final AstCompletor astCompletor;
    private final AcceleoCompletionProposalsProvider acceleoCompletionProposalProvider;
    private String moduleSourceFragment;

    public AcceleoAstCompletor(IAcceleoEnvironment acceleoEnvironment, IAcceleoValidationResult acceleoValidationResult) {
        this.acceleoEnvironment = Objects.requireNonNull(acceleoEnvironment);
        this.acceleoValidationResult = Objects.requireNonNull(acceleoValidationResult);
        this.astCompletor = new AstCompletor(new CompletionServices((IReadOnlyQueryEnvironment)this.acceleoEnvironment.getQueryEnvironment()));
        this.aqlCompletionEngine = new QueryCompletionEngine((IReadOnlyQueryEnvironment)this.acceleoEnvironment.getQueryEnvironment());
        this.acceleoCompletionProposalProvider = new AcceleoCompletionProposalsProvider(acceleoEnvironment);
    }

    public List<AcceleoCompletionProposal> getCompletion(String sourceFragment, EObject acceleoElementToComplete) {
        this.moduleSourceFragment = sourceFragment;
        return (List)this.doSwitch(acceleoElementToComplete);
    }

    @Override
    public List<AcceleoCompletionProposal> caseModule(Module moduleToComplete) {
        ArrayList<AcceleoCompletionProposal> completionProposals = new ArrayList<AcceleoCompletionProposal>();
        if (!moduleToComplete.getModuleElements().stream().anyMatch(moduleElement -> moduleElement instanceof Query || moduleElement instanceof Template)) {
            completionProposals.addAll(this.acceleoCompletionProposalProvider.getProposalsFor(AcceleoPackage.Literals.IMPORT));
        }
        completionProposals.addAll(this.acceleoCompletionProposalProvider.getProposalsFor(AcceleoPackage.Literals.TEMPLATE));
        completionProposals.addAll(this.acceleoCompletionProposalProvider.getProposalsFor(AcceleoPackage.Literals.QUERY));
        completionProposals.addAll(this.acceleoCompletionProposalProvider.getProposalsFor(AcceleoPackage.Literals.MODULE_ELEMENT_DOCUMENTATION));
        completionProposals.addAll(this.acceleoCompletionProposalProvider.getProposalsFor(AcceleoPackage.Literals.COMMENT));
        completionProposals.addAll(this.acceleoCompletionProposalProvider.getProposalsFor(AcceleoPackage.Literals.BLOCK_COMMENT));
        completionProposals.add(AcceleoCodeTemplateCompletionProposalsProvider.NEW_COMMENT_MAIN);
        return completionProposals;
    }

    @Override
    public List<AcceleoCompletionProposal> caseErrorComment(ErrorComment errorComment) {
        ArrayList<AcceleoCompletionProposal> res = new ArrayList<AcceleoCompletionProposal>();
        if (errorComment.getMissingEndHeader() != -1) {
            if (errorComment instanceof ErrorBlockComment) {
                res.add(AcceleoSyntacticCompletionProposals.BLOCK_COMMENT_END);
            } else {
                res.add(AcceleoSyntacticCompletionProposals.COMMENT_END);
            }
        }
        return res;
    }

    @Override
    public List<AcceleoCompletionProposal> caseErrorModuleDocumentation(ErrorModuleDocumentation errorModuleDocumentation) {
        ArrayList<AcceleoCompletionProposal> res = new ArrayList<AcceleoCompletionProposal>();
        if (errorModuleDocumentation.getMissingEndHeader() != -1) {
            res.add(AcceleoSyntacticCompletionProposals.DOCUMENTATION_END);
        }
        return res;
    }

    @Override
    public List<AcceleoCompletionProposal> caseErrorModuleElementDocumentation(ErrorModuleElementDocumentation errorModuleElementDocumentation) {
        ArrayList<AcceleoCompletionProposal> res = new ArrayList<AcceleoCompletionProposal>();
        if (errorModuleElementDocumentation.getMissingEndHeader() != -1) {
            res.add(AcceleoSyntacticCompletionProposals.DOCUMENTATION_END);
        }
        return res;
    }

    @Override
    public List<AcceleoCompletionProposal> caseErrorModule(ErrorModule errorModule) {
        ArrayList<AcceleoCompletionProposal> res = new ArrayList<AcceleoCompletionProposal>();
        if (errorModule.getMissingOpenParenthesis() != -1) {
            if (errorModule.getName() == null) {
                String sampleModuleName = "myModule";
                res.add(new AcceleoCodeTemplateCompletionProposal(sampleModuleName, sampleModuleName, AcceleoPackage.Literals.MODULE));
            } else {
                res.add(AcceleoSyntacticCompletionProposals.OPEN_PARENTHESIS);
            }
        } else if (errorModule.getMissingEPackage() != -1) {
            ArrayList candidateMetamodelURIs = new ArrayList(EPackage.Registry.INSTANCE.keySet());
            Collections.sort(candidateMetamodelURIs);
            for (String nsURI : candidateMetamodelURIs) {
                String metamodelString = "'" + nsURI + "'";
                res.add(new AcceleoCompletionProposal(nsURI, metamodelString, AcceleoPackage.Literals.METAMODEL));
            }
        } else if (errorModule.getMissingCloseParenthesis() != -1) {
            res.add(AcceleoSyntacticCompletionProposals.CLOSE_PARENTHESIS);
            res.add(AcceleoSyntacticCompletionProposals.COMMA_SPACE);
        } else if (errorModule.getMissingEndHeader() != -1) {
            res.add(AcceleoSyntacticCompletionProposals.MODULE_HEADER_END);
            if (errorModule.getExtends() == null) {
                res.add(AcceleoSyntacticCompletionProposals.MODULE_EXTENSION);
            }
        } else {
            res.addAll(this.acceleoCompletionProposalProvider.getProposalsFor(AcceleoPackage.Literals.MODULE));
            res.addAll(this.acceleoCompletionProposalProvider.getProposalsFor(AcceleoPackage.Literals.MODULE_DOCUMENTATION));
            res.addAll(this.acceleoCompletionProposalProvider.getProposalsFor(AcceleoPackage.Literals.COMMENT));
            res.addAll(this.acceleoCompletionProposalProvider.getProposalsFor(AcceleoPackage.Literals.BLOCK_COMMENT));
        }
        return res;
    }

    @Override
    public List<AcceleoCompletionProposal> caseErrorMetamodel(ErrorMetamodel errorMetamodel) {
        ArrayList<AcceleoCompletionProposal> res = new ArrayList<AcceleoCompletionProposal>();
        if (errorMetamodel.getFragment() != null) {
            for (String nsURI : EPackage.Registry.INSTANCE.keySet()) {
                res.add(new AcceleoCompletionProposal(nsURI, nsURI, AcceleoPackage.Literals.METAMODEL));
            }
        } else if (errorMetamodel.getMissingEndQuote() != -1) {
            res.add(AcceleoSyntacticCompletionProposals.QUOTE_DOUBLE);
        }
        return res;
    }

    @Override
    public List<AcceleoCompletionProposal> caseErrorImport(ErrorImport errorImport) {
        ArrayList<AcceleoCompletionProposal> completionProposals = new ArrayList<AcceleoCompletionProposal>();
        if (errorImport.getMissingEnd() != -1) {
            completionProposals.add(AcceleoSyntacticCompletionProposals.IMPORT_END);
        }
        return completionProposals;
    }

    @Override
    public List<AcceleoCompletionProposal> caseErrorModuleReference(ErrorModuleReference errorModuleReference) {
        ArrayList<AcceleoCompletionProposal> completionProposals = new ArrayList<AcceleoCompletionProposal>();
        ArrayList<String> availableQualifiedNames = new ArrayList<String>(this.acceleoEnvironment.getAvailableQualifiedNames());
        Collections.sort(availableQualifiedNames);
        for (String qualifiedName : availableQualifiedNames) {
            completionProposals.add(new AcceleoCodeTemplateCompletionProposal(qualifiedName, qualifiedName, AcceleoPackage.Literals.MODULE_REFERENCE));
        }
        return completionProposals;
    }

    @Override
    public List<AcceleoCompletionProposal> caseErrorTemplate(ErrorTemplate errorTemplate) {
        ArrayList<AcceleoCompletionProposal> completionProposals = new ArrayList<AcceleoCompletionProposal>();
        if (errorTemplate.getMissingVisibility() != -1) {
            completionProposals.addAll(AcceleoSyntacticCompletionProposals.MODULE_ELEMENT_VISIBILITY_KINDS);
        } else if (errorTemplate.getMissingName() != -1) {
            String sampleTemplateName = "myTemplate";
            completionProposals.add(new AcceleoCodeTemplateCompletionProposal(sampleTemplateName, sampleTemplateName, AcceleoPackage.Literals.TEMPLATE));
        } else if (errorTemplate.getMissingOpenParenthesis() != -1) {
            completionProposals.add(AcceleoSyntacticCompletionProposals.OPEN_PARENTHESIS);
        } else if (errorTemplate.getMissingParameters() != -1) {
            String sampleParameterName = "myParameter";
            completionProposals.add(new AcceleoCodeTemplateCompletionProposal(sampleParameterName, sampleParameterName, AcceleoPackage.Literals.TEMPLATE));
        } else if (errorTemplate.getMissingCloseParenthesis() != -1) {
            completionProposals.add(AcceleoSyntacticCompletionProposals.CLOSE_PARENTHESIS);
            completionProposals.add(AcceleoSyntacticCompletionProposals.COMMA_SPACE);
        } else if (errorTemplate.getMissingGuardOpenParenthesis() != -1) {
            completionProposals.add(AcceleoSyntacticCompletionProposals.OPEN_PARENTHESIS);
        } else if (errorTemplate.getGuard() != null && errorTemplate.getGuard().getAst().getAst() instanceof Error) {
            completionProposals.addAll(this.getAqlCompletionProposals(this.getVariables(errorTemplate), this.acceleoValidationResult.getValidationResult(errorTemplate.getGuard().getAst())));
        } else if (errorTemplate.getMissingGuardCloseParenthesis() != -1) {
            completionProposals.add(AcceleoSyntacticCompletionProposals.CLOSE_PARENTHESIS);
            completionProposals.addAll(this.getAqlCompletionProposals(this.getVariables(errorTemplate), this.acceleoValidationResult.getValidationResult(errorTemplate.getGuard().getAst())));
        } else if (errorTemplate.getPost() != null && errorTemplate.getPost().getAst().getAst() instanceof Error) {
            HashMap<String, Set<IType>> variables = new HashMap<String, Set<IType>>();
            Set<ClassType> possibleTypes = Collections.singleton(new ClassType((IReadOnlyQueryEnvironment)this.acceleoEnvironment.getQueryEnvironment(), String.class));
            variables.put("self", possibleTypes);
            completionProposals.addAll(this.getAqlCompletionProposals(variables, this.acceleoValidationResult.getValidationResult(errorTemplate.getPost().getAst())));
        } else if (errorTemplate.getMissingPostCloseParenthesis() != -1) {
            completionProposals.add(AcceleoSyntacticCompletionProposals.CLOSE_PARENTHESIS);
            completionProposals.addAll(this.getAqlCompletionProposals(this.getVariables(errorTemplate), this.acceleoValidationResult.getValidationResult(errorTemplate.getPost().getAst())));
        } else if (errorTemplate.getMissingEndHeader() != -1) {
            completionProposals.add(AcceleoSyntacticCompletionProposals.TEMPLATE_HEADER_END);
            if (errorTemplate.getGuard() == null && errorTemplate.getPost() == null) {
                completionProposals.add(AcceleoSyntacticCompletionProposals.TEMPLATE_GUARD_START);
            }
            if (errorTemplate.getPost() == null) {
                completionProposals.add(AcceleoSyntacticCompletionProposals.TEMPLATE_POST_START);
            }
        } else if (errorTemplate.getMissingEnd() != -1) {
            completionProposals.add(AcceleoSyntacticCompletionProposals.TEMPLATE_END);
            completionProposals.addAll(this.getStatementProposals());
        }
        return completionProposals;
    }

    private List<AcceleoCompletionProposal> getStatementProposals() {
        ArrayList<AcceleoCompletionProposal> res = new ArrayList<AcceleoCompletionProposal>();
        res.addAll(this.acceleoCompletionProposalProvider.getProposalsFor(AcceleoPackage.Literals.STATEMENT));
        res.addAll(this.acceleoCompletionProposalProvider.getProposalsFor(AcceleoPackage.Literals.COMMENT));
        res.addAll(this.acceleoCompletionProposalProvider.getProposalsFor(AcceleoPackage.Literals.BLOCK_COMMENT));
        return res;
    }

    @Override
    public List<AcceleoCompletionProposal> caseErrorQuery(ErrorQuery errorQuery) {
        ArrayList<AcceleoCompletionProposal> completionProposals = new ArrayList<AcceleoCompletionProposal>();
        if (errorQuery.getMissingVisibility() != -1) {
            completionProposals.addAll(AcceleoSyntacticCompletionProposals.MODULE_ELEMENT_VISIBILITY_KINDS);
        } else if (errorQuery.getMissingName() != -1) {
            String sampleQueryName = "myQuery";
            completionProposals.add(new AcceleoCodeTemplateCompletionProposal(sampleQueryName, sampleQueryName, AcceleoPackage.Literals.QUERY));
        } else if (errorQuery.getMissingOpenParenthesis() != -1) {
            completionProposals.add(AcceleoSyntacticCompletionProposals.OPEN_PARENTHESIS);
        } else if (errorQuery.getMissingParameters() != -1) {
            String sampleParameterName = "myParameter";
            completionProposals.add(new AcceleoCodeTemplateCompletionProposal(sampleParameterName, sampleParameterName, AcceleoPackage.Literals.TEMPLATE));
        } else if (errorQuery.getMissingCloseParenthesis() != -1) {
            completionProposals.add(AcceleoSyntacticCompletionProposals.CLOSE_PARENTHESIS);
            completionProposals.add(AcceleoSyntacticCompletionProposals.COMMA_SPACE);
        } else if (errorQuery.getMissingColon() != -1) {
            completionProposals.add(AcceleoSyntacticCompletionProposals.COLON_SPACE);
        } else if (errorQuery.getMissingType() != -1) {
            IValidationResult typeValidation = this.acceleoValidationResult.getValidationResult(errorQuery.getType());
            completionProposals.addAll(this.astCompletor.getProposals(Collections.emptySet(), typeValidation).stream().map(AcceleoAstCompletor::transform).collect(Collectors.toList()));
        } else if (errorQuery.getMissingEqual() != -1) {
            completionProposals.add(AcceleoSyntacticCompletionProposals.EQUAL_SPACE);
        } else if (errorQuery.getBody().getAst().getAst() instanceof Error) {
            completionProposals.addAll(this.getAqlCompletionProposals(this.getVariables(errorQuery), this.acceleoValidationResult.getValidationResult(errorQuery.getBody().getAst())));
        } else if (errorQuery.getMissingEnd() != -1) {
            completionProposals.add(AcceleoSyntacticCompletionProposals.QUERY_END);
            completionProposals.addAll(this.getAqlCompletionProposals(this.getVariables(errorQuery), this.acceleoValidationResult.getValidationResult(errorQuery.getBody().getAst())));
        }
        return completionProposals;
    }

    @Override
    public List<AcceleoCompletionProposal> caseErrorVariable(ErrorVariable errorVariable) {
        ArrayList<AcceleoCompletionProposal> res = new ArrayList<AcceleoCompletionProposal>();
        if (errorVariable.getMissingName() == -1) {
            if (errorVariable.getMissingColon() != -1) {
                res.add(AcceleoSyntacticCompletionProposals.COLON_SPACE);
            } else if (errorVariable.getMissingType() != -1) {
                IValidationResult typeValidation = this.acceleoValidationResult.getValidationResult(errorVariable.getType());
                res.addAll(this.astCompletor.getProposals(Collections.emptySet(), typeValidation).stream().map(AcceleoAstCompletor::transform).collect(Collectors.toList()));
            }
        }
        return res;
    }

    @Override
    public List<AcceleoCompletionProposal> caseErrorExpression(ErrorExpression errorExpression) {
        ArrayList<AcceleoCompletionProposal> res = new ArrayList<AcceleoCompletionProposal>();
        if (errorExpression.getAst() instanceof Error) {
            res.addAll(this.getAqlCompletionProposals(this.getVariables(errorExpression), this.acceleoValidationResult.getValidationResult(errorExpression.getAst())));
        }
        return res;
    }

    private Map<String, Set<IType>> getVariables(ASTNode scope) {
        HashMap<String, Set<IType>> res = new HashMap<String, Set<IType>>();
        ASTNode currentScope = scope;
        while (currentScope != null) {
            if (currentScope instanceof Template) {
                Template template = (Template)currentScope;
                for (Variable variable : template.getParameters()) {
                    res.put(variable.getName(), this.getPossibleTypes(variable));
                }
            } else if (currentScope instanceof Query) {
                Query query = (Query)currentScope;
                for (Variable variable : query.getParameters()) {
                    res.put(variable.getName(), this.getPossibleTypes(variable));
                }
            } else if (currentScope instanceof LetStatement) {
                LetStatement let = (LetStatement)currentScope;
                for (Variable variable : let.getVariables()) {
                    res.put(variable.getName(), this.getPossibleTypes(variable));
                }
            } else if (currentScope instanceof ForStatement) {
                ForStatement forStatement = (ForStatement)currentScope;
                res.put(forStatement.getBinding().getName(), this.getPossibleTypes(forStatement.getBinding()));
            }
            currentScope = currentScope.eContainer() instanceof ASTNode ? (ASTNode)currentScope.eContainer() : null;
        }
        return res;
    }

    private LinkedHashSet<IType> getPossibleTypes(Variable variable) {
        LinkedHashSet<IType> res = new LinkedHashSet<IType>();
        IValidationResult validationResult = this.acceleoValidationResult.getValidationResult(variable.getType());
        if (variable.getType() != null) {
            res.addAll(validationResult.getPossibleTypes(variable.getType().getAst()));
        }
        return res;
    }

    private LinkedHashSet<IType> getPossibleTypes(Binding binding) {
        LinkedHashSet<Object> res;
        if (binding.getInitExpression() != null) {
            IValidationResult validationResult = this.acceleoValidationResult.getValidationResult(binding.getInitExpression().getAst());
            res = new LinkedHashSet();
            if (binding.getType() != null) {
                res.addAll(validationResult.getPossibleTypes(binding.getInitExpression().getAst().getAst()));
            }
        } else {
            res = this.getPossibleTypes((Variable)binding);
        }
        return res;
    }

    @Override
    public List<AcceleoCompletionProposal> caseErrorBinding(ErrorBinding errorBinding) {
        ArrayList<AcceleoCompletionProposal> completionProposals = new ArrayList<AcceleoCompletionProposal>();
        if (errorBinding.getMissingName() != -1) {
            String sampleVariableName = "myVariable";
            completionProposals.add(new AcceleoCodeTemplateCompletionProposal(sampleVariableName, sampleVariableName, AcceleoPackage.Literals.BINDING));
        } else if (errorBinding.getMissingColon() != -1) {
            completionProposals.add(AcceleoSyntacticCompletionProposals.COLON_SPACE);
        } else if (errorBinding.getMissingType() != -1) {
            IValidationResult typeValidationResult = this.acceleoValidationResult.getValidationResult(errorBinding.getType());
            completionProposals.addAll(this.astCompletor.getProposals(Collections.emptySet(), typeValidationResult).stream().map(AcceleoAstCompletor::transform).collect(Collectors.toList()));
        } else if (errorBinding.getMissingAffectationSymbolePosition() != -1) {
            if (errorBinding.getType() == null && errorBinding.getTypeAql() == null) {
                completionProposals.add(AcceleoSyntacticCompletionProposals.COLON_SPACE);
            }
            completionProposals.add(new AcceleoCompletionProposal(errorBinding.getMissingAffectationSymbole(), String.valueOf(errorBinding.getMissingAffectationSymbole()) + SPACE, AcceleoPackage.Literals.BINDING));
        } else if (errorBinding.getInitExpression().getAst().getAst() instanceof Error) {
            completionProposals.addAll(this.getAqlCompletionProposals(this.getVariables(errorBinding), this.acceleoValidationResult.getValidationResult(errorBinding.getInitExpression().getAst())));
        }
        return completionProposals;
    }

    @Override
    public List<AcceleoCompletionProposal> caseErrorExpressionStatement(ErrorExpressionStatement errorExpressionStatement) {
        ArrayList<AcceleoCompletionProposal> res = new ArrayList<AcceleoCompletionProposal>();
        if (errorExpressionStatement.getExpression().getAst().getAst() instanceof Error) {
            res.addAll(this.getAqlCompletionProposals(this.getVariables(errorExpressionStatement), this.acceleoValidationResult.getValidationResult(errorExpressionStatement.getExpression().getAst())));
        } else if (errorExpressionStatement.getMissingEndHeader() != -1) {
            res.addAll(this.getAqlCompletionProposals(this.getVariables(errorExpressionStatement), this.acceleoValidationResult.getValidationResult(errorExpressionStatement.getExpression().getAst())));
            res.add(AcceleoSyntacticCompletionProposals.STATEMENT_EXPRESSION_END);
        }
        return res;
    }

    @Override
    public List<AcceleoCompletionProposal> caseErrorProtectedArea(ErrorProtectedArea errorProtectedArea) {
        ArrayList<AcceleoCompletionProposal> res = new ArrayList<AcceleoCompletionProposal>();
        if (errorProtectedArea.getMissingOpenParenthesis() != -1) {
            res.add(AcceleoSyntacticCompletionProposals.OPEN_PARENTHESIS);
        } else if (errorProtectedArea.getId().getAst().getAst() instanceof Error) {
            res.addAll(this.getAqlCompletionProposals(this.getVariables(errorProtectedArea), this.acceleoValidationResult.getValidationResult(errorProtectedArea.getId().getAst())));
        } else if (errorProtectedArea.getMissingCloseParenthesis() != -1) {
            res.addAll(this.getAqlCompletionProposals(this.getVariables(errorProtectedArea), this.acceleoValidationResult.getValidationResult(errorProtectedArea.getId().getAst())));
            res.add(AcceleoSyntacticCompletionProposals.STATEMENT_PROTECTED_AREA_HEADER_CLOSE_PARENTHESIS_AND_END);
        } else if (errorProtectedArea.getMissingEndHeader() != -1) {
            res.add(AcceleoSyntacticCompletionProposals.STATEMENT_PROTECTED_AREA_HEADER_END);
        } else if (errorProtectedArea.getMissingEnd() != -1) {
            res.add(AcceleoSyntacticCompletionProposals.STATEMENT_PROTECTED_AREA_END);
            res.addAll(this.getStatementProposals());
        }
        return res;
    }

    @Override
    public List<AcceleoCompletionProposal> caseErrorForStatement(ErrorForStatement errorForStatement) {
        ArrayList<AcceleoCompletionProposal> res = new ArrayList<AcceleoCompletionProposal>();
        if (errorForStatement.getMissingOpenParenthesis() != -1) {
            res.add(AcceleoSyntacticCompletionProposals.OPEN_PARENTHESIS);
        } else if (errorForStatement.getMissingBinding() != -1) {
            res.addAll(this.acceleoCompletionProposalProvider.getProposalsFor(AcceleoPackage.Literals.BINDING));
            res.add(AcceleoSyntacticCompletionProposals.FOR_STATEMENT_PIPE);
        } else if (errorForStatement.getMissingCloseParenthesis() != -1) {
            res.add(AcceleoSyntacticCompletionProposals.STATEMENT_FOR_HEADER_CLOSE_PARENTHESIS_AND_END);
            if (errorForStatement.getSeparator() == null) {
                res.add(AcceleoSyntacticCompletionProposals.STATEMENT_FOR_HEADER_SEPARATOR);
            }
            res.addAll(this.getAqlCompletionProposals(this.getVariables(errorForStatement), this.acceleoValidationResult.getValidationResult(errorForStatement.getBinding().getType())));
        } else if (errorForStatement.getSeparator() != null && errorForStatement.getSeparator().getAst().getAst() instanceof Error) {
            res.addAll(this.getAqlCompletionProposals(this.getVariables(errorForStatement), this.acceleoValidationResult.getValidationResult(errorForStatement.getSeparator().getAst())));
        } else if (errorForStatement.getMissingSeparatorCloseParenthesis() != -1) {
            res.add(AcceleoSyntacticCompletionProposals.STATEMENT_FOR_HEADER_CLOSE_PARENTHESIS_AND_END);
        } else if (errorForStatement.getMissingEndHeader() != -1) {
            res.add(AcceleoSyntacticCompletionProposals.STATEMENT_FOR_HEADER_END);
            if (errorForStatement.getSeparator() == null) {
                res.add(AcceleoSyntacticCompletionProposals.STATEMENT_FOR_HEADER_SEPARATOR);
            }
        } else if (errorForStatement.getMissingEnd() != -1) {
            res.add(AcceleoSyntacticCompletionProposals.STATEMENT_FOR_END);
            res.addAll(this.getStatementProposals());
        }
        return res;
    }

    @Override
    public List<AcceleoCompletionProposal> caseErrorIfStatement(ErrorIfStatement errorIfStatement) {
        ArrayList<AcceleoCompletionProposal> res = new ArrayList<AcceleoCompletionProposal>();
        if (errorIfStatement.getMissingOpenParenthesis() != -1) {
            res.add(AcceleoSyntacticCompletionProposals.OPEN_PARENTHESIS);
        } else if (errorIfStatement.getCondition().getAst().getAst() instanceof Error) {
            res.addAll(this.getAqlCompletionProposals(this.getVariables(errorIfStatement), this.acceleoValidationResult.getValidationResult(errorIfStatement.getCondition().getAst())));
        } else if (errorIfStatement.getMissingCloseParenthesis() != -1) {
            res.add(AcceleoSyntacticCompletionProposals.STATEMENT_IF_HEADER_CLOSE_PARENTHESIS_AND_END);
            res.addAll(this.getAqlCompletionProposals(this.getVariables(errorIfStatement), this.acceleoValidationResult.getValidationResult(errorIfStatement.getCondition().getAst())));
        } else if (errorIfStatement.getMissingEndHeader() != -1) {
            res.add(AcceleoSyntacticCompletionProposals.STATEMENT_IF_HEADER_END);
        } else if (errorIfStatement.getMissingEnd() != -1) {
            if (errorIfStatement.getElse() == null) {
                res.add(AcceleoSyntacticCompletionProposals.STATEMENT_IF_ELSE);
                if (errorIfStatement.eContainer().eContainingFeature() == AcceleoPackage.eINSTANCE.getIfStatement_Else() || !(errorIfStatement.eContainer().eContainer() instanceof IfStatement)) {
                    res.add(AcceleoSyntacticCompletionProposals.STATEMENT_IF_ELSEIF);
                }
            }
            res.add(AcceleoSyntacticCompletionProposals.STATEMENT_IF_END);
            res.addAll(this.getStatementProposals());
        }
        return res;
    }

    @Override
    public List<AcceleoCompletionProposal> caseErrorLetStatement(ErrorLetStatement errorLetStatement) {
        ArrayList<AcceleoCompletionProposal> completionProposals = new ArrayList<AcceleoCompletionProposal>();
        if (errorLetStatement.getMissingBindings() != -1) {
            completionProposals.addAll(this.acceleoCompletionProposalProvider.getProposalsFor(AcceleoPackage.Literals.BINDING));
        } else if (errorLetStatement.getMissingEndHeader() != -1) {
            completionProposals.add(AcceleoSyntacticCompletionProposals.STATEMENT_LET_HEADER_END);
            EList bindings = errorLetStatement.getVariables();
            completionProposals.addAll(this.getAqlCompletionProposals(this.getVariables(errorLetStatement), this.acceleoValidationResult.getValidationResult(((Binding)bindings.get(bindings.size() - 1)).getType())));
        } else if (errorLetStatement.getMissingEnd() != -1) {
            completionProposals.add(AcceleoSyntacticCompletionProposals.STATEMENT_LET_END);
            completionProposals.addAll(this.getStatementProposals());
        }
        return completionProposals;
    }

    @Override
    public List<AcceleoCompletionProposal> caseErrorFileStatement(ErrorFileStatement errorFileStatement) {
        ArrayList<AcceleoCompletionProposal> res = new ArrayList<AcceleoCompletionProposal>();
        if (errorFileStatement.getMissingOpenParenthesis() != -1) {
            res.add(AcceleoSyntacticCompletionProposals.OPEN_PARENTHESIS);
        } else if (errorFileStatement.getUrl().getAst().getAst() instanceof Error) {
            res.addAll(this.getAqlCompletionProposals(this.getVariables(errorFileStatement), this.acceleoValidationResult.getValidationResult(errorFileStatement.getUrl().getAst())));
        } else if (errorFileStatement.getMissingComma() != -1) {
            res.addAll(this.getAqlCompletionProposals(this.getVariables(errorFileStatement), this.acceleoValidationResult.getValidationResult(errorFileStatement.getUrl().getAst())));
            res.add(AcceleoSyntacticCompletionProposals.COMMA_SPACE);
        } else if (errorFileStatement.getMissingOpenMode() != -1) {
            res.addAll(AcceleoSyntacticCompletionProposals.STATEMENT_FILE_OPEN_MODES);
        } else if (errorFileStatement.getMissingCloseParenthesis() != -1) {
            res.add(AcceleoSyntacticCompletionProposals.STATEMENT_FILE_HEADER_CLOSE_PARENTHESIS_AND_END);
        } else if (errorFileStatement.getMissingEndHeader() != -1) {
            res.add(AcceleoSyntacticCompletionProposals.STATEMENT_FILE_HEADER_END);
        } else if (errorFileStatement.getMissingEnd() != -1) {
            res.add(AcceleoSyntacticCompletionProposals.STATEMENT_FILE_END);
            res.addAll(this.getStatementProposals());
        }
        return res;
    }

    private List<AcceleoCompletionProposal> getAqlCompletionProposals(Map<String, Set<IType>> variables, IValidationResult aqlValidationResult) {
        int startPosition = this.acceleoValidationResult.getAcceleoAstResult().getStartPosition(aqlValidationResult.getAstResult().getAst());
        String expression = this.moduleSourceFragment.substring(startPosition, this.moduleSourceFragment.length());
        ICompletionResult completionResult = this.aqlCompletionEngine.getCompletion(expression, expression.length(), variables);
        List aqlProposals = completionResult.getProposals((IProposalFilter)new BasicFilter(completionResult));
        Collections.sort(aqlProposals, COMPLETION_PROPOSAL_COMPARATOR);
        List<AcceleoCompletionProposal> aqlProposalsAsAcceleoProposals = aqlProposals.stream().map(AcceleoAstCompletor::transform).collect(Collectors.toList());
        return aqlProposalsAsAcceleoProposals;
    }

    private static AcceleoCompletionProposal transform(ICompletionProposal aqlCompletionProposal) {
        return new AcceleoCompletionProposal(aqlCompletionProposal.getProposal(), aqlCompletionProposal.getDescription().replace("\n", "<br>"), aqlCompletionProposal.getProposal(), AcceleoPackage.Literals.EXPRESSION);
    }

    private static class ProposalComparator
    implements Comparator<ICompletionProposal> {
        private ProposalComparator() {
        }

        @Override
        public int compare(ICompletionProposal o1, ICompletionProposal o2) {
            int value1 = this.getValue(o1);
            int value2 = this.getValue(o2);
            int res = o1 instanceof IServiceCompletionProposal && o2 instanceof IServiceCompletionProposal ? ((IServiceCompletionProposal)o1).getObject().getShortSignature().compareTo(((IServiceCompletionProposal)o2).getObject().getShortSignature()) : (value1 > value2 ? 1 : (value1 < value2 ? -1 : (o1 != null && o2 != null ? o1.getProposal().compareTo(o2.getProposal()) : 0)));
            return res;
        }

        private int getValue(ICompletionProposal proposal) {
            int res = proposal instanceof VariableCompletionProposal || proposal instanceof VariableDeclarationCompletionProposal ? 0 : (proposal instanceof EFeatureCompletionProposal ? 1 : (proposal instanceof IServiceCompletionProposal || proposal instanceof EOperationServiceCompletionProposal ? 2 : (proposal instanceof EClassifierCompletionProposal || proposal instanceof EEnumLiteralCompletionProposal || proposal instanceof EFeatureCompletionProposal ? 3 : 4)));
            return res;
        }
    }
}

