/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.query.runtime.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.acceleo.query.ast.Call;
import org.eclipse.acceleo.query.ast.Declaration;
import org.eclipse.acceleo.query.ast.Expression;
import org.eclipse.acceleo.query.ast.VarRef;
import org.eclipse.acceleo.query.parser.AstResult;
import org.eclipse.acceleo.query.runtime.IService;
import org.eclipse.acceleo.query.runtime.IValidationMessage;
import org.eclipse.acceleo.query.runtime.IValidationResult;
import org.eclipse.acceleo.query.validation.type.IType;

public class ValidationResult
implements IValidationResult {
    private final Map<Expression, Set<IType>> types = new HashMap<Expression, Set<IType>>();
    private final Map<Expression, Map<Boolean, Map<String, Set<IType>>>> inferredVariableType = new HashMap<Expression, Map<Boolean, Map<String, Set<IType>>>>();
    private final Map<IService<?>, List<Call>> resolvedCalls = new HashMap();
    private final Map<Call, List<IService<?>>> serviceDeclarations = new HashMap();
    private final Map<Declaration, List<VarRef>> resolvedVarRef = new HashMap<Declaration, List<VarRef>>();
    private final Map<VarRef, Declaration> declarations = new HashMap<VarRef, Declaration>();
    private final List<VarRef> unresolvedVarRef = new ArrayList<VarRef>();
    private final List<IValidationMessage> messages = new ArrayList<IValidationMessage>();
    private final AstResult astResult;

    public ValidationResult(AstResult astResult) {
        this.astResult = astResult;
    }

    public void addTypes(Expression expression, Set<IType> possibleTypes) {
        this.types.put(expression, possibleTypes);
    }

    @Override
    public Set<IType> getPossibleTypes(Expression expression) {
        return this.types.get(expression);
    }

    @Override
    public List<IValidationMessage> getMessages() {
        return this.messages;
    }

    @Override
    public AstResult getAstResult() {
        return this.astResult;
    }

    public void putInferredVariableTypes(Expression expression, Boolean value, Map<String, Set<IType>> inferredTypes) {
        this.inferredVariableType.computeIfAbsent(expression, e -> new HashMap()).computeIfAbsent(value, v -> new HashMap()).putAll(inferredTypes);
    }

    @Override
    public Map<String, Set<IType>> getInferredVariableTypes(Expression expression, Boolean value) {
        return this.inferredVariableType.getOrDefault(expression, Collections.emptyMap()).getOrDefault(value, Collections.emptyMap());
    }

    public void putResolvedCall(IService<?> service, Call call) {
        this.resolvedCalls.computeIfAbsent(service, s -> new ArrayList()).add(call);
        this.serviceDeclarations.computeIfAbsent(call, c -> new ArrayList()).add(service);
    }

    @Override
    public List<Call> getResolvedCalls(IService<?> service) {
        return this.resolvedCalls.getOrDefault(service, Collections.emptyList());
    }

    public void putResolvedVarRef(Declaration declaration, VarRef varRef) {
        this.resolvedVarRef.computeIfAbsent(declaration, s -> new ArrayList()).add(varRef);
        this.declarations.put(varRef, declaration);
    }

    @Override
    public List<VarRef> getResolvedVarRef(Declaration declaration) {
        return this.resolvedVarRef.get(declaration);
    }

    @Override
    public List<VarRef> getUnresolvedVarRef() {
        return this.unresolvedVarRef;
    }

    @Override
    public Declaration getDeclaration(VarRef varRef) {
        return this.declarations.get(varRef);
    }

    @Override
    public List<IService<?>> getDeclarationIService(Call call) {
        return this.serviceDeclarations.getOrDefault(call, Collections.emptyList());
    }
}

