/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.aql.migration.converters;

import java.io.File;
import java.io.IOException;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.acceleo.AcceleoFactory;
import org.eclipse.acceleo.Expression;
import org.eclipse.acceleo.ExpressionStatement;
import org.eclipse.acceleo.Statement;
import org.eclipse.acceleo.aql.migration.MigrationException;
import org.eclipse.acceleo.aql.migration.converters.AbstractConverter;
import org.eclipse.acceleo.aql.migration.converters.ServiceWithNoParameterMethodRefactorVisitor;
import org.eclipse.acceleo.aql.migration.converters.utils.OperationUtils;
import org.eclipse.acceleo.aql.migration.converters.utils.TypeUtils;
import org.eclipse.acceleo.model.mtl.ForBlock;
import org.eclipse.acceleo.model.mtl.Query;
import org.eclipse.acceleo.model.mtl.QueryInvocation;
import org.eclipse.acceleo.model.mtl.Template;
import org.eclipse.acceleo.model.mtl.TemplateInvocation;
import org.eclipse.acceleo.query.ast.AstFactory;
import org.eclipse.acceleo.query.ast.AstPackage;
import org.eclipse.acceleo.query.ast.BooleanLiteral;
import org.eclipse.acceleo.query.ast.Call;
import org.eclipse.acceleo.query.ast.CallType;
import org.eclipse.acceleo.query.ast.Conditional;
import org.eclipse.acceleo.query.ast.EnumLiteral;
import org.eclipse.acceleo.query.ast.IntegerLiteral;
import org.eclipse.acceleo.query.ast.Lambda;
import org.eclipse.acceleo.query.ast.RealLiteral;
import org.eclipse.acceleo.query.ast.SequenceInExtensionLiteral;
import org.eclipse.acceleo.query.ast.SetInExtensionLiteral;
import org.eclipse.acceleo.query.ast.StringLiteral;
import org.eclipse.acceleo.query.ast.VarRef;
import org.eclipse.acceleo.query.ast.VariableDeclaration;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EEnumLiteral;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EOperation;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.impl.EOperationImpl;
import org.eclipse.emf.ecore.impl.EStructuralFeatureImpl;
import org.eclipse.jdt.core.dom.ASTParser;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.ocl.ecore.BooleanLiteralExp;
import org.eclipse.ocl.ecore.CollectionItem;
import org.eclipse.ocl.ecore.CollectionLiteralExp;
import org.eclipse.ocl.ecore.CollectionType;
import org.eclipse.ocl.ecore.EnumLiteralExp;
import org.eclipse.ocl.ecore.IfExp;
import org.eclipse.ocl.ecore.IntegerLiteralExp;
import org.eclipse.ocl.ecore.IteratorExp;
import org.eclipse.ocl.ecore.OperationCallExp;
import org.eclipse.ocl.ecore.OrderedSetType;
import org.eclipse.ocl.ecore.PropertyCallExp;
import org.eclipse.ocl.ecore.RealLiteralExp;
import org.eclipse.ocl.ecore.SetType;
import org.eclipse.ocl.ecore.StringLiteralExp;
import org.eclipse.ocl.ecore.TypeExp;
import org.eclipse.ocl.ecore.Variable;
import org.eclipse.ocl.ecore.VariableExp;
import org.eclipse.ocl.expressions.OCLExpression;

public final class ExpressionConverter
extends AbstractConverter {
    public static final String JAVA_SERVICE = "JavaService";
    private static final String SELF_VARIABLE_NAME = "self";
    private boolean resolveSelf = true;
    private final Path targetFolderPath;
    private int varCount;
    private Map<Call, String> javaServiceCalls = new HashMap<Call, String>();

    public ExpressionConverter(Path targetFolderPath) {
        this.targetFolderPath = targetFolderPath;
    }

    public Map<Call, String> getJavaServiceCalls() {
        return this.javaServiceCalls;
    }

    public Statement convertToStatement(org.eclipse.ocl.ecore.OCLExpression input) {
        ExpressionStatement output = AcceleoFactory.eINSTANCE.createExpressionStatement();
        output.setExpression(this.convertToExpression(input, false));
        return output;
    }

    public Expression convertToExpression(org.eclipse.ocl.ecore.OCLExpression inputExpression, boolean allowSelf) {
        Expression outputExpression = AcceleoFactory.eINSTANCE.createExpression();
        if (allowSelf) {
            this.resolveSelf = false;
        }
        outputExpression.setAst(ExpressionConverter.createAstResult((org.eclipse.acceleo.query.ast.Expression)this.convert((EObject)inputExpression)));
        if (allowSelf) {
            this.resolveSelf = true;
        }
        return outputExpression;
    }

    @Override
    protected Object convert(EObject input) {
        Object output = null;
        switch (input.eClass().getClassifierID()) {
            case 51: {
                output = this.caseVariable((Variable)input);
                break;
            }
            case 43: {
                output = this.casePropertyCallExp((PropertyCallExp)input);
                break;
            }
            case 52: {
                output = this.caseVariableExp((VariableExp)input);
                break;
            }
            case 6: {
                output = this.caseTemplateInvocation((TemplateInvocation)input);
                break;
            }
            case 8: {
                output = this.caseQueryInvocation((QueryInvocation)input);
                break;
            }
            case 32: {
                output = this.caseIteratorExp((IteratorExp)input);
                break;
            }
            case 49: {
                output = TypeUtils.createTypeLiteral((EClassifier)((TypeExp)input).getReferredType());
                break;
            }
            case 41: {
                output = this.caseOperationCallExp((OperationCallExp)input);
                break;
            }
            case 46: {
                output = AstFactory.eINSTANCE.createStringLiteral();
                output.setValue(((StringLiteralExp)input).getStringSymbol());
                break;
            }
            case 28: {
                output = AstFactory.eINSTANCE.createIntegerLiteral();
                ((IntegerLiteral)output).setValue(((IntegerLiteralExp)input).getIntegerSymbol().intValue());
                break;
            }
            case 19: {
                output = AstFactory.eINSTANCE.createBooleanLiteral();
                ((BooleanLiteral)output).setValue(((BooleanLiteralExp)input).getBooleanSymbol().booleanValue());
                break;
            }
            case 44: {
                output = AstFactory.eINSTANCE.createRealLiteral();
                ((RealLiteral)output).setValue(((RealLiteralExp)input).getRealSymbol().doubleValue());
                break;
            }
            case 25: {
                output = AstFactory.eINSTANCE.createEnumLiteral();
                ((EnumLiteral)output).setEPackageName(((EEnumLiteral)((EnumLiteralExp)input).getReferredEnumLiteral()).getEEnum().getEPackage().getName());
                ((EnumLiteral)output).setEEnumName(((EEnumLiteral)((EnumLiteralExp)input).getReferredEnumLiteral()).getEEnum().getName());
                ((EnumLiteral)output).setEEnumLiteralName(((EEnumLiteral)((EnumLiteralExp)input).getReferredEnumLiteral()).getName());
                break;
            }
            case 38: {
                output = AstFactory.eINSTANCE.createNullLiteral();
                break;
            }
            case 22: {
                output = this.convertCollectionLiteralExp((CollectionLiteralExp)input);
                break;
            }
            case 27: {
                output = this.caseIfExp((IfExp)input);
                break;
            }
            case 21: {
                output = this.convert((EObject)((CollectionItem)input).getItem());
                break;
            }
            default: {
                throw new MigrationException(input);
            }
        }
        return output;
    }

    private Object caseIfExp(IfExp input) {
        Conditional output = AstFactory.eINSTANCE.createConditional();
        output.setPredicate((org.eclipse.acceleo.query.ast.Expression)this.convert((EObject)input.getCondition()));
        output.setTrueBranch((org.eclipse.acceleo.query.ast.Expression)this.convert((EObject)input.getThenExpression()));
        output.setFalseBranch((org.eclipse.acceleo.query.ast.Expression)this.convert((EObject)input.getElseExpression()));
        return output;
    }

    private Object caseVariable(Variable input) {
        VariableDeclaration output = AstFactory.eINSTANCE.createVariableDeclaration();
        output.setName(input.getName());
        if (output.getExpression() != null) {
            output.setExpression((org.eclipse.acceleo.query.ast.Expression)this.convert((EObject)input.getInitExpression()));
        }
        return output;
    }

    private org.eclipse.acceleo.query.ast.Expression caseVariableExp(VariableExp input) {
        VarRef output = null;
        output = AstFactory.eINSTANCE.createVarRef();
        String variableName = input.getReferredVariable().getName();
        if (this.resolveSelf && SELF_VARIABLE_NAME.equals(variableName)) {
            Variable variable = ExpressionConverter.findVariable((EObject)input);
            variableName = variable.getName();
        }
        output.setVariableName(variableName);
        return output;
    }

    private org.eclipse.acceleo.query.ast.Expression casePropertyCallExp(PropertyCallExp input) {
        Call output = AstFactory.eINSTANCE.createCall();
        output.setServiceName("aqlFeatureAccess");
        if (input.getSource().getType() instanceof CollectionType) {
            output.setType(CallType.COLLECTIONCALL);
        } else {
            output.setType(CallType.CALLORAPPLY);
        }
        output.getArguments().add((Object)((org.eclipse.acceleo.query.ast.Expression)this.convert((EObject)input.getSource())));
        StringLiteral propertyName = AstFactory.eINSTANCE.createStringLiteral();
        if (!((EStructuralFeature)input.getReferredProperty()).eIsProxy()) {
            propertyName.setValue(((EStructuralFeature)input.getReferredProperty()).getName());
        } else {
            URI proxyURI = ((EStructuralFeatureImpl)input.getReferredProperty()).eProxyURI();
            String[] segments = proxyURI.fragment().split("/");
            propertyName.setValue(segments[segments.length - 1]);
        }
        output.getArguments().add((Object)propertyName);
        return output;
    }

    private org.eclipse.acceleo.query.ast.Expression caseOperationCallExp(OperationCallExp input) {
        org.eclipse.acceleo.query.ast.Expression res;
        if ("oclIsUndefined".equals(((EOperation)input.getReferredOperation()).getName())) {
            Call output = AstFactory.eINSTANCE.createCall();
            output.setServiceName("equals");
            output.setType(CallType.CALLSERVICE);
            output.getArguments().add((Object)((org.eclipse.acceleo.query.ast.Expression)this.convert((EObject)input.getSource())));
            output.getArguments().add((Object)AstFactory.eINSTANCE.createNullLiteral());
            res = output;
        } else if (this.isIntegerDivOpCall(input)) {
            res = this.convertIntegerDivOpCall(input);
        } else if (this.isInvokeCall(input)) {
            res = this.convertInvokeCall(input);
        } else if (this.isOclAsSetCall(input)) {
            res = this.convertOclAsSetCall(input);
        } else if (this.isAddAllCall(input)) {
            res = this.convertAddAllCall(input);
        } else if (this.isRemoveAllCall(input)) {
            res = this.convertRemoveAllCall(input);
        } else if (this.isSelectByKindOrTypeCall(input)) {
            res = this.convertSelectByKindOrTypeCall(input);
        } else if (this.isTokenizeLineCall(input)) {
            res = this.convertTokenizeLineCall(input);
        } else if (this.isCurrentCall(input)) {
            res = this.convertCurrentCall(input);
        } else {
            Call output = OperationUtils.createCall(input);
            output.getArguments().add((Object)((org.eclipse.acceleo.query.ast.Expression)this.convert((EObject)input.getSource())));
            this.map((Collection<? extends EObject>)input.getArgument(), (List)output.getArguments());
            res = output;
        }
        return res;
    }

    private org.eclipse.acceleo.query.ast.Expression convertCurrentCall(OperationCallExp input) {
        VarRef res;
        String variableName;
        OCLExpression firstArgument = (OCLExpression)input.getArgument().get(0);
        if (firstArgument instanceof IntegerLiteralExp) {
            int index = ((IntegerLiteralExp)firstArgument).getIntegerSymbol();
            variableName = this.getCurrentVariableName(input, index);
        } else if (firstArgument instanceof TypeExp) {
            EClassifier eClassifier = (EClassifier)((TypeExp)firstArgument).getReferredType();
            variableName = this.getCurrentVariableName(input, eClassifier);
        } else {
            variableName = null;
        }
        if (variableName != null) {
            res = AstFactory.eINSTANCE.createVarRef();
            res.setVariableName(variableName);
        } else {
            Call output = OperationUtils.createCall(input);
            output.getArguments().add((Object)((org.eclipse.acceleo.query.ast.Expression)this.convert((EObject)input.getSource())));
            this.map((Collection<? extends EObject>)input.getArgument(), (List)output.getArguments());
            res = output;
        }
        return res;
    }

    private String getCurrentVariableName(OperationCallExp input, EClassifier eClassifier) {
        String res = null;
        EObject container = input.eContainer();
        while (container != null) {
            ForBlock forBlock;
            EClassifier forType;
            if (container instanceof ForBlock && (eClassifier == (forType = (EClassifier)(forBlock = (ForBlock)container).getLoopVariable().getType()) || eClassifier instanceof EClass && forType instanceof EClass && ((EClass)forType).isSuperTypeOf((EClass)eClassifier))) {
                res = forBlock.getLoopVariable().getName();
                break;
            }
            container = container.eContainer();
        }
        return res;
    }

    private String getCurrentVariableName(OperationCallExp input, int index) {
        String res = null;
        int localIndex = index;
        EObject container = input.eContainer();
        ForBlock lastFor = null;
        while (container != null) {
            if (container instanceof ForBlock) {
                ForBlock forBlock = (ForBlock)container;
                if (localIndex == 0) {
                    res = forBlock.getLoopVariable().getName();
                    break;
                }
                --localIndex;
                lastFor = forBlock;
            }
            container = container.eContainer();
            if (localIndex <= 0 || lastFor == null) continue;
            res = ExpressionConverter.findVariable((EObject)lastFor).getName();
        }
        return res;
    }

    private boolean isCurrentCall(OperationCallExp input) {
        EOperation referredOperation = (EOperation)input.getReferredOperation();
        return referredOperation != null && "current".equals(referredOperation.getName());
    }

    private org.eclipse.acceleo.query.ast.Expression convertTokenizeLineCall(OperationCallExp input) {
        Call res = AstFactory.eINSTANCE.createCall();
        res.setType(CallType.CALLSERVICE);
        res.setServiceName("tokenize");
        res.getArguments().add((Object)((org.eclipse.acceleo.query.ast.Expression)this.convert((EObject)input.getSource())));
        StringLiteral stringLiteral = AstFactory.eINSTANCE.createStringLiteral();
        stringLiteral.setValue("");
        Call lineSeparator = AstFactory.eINSTANCE.createCall();
        lineSeparator.setType(CallType.CALLSERVICE);
        lineSeparator.setServiceName("lineSeparator");
        lineSeparator.getArguments().add((Object)stringLiteral);
        res.getArguments().add((Object)lineSeparator);
        return res;
    }

    private boolean isTokenizeLineCall(OperationCallExp input) {
        EOperation referredOperation = (EOperation)input.getReferredOperation();
        return referredOperation != null && "tokenizeLine".equals(referredOperation.getName()) && "oclstdlib_String_Class".equals(((EClass)referredOperation.eContainer()).getName());
    }

    private org.eclipse.acceleo.query.ast.Expression convertSelectByKindOrTypeCall(OperationCallExp input) {
        Call res = AstFactory.eINSTANCE.createCall();
        res.setType(CallType.COLLECTIONCALL);
        res.setServiceName("select");
        res.getArguments().add((Object)((org.eclipse.acceleo.query.ast.Expression)this.convert((EObject)input.getSource())));
        Lambda lambda = AstFactory.eINSTANCE.createLambda();
        Call call = AstFactory.eINSTANCE.createCall();
        call.setType(CallType.CALLSERVICE);
        if ("selectByKind".equals(((EOperation)input.getReferredOperation()).getName())) {
            call.setServiceName("oclIsKindOf");
        } else {
            call.setServiceName("oclIsTypeOf");
        }
        VariableDeclaration varDeclaration = AstFactory.eINSTANCE.createVariableDeclaration();
        varDeclaration.setName("var" + this.varCount++);
        lambda.getParameters().add((Object)varDeclaration);
        VarRef varRef = AstFactory.eINSTANCE.createVarRef();
        varRef.setVariableName(varDeclaration.getName());
        call.getArguments().add((Object)varRef);
        call.getArguments().add((Object)((org.eclipse.acceleo.query.ast.Expression)this.convert((EObject)input.getArgument().get(0))));
        lambda.setExpression((org.eclipse.acceleo.query.ast.Expression)call);
        res.getArguments().add((Object)lambda);
        return res;
    }

    private boolean isSelectByKindOrTypeCall(OperationCallExp input) {
        EOperation referredOperation = (EOperation)input.getReferredOperation();
        return !(referredOperation == null || !"selectByKind".equals(referredOperation.getName()) && !"selectByType".equals(referredOperation.getName()) || !"OrderedSet(T)_Class".equals(((EClass)referredOperation.eContainer()).getName()) && !"Sequence(T)_Class".equals(((EClass)referredOperation.eContainer()).getName()));
    }

    private org.eclipse.acceleo.query.ast.Expression convertRemoveAllCall(OperationCallExp input) {
        Call res = OperationUtils.createCall(input);
        res.setServiceName("sub");
        res.getArguments().add((Object)((org.eclipse.acceleo.query.ast.Expression)this.convert((EObject)input.getSource())));
        this.map((Collection<? extends EObject>)input.getArgument(), (List)res.getArguments());
        return res;
    }

    private boolean isRemoveAllCall(OperationCallExp input) {
        EOperation referredOperation = (EOperation)input.getReferredOperation();
        return referredOperation != null && "removeAll".equals(referredOperation.getName()) && "oclstdlib_Collection(T)_Class".equals(((EClass)referredOperation.eContainer()).getName());
    }

    private org.eclipse.acceleo.query.ast.Expression convertAddAllCall(OperationCallExp input) {
        Call res = OperationUtils.createCall(input);
        res.setServiceName("add");
        res.getArguments().add((Object)((org.eclipse.acceleo.query.ast.Expression)this.convert((EObject)input.getSource())));
        this.map((Collection<? extends EObject>)input.getArgument(), (List)res.getArguments());
        return res;
    }

    private boolean isAddAllCall(OperationCallExp input) {
        EOperation referredOperation = (EOperation)input.getReferredOperation();
        return referredOperation != null && "addAll".equals(referredOperation.getName()) && "oclstdlib_Collection(T)_Class".equals(((EClass)referredOperation.eContainer()).getName());
    }

    private org.eclipse.acceleo.query.ast.Expression convertIntegerDivOpCall(OperationCallExp input) {
        Call res = OperationUtils.createCall(input);
        org.eclipse.acceleo.query.ast.Expression leftOperand = (org.eclipse.acceleo.query.ast.Expression)this.convert((EObject)input.getSource());
        org.eclipse.acceleo.query.ast.Expression rightOperand = (org.eclipse.acceleo.query.ast.Expression)this.convert((EObject)input.getArgument().get(0));
        Call leftToDouble = AstPackage.eINSTANCE.getAstFactory().createCall();
        leftToDouble.setServiceName("toDouble");
        leftToDouble.getArguments().add((Object)leftOperand);
        Call rightToDouble = AstPackage.eINSTANCE.getAstFactory().createCall();
        rightToDouble.setServiceName("toDouble");
        rightToDouble.getArguments().add((Object)rightOperand);
        res.getArguments().add((Object)leftToDouble);
        res.getArguments().add((Object)rightToDouble);
        return res;
    }

    private boolean isIntegerDivOpCall(OperationCallExp input) {
        EOperation referredOperation = (EOperation)input.getReferredOperation();
        return referredOperation != null && ("/".equals(referredOperation.getName()) && referredOperation.eContainer() instanceof EClass && "Integer_Class".equals(((EClass)referredOperation.eContainer()).getName()) || referredOperation.eIsProxy() && ((EOperationImpl)referredOperation).eProxyURI().toString().equals("http://www.eclipse.org/ocl/1.1.0/oclstdlib.ecore#/0/Integer_Class/%2F"));
    }

    private org.eclipse.acceleo.query.ast.Expression convertOclAsSetCall(OperationCallExp input) {
        Call res = AstFactory.eINSTANCE.createCall();
        res.setServiceName("asSet");
        res.setType(CallType.COLLECTIONCALL);
        res.getArguments().add((Object)((org.eclipse.acceleo.query.ast.Expression)this.convert((EObject)input.getSource())));
        return res;
    }

    private boolean isOclAsSetCall(OperationCallExp input) {
        EOperation referredOperation = (EOperation)input.getReferredOperation();
        return referredOperation != null && "oclAsSet".equals(referredOperation.getName()) && referredOperation.eContainer() instanceof EClass && "oclstdlib".equals(((EPackage)referredOperation.eContainer().eContainer()).getName());
    }

    private org.eclipse.acceleo.query.ast.Expression convertInvokeCall(OperationCallExp input) {
        Call res = OperationUtils.createCall(input);
        res.setType(CallType.CALLSERVICE);
        String serviceSignature = ((org.eclipse.ocl.expressions.StringLiteralExp)input.getArgument().get(1)).getStringSymbol();
        String serviceName = serviceSignature.substring(0, serviceSignature.indexOf("("));
        res.setServiceName(serviceName);
        this.map((Collection<? extends EObject>)((CollectionLiteralExp)input.getArgument().get(2)).getPart(), (List)res.getArguments());
        String serviceClassName = ((org.eclipse.ocl.expressions.StringLiteralExp)input.getArgument().get(0)).getStringSymbol();
        if (res.getArguments().isEmpty()) {
            res.setServiceName(String.valueOf(serviceName) + JAVA_SERVICE);
            String varName = ((Variable)((Query)input.eContainer()).getParameter().get(0)).getName();
            VarRef varRef = AstFactory.eINSTANCE.createVarRef();
            varRef.setVariableName(varName);
            res.getArguments().add((Object)varRef);
            try {
                this.refactorService(serviceClassName, serviceName);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        } else {
            this.javaServiceCalls.put(res, serviceClassName);
        }
        return res;
    }

    private void refactorService(String serviceClassName, String serviceName) throws IOException {
        ASTParser parser = ASTParser.newParser((int)10);
        File javaFile = new File(this.targetFolderPath + FileSystems.getDefault().getSeparator() + serviceClassName.replace(".", FileSystems.getDefault().getSeparator()) + ".java");
        if (javaFile.exists()) {
            Document document = new Document(new String(Files.readAllBytes(javaFile.toPath())));
            parser.setSource(document.get().toCharArray());
            parser.setKind(8);
            CompilationUnit cu = (CompilationUnit)parser.createAST(null);
            cu.accept((ASTVisitor)new ServiceWithNoParameterMethodRefactorVisitor((IDocument)document, serviceName));
            Files.write(javaFile.toPath(), document.get().getBytes(), StandardOpenOption.CREATE);
        }
    }

    public boolean isInvokeCall(OperationCallExp input) {
        EOperation referredOperation = (EOperation)input.getReferredOperation();
        return referredOperation != null && "invoke".equals(referredOperation.getName()) && referredOperation.eContainer() instanceof EClass && "oclstdlib_OclAny_Class".equals(((EClass)referredOperation.eContainer()).getName());
    }

    private org.eclipse.acceleo.query.ast.Expression caseIteratorExp(IteratorExp input) {
        if ("collect".equals(input.getName()) && (input.getSource().getType() instanceof OrderedSetType || input.getSource().getType() instanceof SetType)) {
            Call asSequence = AstFactory.eINSTANCE.createCall();
            asSequence.setServiceName("asSequence");
            asSequence.setType(CallType.COLLECTIONCALL);
            asSequence.getArguments().add((Object)((org.eclipse.acceleo.query.ast.Expression)this.convert((EObject)input.getSource())));
            return this.convertIterator(input, (org.eclipse.acceleo.query.ast.Expression)asSequence);
        }
        return this.convertIterator(input, (org.eclipse.acceleo.query.ast.Expression)this.convert((EObject)input.getSource()));
    }

    private org.eclipse.acceleo.query.ast.Expression convertIterator(IteratorExp input, org.eclipse.acceleo.query.ast.Expression source) {
        Call output = AstFactory.eINSTANCE.createCall();
        if (input.getSource().getType() instanceof CollectionType) {
            output.setType(CallType.COLLECTIONCALL);
        } else {
            output.setType(CallType.CALLORAPPLY);
        }
        output.setServiceName(input.getName());
        output.getArguments().add((Object)source);
        Lambda lambda = AstFactory.eINSTANCE.createLambda();
        this.map((Collection<? extends EObject>)input.getIterator(), (List)lambda.getParameters());
        lambda.setExpression((org.eclipse.acceleo.query.ast.Expression)this.convert((EObject)input.getBody()));
        output.getArguments().add((Object)lambda);
        return output;
    }

    private org.eclipse.acceleo.query.ast.Expression caseTemplateInvocation(TemplateInvocation input) {
        Call output = AstFactory.eINSTANCE.createCall();
        output.setType(CallType.CALLORAPPLY);
        output.setServiceName(input.getDefinition().getName());
        this.map((Collection<? extends EObject>)input.getArgument(), (List)output.getArguments());
        return output;
    }

    private org.eclipse.acceleo.query.ast.Expression caseQueryInvocation(QueryInvocation input) {
        Call output = AstFactory.eINSTANCE.createCall();
        output.setType(CallType.CALLORAPPLY);
        output.setServiceName(input.getDefinition().getName());
        this.map((Collection<? extends EObject>)input.getArgument(), (List)output.getArguments());
        return output;
    }

    private org.eclipse.acceleo.query.ast.Expression convertCollectionLiteralExp(CollectionLiteralExp input) {
        SequenceInExtensionLiteral output = null;
        EClassifier type = input.getEType();
        switch (type.eClass().getClassifierID()) {
            case 8: {
                output = AstFactory.eINSTANCE.createSequenceInExtensionLiteral();
                this.map((Collection<? extends EObject>)input.getPart(), (List)output.getValues());
                break;
            }
            case 1: {
                output = AstFactory.eINSTANCE.createSequenceInExtensionLiteral();
                this.map((Collection<? extends EObject>)input.getPart(), (List)output.getValues());
                break;
            }
            case 9: {
                output = AstFactory.eINSTANCE.createSetInExtensionLiteral();
                this.map((Collection<? extends EObject>)input.getPart(), (List)((SetInExtensionLiteral)output).getValues());
                break;
            }
            case 6: {
                output = AstFactory.eINSTANCE.createSetInExtensionLiteral();
                this.map((Collection<? extends EObject>)input.getPart(), (List)((SetInExtensionLiteral)output).getValues());
                break;
            }
            default: {
                throw new MigrationException(type);
            }
        }
        return output;
    }

    private static Variable findVariable(EObject context) {
        Variable variable = null;
        EObject validParent = context.eContainer();
        while (validParent != null && !(validParent instanceof Template) && !(validParent instanceof Query)) {
            validParent = validParent.eContainer();
        }
        if (validParent instanceof Template) {
            variable = (Variable)((Template)validParent).getParameter().get(0);
        } else if (validParent instanceof Query) {
            variable = (Variable)((Query)validParent).getParameter().get(0);
        }
        return variable;
    }
}

