/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.query.parser;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.emf.ecore.EObject;

public class Positions<T extends EObject> {
    private final Map<T, Integer> identifierStartPositions = new HashMap<T, Integer>();
    private final Map<T, Integer> identifierStartLines = new HashMap<T, Integer>();
    private final Map<T, Integer> identifierStartColumns = new HashMap<T, Integer>();
    private final Map<T, Integer> identifierEndPositions = new HashMap<T, Integer>();
    private final Map<T, Integer> identifierEndLines = new HashMap<T, Integer>();
    private final Map<T, Integer> identifierEndColumns = new HashMap<T, Integer>();
    private final Map<T, Integer> startPositions = new HashMap<T, Integer>();
    private final Map<T, Integer> startLines = new HashMap<T, Integer>();
    private final Map<T, Integer> startColumns = new HashMap<T, Integer>();
    private final Map<T, Integer> endPositions = new HashMap<T, Integer>();
    private final Map<T, Integer> endLines = new HashMap<T, Integer>();
    private final Map<T, Integer> endColumns = new HashMap<T, Integer>();

    public Integer getIdentifierStartPositions(T node) {
        return this.identifierStartPositions.get(node);
    }

    public Integer getIdentifierStartLines(T node) {
        return this.identifierStartLines.get(node);
    }

    public Integer getIdentifierStartColumns(T node) {
        return this.identifierStartColumns.get(node);
    }

    public Integer getIdentifierEndPositions(T node) {
        return this.identifierEndPositions.get(node);
    }

    public Integer getIdentifierEndLines(T node) {
        return this.identifierEndLines.get(node);
    }

    public Integer getIdentifierEndColumns(T node) {
        return this.identifierEndColumns.get(node);
    }

    public void setIdentifierStartPositions(T node, Integer position) {
        this.identifierStartPositions.put(node, position);
    }

    public void setIdentifierStartLines(T node, Integer line) {
        this.identifierStartLines.put(node, line);
    }

    public void setIdentifierStartColumns(T node, Integer column) {
        this.identifierStartColumns.put(node, column);
    }

    public void setIdentifierEndPositions(T node, Integer position) {
        this.identifierEndPositions.put(node, position);
    }

    public void setIdentifierEndLines(T node, Integer line) {
        this.identifierEndLines.put(node, line);
    }

    public void setIdentifierEndColumns(T node, Integer column) {
        this.identifierEndColumns.put(node, column);
    }

    public Integer getStartPositions(T node) {
        return this.startPositions.get(node);
    }

    public Integer getStartLines(T node) {
        return this.startLines.get(node);
    }

    public Integer getStartColumns(T node) {
        return this.startColumns.get(node);
    }

    public Integer getEndPositions(T node) {
        return this.endPositions.get(node);
    }

    public Integer getEndLines(T node) {
        return this.endLines.get(node);
    }

    public Integer getEndColumns(T node) {
        return this.endColumns.get(node);
    }

    public void setStartPositions(T node, Integer position) {
        this.startPositions.put(node, position);
    }

    public void setStartLines(T node, Integer line) {
        this.startLines.put(node, line);
    }

    public void setStartColumns(T node, Integer column) {
        this.startColumns.put(node, column);
    }

    public void setEndPositions(T node, Integer position) {
        this.endPositions.put(node, position);
    }

    public void setEndLines(T node, Integer line) {
        this.endLines.put(node, line);
    }

    public void setEndColumns(T node, Integer column) {
        this.endColumns.put(node, column);
    }

    public void remove(T node) {
        this.identifierStartPositions.remove(node);
        this.identifierStartLines.remove(node);
        this.identifierStartColumns.remove(node);
        this.identifierEndPositions.remove(node);
        this.identifierEndLines.remove(node);
        this.identifierEndColumns.remove(node);
        this.startPositions.remove(node);
        this.startLines.remove(node);
        this.startColumns.remove(node);
        this.endPositions.remove(node);
        this.endLines.remove(node);
        this.endColumns.remove(node);
    }

    public void addAll(Positions<T> others, int offsetPosition, int offsetLine, int offsetColumn) {
        for (Map.Entry<T, Integer> entry : others.identifierStartPositions.entrySet()) {
            this.identifierStartPositions.put((EObject)entry.getKey(), entry.getValue() + offsetPosition);
        }
        for (Map.Entry<T, Integer> entry : others.identifierStartLines.entrySet()) {
            this.identifierStartLines.put((EObject)entry.getKey(), entry.getValue() + offsetLine);
        }
        for (Map.Entry<T, Integer> entry : others.identifierStartColumns.entrySet()) {
            this.identifierStartColumns.put((EObject)entry.getKey(), entry.getValue() + offsetColumn);
        }
        for (Map.Entry<T, Integer> entry : others.identifierEndPositions.entrySet()) {
            this.identifierEndPositions.put((EObject)entry.getKey(), entry.getValue() + offsetPosition);
        }
        for (Map.Entry<T, Integer> entry : others.identifierEndLines.entrySet()) {
            this.identifierEndLines.put((EObject)entry.getKey(), entry.getValue() + offsetLine);
        }
        for (Map.Entry<T, Integer> entry : others.identifierEndColumns.entrySet()) {
            this.identifierEndColumns.put((EObject)entry.getKey(), entry.getValue() + offsetColumn);
        }
        for (Map.Entry<T, Integer> entry : others.startPositions.entrySet()) {
            this.startPositions.put((EObject)entry.getKey(), entry.getValue() + offsetPosition);
        }
        for (Map.Entry<T, Integer> entry : others.startLines.entrySet()) {
            this.startLines.put((EObject)entry.getKey(), entry.getValue() + offsetLine);
        }
        for (Map.Entry<T, Integer> entry : others.startColumns.entrySet()) {
            this.startColumns.put((EObject)entry.getKey(), entry.getValue() + offsetColumn);
        }
        for (Map.Entry<T, Integer> entry : others.endPositions.entrySet()) {
            this.endPositions.put((EObject)entry.getKey(), entry.getValue() + offsetPosition);
        }
        for (Map.Entry<T, Integer> entry : others.endLines.entrySet()) {
            this.endLines.put((EObject)entry.getKey(), entry.getValue() + offsetLine);
        }
        for (Map.Entry<T, Integer> entry : others.endColumns.entrySet()) {
            this.endColumns.put((EObject)entry.getKey(), entry.getValue() + offsetColumn);
        }
    }

    public boolean isInRange(T node, int position) {
        return this.isInRange(node, position, -1, -1);
    }

    public boolean isInRange(T node, int line, int column) {
        return this.isInRange(node, -1, line, column);
    }

    public T getNodeAt(T node, int position) {
        return this.getNodeAt(node, position, -1, -1);
    }

    public T getNodeAt(T node, int line, int column) {
        return this.getNodeAt(node, -1, line, column);
    }

    protected T getNodeAt(T node, int position, int line, int column) {
        EObject res = null;
        if (!this.isInRange(node, position, line, column)) {
            throw new IllegalArgumentException("the root node can't contain the given position.");
        }
        for (EObject child : node.eContents()) {
            if (this.getStartPositions(child) == null || this.getEndPositions(child) == null || !this.isInRange(child, position, line, column)) continue;
            res = this.getNodeAt(child, position, line, column);
            break;
        }
        if (res == null) {
            res = (EObject)node;
        }
        return (T)res;
    }

    protected boolean isInRange(T node, int position, int line, int column) {
        return this.compareStart(node, position, line, column) <= 0 && this.compareEnd(node, position, line, column) >= 0;
    }

    protected int compareStart(T node, int position, int line, int column) {
        int res;
        if (position != -1) {
            res = this.getStartPositions(node) - position;
        } else if (line != -1) {
            int lineDelta = this.getStartLines(node) - line;
            res = lineDelta == 0 ? (column != -1 ? this.getStartColumns(node) - column : lineDelta) : lineDelta;
        } else {
            throw new IllegalArgumentException("at least one of position or line must be different from -1.");
        }
        return res;
    }

    protected int compareEnd(T node, int position, int line, int column) {
        int res;
        if (position != -1) {
            res = this.getEndPositions(node) - position;
        } else if (line != -1) {
            int lineDelta = this.getEndLines(node) - line;
            res = lineDelta == 0 ? (column != -1 ? this.getEndColumns(node) - column : lineDelta) : lineDelta;
        } else {
            throw new IllegalArgumentException("at least one of position or line must be different from -1.");
        }
        return res;
    }
}

