/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.aql.ide.ui.module.main;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.eclipse.acceleo.Module;
import org.eclipse.acceleo.Template;
import org.eclipse.acceleo.aql.AcceleoUtil;
import org.eclipse.acceleo.aql.evaluation.AcceleoEvaluator;
import org.eclipse.acceleo.aql.evaluation.GenerationResult;
import org.eclipse.acceleo.aql.evaluation.strategy.DefaultGenerationStrategy;
import org.eclipse.acceleo.aql.evaluation.strategy.IAcceleoGenerationStrategy;
import org.eclipse.acceleo.aql.evaluation.strategy.IWriterFactory;
import org.eclipse.acceleo.aql.ide.ui.AcceleoUIPlugin;
import org.eclipse.acceleo.aql.ide.ui.evaluation.strategy.AcceleoUIWorkspaceWriterFactory;
import org.eclipse.acceleo.aql.ide.ui.module.main.AbstractGenerator;
import org.eclipse.acceleo.aql.ide.ui.module.services.Services;
import org.eclipse.acceleo.aql.ide.ui.wizard.GenerationPomConfiguration;
import org.eclipse.acceleo.aql.parser.AcceleoParser;
import org.eclipse.acceleo.aql.parser.ModuleLoader;
import org.eclipse.acceleo.query.AQLUtils;
import org.eclipse.acceleo.query.ast.ASTNode;
import org.eclipse.acceleo.query.ide.QueryPlugin;
import org.eclipse.acceleo.query.runtime.IQueryEnvironment;
import org.eclipse.acceleo.query.runtime.IReadOnlyQueryEnvironment;
import org.eclipse.acceleo.query.runtime.impl.namespace.ClassLoaderQualifiedNameResolver;
import org.eclipse.acceleo.query.runtime.impl.namespace.JavaLoader;
import org.eclipse.acceleo.query.runtime.namespace.ILoader;
import org.eclipse.acceleo.query.runtime.namespace.IQualifiedNameQueryEnvironment;
import org.eclipse.acceleo.query.runtime.namespace.IQualifiedNameResolver;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.Monitor;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class MavenGenerationPomGenerator
extends AbstractGenerator {
    private final IFile moduleFile;
    protected String modelModuleQualifiedName;
    protected Module modelModule;
    protected String generatePomFilePath;
    protected final URI pomFoldertargetURI;
    private String generatorGroupId;
    private String generatorArtifactId;
    private String generatorVersion;
    private String generationGroupId;
    private String generationArtifactId;
    private String generationVersion;
    private String modelPath;
    private String targetFolderPath;

    public MavenGenerationPomGenerator(IFile moduleFile, GenerationPomConfiguration configuration) {
        this.moduleFile = moduleFile;
        this.generatePomFilePath = new File(configuration.getPomFolder()).getAbsolutePath() + File.separator + "pom.xml";
        this.pomFoldertargetURI = configuration.getPomFolderURI();
        this.generatePomFilePath = URI.createURI((String)"pom.xml").resolve(this.pomFoldertargetURI).path();
        this.generatorGroupId = configuration.getGeneratorGroupId();
        this.generatorArtifactId = configuration.getGeneratorArtifactId();
        this.generatorVersion = configuration.getGeneratorVersion();
        this.generationGroupId = configuration.getGenerationGroupId();
        this.generationArtifactId = configuration.getGenerationArtifactId();
        this.generationVersion = configuration.getGenerationVersion();
        this.modelPath = configuration.getGenerationModelPathURI().deresolve(this.pomFoldertargetURI).toString();
        this.targetFolderPath = configuration.getGenerationTargetPathURI().deresolve(this.pomFoldertargetURI).toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void generate(Monitor monitor) {
        String moduleQualifiedName = this.getModuleQualifiedName();
        Map<String, String> options = this.getOptions();
        ArrayList exceptions = new ArrayList();
        ResourceSetImpl resourceSetForModels = new ResourceSetImpl();
        IQualifiedNameResolver resolver = this.createResolver();
        IQualifiedNameQueryEnvironment queryEnvironment = this.createAcceleoQueryEnvironment(options, resolver, (ResourceSet)resourceSetForModels);
        AcceleoEvaluator evaluator = this.createAcceleoEvaluator(resolver, queryEnvironment);
        IAcceleoGenerationStrategy strategy = this.createGenerationStrategy((ResourceSet)resourceSetForModels);
        Module module = (Module)resolver.resolve(moduleQualifiedName);
        Set nsURIs = AQLUtils.getAllNeededEPackages((IQualifiedNameResolver)resolver, (String)moduleQualifiedName);
        AQLUtils.registerEPackages((IQueryEnvironment)queryEnvironment, (EPackage.Registry)EPackage.Registry.INSTANCE, (Set)nsURIs);
        URI logURI = AcceleoUtil.getlogURI((URI)this.pomFoldertargetURI, (String)options.get("logURI"));
        IQualifiedNameResolver workspaceResolver = QueryPlugin.getPlugin().createQualifiedNameResolver(this.getClass().getClassLoader(), EPackage.Registry.INSTANCE, this.moduleFile.getProject(), "::", true);
        workspaceResolver.addLoader((ILoader)new ModuleLoader(new AcceleoParser(), null));
        this.modelModuleQualifiedName = this.getQualifiedNameFromSourceFile(this.moduleFile);
        String moduleAbsolutePath = this.moduleFile.getLocation().toFile().getAbsolutePath();
        this.modelModule = this.loadModelModule(URI.createFileURI((String)moduleAbsolutePath), this.modelModuleQualifiedName);
        MavenGenerationPomGenerator mavenGenerationPomGenerator = this;
        synchronized (mavenGenerationPomGenerator) {
            this.beforeGeneration(queryEnvironment, workspaceResolver);
            try {
                List mainTemplates = AcceleoUtil.getMainTemplates((Module)module);
                Template main = (Template)mainTemplates.get(0);
                HashMap<String, Object> variables = new HashMap<String, Object>();
                variables.put("module", this.modelModule);
                variables.put("generatorGroupId", this.generatorGroupId);
                variables.put("generatorArtifactId", this.generatorArtifactId);
                variables.put("generatorVersion", this.generatorVersion);
                variables.put("generationGroupId", this.generationGroupId);
                variables.put("generationArtifactId", this.generationArtifactId);
                variables.put("generationVersion", this.generationVersion);
                variables.put("modelPath", this.modelPath);
                variables.put("targetFolderPath", this.targetFolderPath);
                AcceleoUtil.generate((Template)main, variables, (AcceleoEvaluator)evaluator, (IQualifiedNameQueryEnvironment)queryEnvironment, (IAcceleoGenerationStrategy)strategy, (URI)this.pomFoldertargetURI, (URI)logURI, (Monitor)monitor);
            }
            finally {
                AcceleoUtil.cleanServices((IReadOnlyQueryEnvironment)queryEnvironment, (ResourceSet)resourceSetForModels);
                this.printDiagnostics(evaluator.getGenerationResult());
                this.afterGeneration(evaluator.getGenerationResult());
            }
        }
    }

    protected String getModuleQualifiedName() {
        return "org::eclipse::acceleo::aql::ide::ui::module::main::mavenGenerationPom";
    }

    protected String getGeneratorClassName() {
        String res = this.modelModuleQualifiedName.replace("::", ".") + "Generator";
        int lastQualifierSeparatorIndex = res.lastIndexOf(".");
        res = lastQualifierSeparatorIndex < 0 ? Character.toUpperCase(res.charAt(0)) + res.substring(1, res.length()) : res.substring(0, lastQualifierSeparatorIndex + 1) + Character.toUpperCase(res.charAt(lastQualifierSeparatorIndex + 1)) + res.substring(lastQualifierSeparatorIndex + 2, res.length());
        return res;
    }

    protected Map<String, String> getOptions() {
        LinkedHashMap<String, String> res = new LinkedHashMap<String, String>();
        res.put("logURI", "acceleo.log");
        res.put("newLine", System.lineSeparator());
        return res;
    }

    protected IQualifiedNameResolver createResolver() {
        ClassLoaderQualifiedNameResolver resolver = new ClassLoaderQualifiedNameResolver(this.getClass().getClassLoader(), EPackage.Registry.INSTANCE, "::");
        return resolver;
    }

    protected IQualifiedNameQueryEnvironment createAcceleoQueryEnvironment(Map<String, String> options, IQualifiedNameResolver resolver, ResourceSet resourceSetForModels) {
        IQualifiedNameQueryEnvironment queryEnvironment = AcceleoUtil.newAcceleoQueryEnvironment(options, (IQualifiedNameResolver)resolver, (ResourceSet)resourceSetForModels, (boolean)false);
        return queryEnvironment;
    }

    protected AcceleoEvaluator createAcceleoEvaluator(IQualifiedNameResolver resolver, IQualifiedNameQueryEnvironment queryEnvironment) {
        AcceleoEvaluator evaluator = new AcceleoEvaluator(queryEnvironment.getLookupEngine(), System.lineSeparator());
        resolver.addLoader((ILoader)new ModuleLoader(new AcceleoParser(), evaluator));
        resolver.addLoader((ILoader)new JavaLoader("::", false));
        return evaluator;
    }

    protected IAcceleoGenerationStrategy createGenerationStrategy(ResourceSet resourceSetForModels) {
        DefaultGenerationStrategy strategy = new DefaultGenerationStrategy(resourceSetForModels.getURIConverter(), this.getWriterFactory());
        return strategy;
    }

    protected void beforeGeneration(IQualifiedNameQueryEnvironment queryEnvironment, IQualifiedNameResolver workspaceResolver) {
        Services.initialize(queryEnvironment, workspaceResolver);
    }

    protected void printDiagnostics(GenerationResult generationResult) {
        if (generationResult.getDiagnostic().getSeverity() > 1) {
            this.printDiagnostic(generationResult.getDiagnostic());
        }
        this.printSummary(generationResult);
    }

    protected void printDiagnostic(Diagnostic diagnostic) {
        if (diagnostic.getMessage() != null) {
            Object location = !diagnostic.getData().isEmpty() && diagnostic.getData().get(0) instanceof ASTNode ? AcceleoUtil.getLocation((ASTNode)((ASTNode)diagnostic.getData().get(0))) + ": " : "";
            switch (diagnostic.getSeverity()) {
                case 1: {
                    AcceleoUIPlugin.getDefault().getLog().log((IStatus)new Status(1, diagnostic.getSource(), (String)location + diagnostic.getMessage(), diagnostic.getException()));
                    break;
                }
                case 2: {
                    AcceleoUIPlugin.getDefault().getLog().log((IStatus)new Status(2, diagnostic.getSource(), (String)location + diagnostic.getMessage(), diagnostic.getException()));
                    break;
                }
                case 4: {
                    AcceleoUIPlugin.getDefault().getLog().log((IStatus)new Status(4, diagnostic.getSource(), (String)location + diagnostic.getMessage(), diagnostic.getException()));
                }
            }
        }
        for (Diagnostic child : diagnostic.getChildren()) {
            this.printDiagnostic(child);
        }
    }

    protected void printSummary(GenerationResult result) {
        int nbErrors = 0;
        int nbWarnings = 0;
        int nbInfos = 0;
        for (Diagnostic diagnostic : result.getDiagnostic().getChildren()) {
            switch (diagnostic.getSeverity()) {
                case 4: {
                    ++nbErrors;
                    break;
                }
                case 2: {
                    ++nbWarnings;
                    break;
                }
                case 1: {
                    ++nbInfos;
                    break;
                }
            }
        }
        String message = "Files: " + result.getGeneratedFiles().size() + ", Lost Files: " + result.getLostFiles().size() + ", Errors: " + nbErrors + ", Warnings: " + nbWarnings + ", Infos: " + nbInfos + ".";
        AcceleoUIPlugin.getDefault().getLog().log((IStatus)new Status(1, this.getClass(), message));
    }

    protected void afterGeneration(GenerationResult generationResult) {
        Services.initialize(null, null);
        try {
            this.moduleFile.getParent().refreshLocal(1, (IProgressMonitor)new NullProgressMonitor());
            if (this.isInMavenProject((IResource)this.moduleFile)) {
                this.updateMavenPom(this.generatePomFilePath);
            }
        }
        catch (CoreException e) {
            AcceleoUIPlugin.getDefault().getLog().log((IStatus)new Status(4, this.getClass(), "could not refresh " + String.valueOf(this.moduleFile.getParent().getFullPath()), (Throwable)e));
        }
    }

    private void updateMavenPom(String pomPath) {
        File pomFile = new File(pomPath);
        if (pomFile.exists() && pomFile.canRead()) {
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            try {
                Throwable throwable = null;
                Object var5_7 = null;
                try (FileInputStream input = new FileInputStream(pomFile);){
                    Node pomProject;
                    DocumentBuilder db = dbf.newDocumentBuilder();
                    Document pom = db.parse(input);
                    NodeList projectList = pom.getElementsByTagName("project");
                    if (projectList.getLength() > 0 && (pomProject = projectList.item(0)) instanceof Element) {
                        ArrayList<AbstractGenerator.MavenDependency> dependencies = new ArrayList<AbstractGenerator.MavenDependency>();
                        dependencies.add(new AbstractGenerator.MavenDependency(this.generatorGroupId, this.generatorArtifactId, this.generatorVersion));
                        boolean repositoriesUpdated = this.updateRepositories(pom, (Element)pomProject);
                        boolean dependenciesUpdated = this.addMavenDependencies(pom, (Element)pomProject, dependencies);
                        boolean execUpdated = this.updateExec(pom, (Element)pomProject);
                        if (repositoriesUpdated || dependenciesUpdated || execUpdated) {
                            try {
                                Transformer tr = TransformerFactory.newInstance().newTransformer();
                                ByteArrayOutputStream ouputStream = new ByteArrayOutputStream();
                                tr.transform(new DOMSource(pom), new StreamResult(ouputStream));
                                this.getPreview().put(URI.createFileURI((String)pomPath), new String(ouputStream.toByteArray()).toString());
                            }
                            catch (TransformerException te) {
                                AcceleoUIPlugin.getDefault().getLog().log((IStatus)new Status(4, this.getClass(), "can't write " + this.generatePomFilePath, (Throwable)te));
                            }
                        }
                    }
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (IOException | ParserConfigurationException | SAXException e) {
                AcceleoUIPlugin.getDefault().getLog().log((IStatus)new Status(4, this.getClass(), "can't load pom.xml file for " + String.valueOf(this.moduleFile.getParent().getFullPath()), (Throwable)e));
            }
        }
    }

    @Override
    protected IWriterFactory createWriterFactory() {
        Object res = new File(this.generatePomFilePath).exists() ? super.createWriterFactory() : new AcceleoUIWorkspaceWriterFactory();
        return res;
    }

    private boolean updateExec(Document pom, Element project) {
        boolean pluginsCreated;
        boolean needPluginNode;
        Element plugins;
        boolean buildCreated;
        Element build;
        NodeList buildList = project.getElementsByTagName("build");
        if (buildList.getLength() > 0 && buildList.item(0) instanceof Element) {
            build = (Element)buildList.item(0);
            buildCreated = false;
        } else {
            build = pom.createElement("build");
            project.appendChild(pom.createTextNode(System.lineSeparator() + System.lineSeparator() + "    "));
            build.appendChild(pom.createTextNode(System.lineSeparator() + "    "));
            project.appendChild(build);
            project.appendChild(pom.createTextNode(System.lineSeparator()));
            buildCreated = true;
        }
        NodeList pluginsList = build.getElementsByTagName("plugins");
        if (pluginsList.getLength() > 0 && pluginsList.item(0) instanceof Element) {
            plugins = (Element)pluginsList.item(0);
            boolean needNewPlugin = true;
            int i = 0;
            block0: while (i < pluginsList.getLength()) {
                if (pluginsList.item(i) instanceof Element) {
                    Element currentResources = (Element)pluginsList.item(i);
                    NodeList mainClassList = currentResources.getElementsByTagName("mainClass");
                    int j = 0;
                    while (j < mainClassList.getLength()) {
                        Element mainClass;
                        if (mainClassList.item(j) instanceof Element && (mainClass = (Element)mainClassList.item(j)).getTextContent().equals(this.getGeneratorClassName()) && this.sameParameters(mainClass)) {
                            needNewPlugin = false;
                            break block0;
                        }
                        ++j;
                    }
                }
                ++i;
            }
            needPluginNode = needNewPlugin;
            pluginsCreated = false;
        } else {
            plugins = pom.createElement("plugins");
            build.appendChild(pom.createTextNode("    "));
            build.appendChild(plugins);
            build.appendChild(pom.createTextNode(System.lineSeparator() + "    "));
            pluginsCreated = true;
            needPluginNode = true;
        }
        if (needPluginNode) {
            Element plugin = pom.createElement("plugin");
            plugins.appendChild(pom.createTextNode(System.lineSeparator() + "            "));
            plugins.appendChild(plugin);
            plugins.appendChild(pom.createTextNode(System.lineSeparator() + "        "));
            Element groupId = pom.createElement("groupId");
            plugin.appendChild(pom.createTextNode(System.lineSeparator() + "                "));
            groupId.setTextContent("org.codehaus.mojo");
            plugin.appendChild(groupId);
            Element artifactId = pom.createElement("artifactId");
            plugin.appendChild(pom.createTextNode(System.lineSeparator() + "                "));
            artifactId.setTextContent("exec-maven-plugin");
            plugin.appendChild(artifactId);
            Element version = pom.createElement("version");
            plugin.appendChild(pom.createTextNode(System.lineSeparator() + "                "));
            version.setTextContent("3.5.0");
            plugin.appendChild(version);
            Element executions = pom.createElement("executions");
            plugin.appendChild(pom.createTextNode(System.lineSeparator() + "                "));
            plugin.appendChild(executions);
            Element execution = pom.createElement("execution");
            executions.appendChild(pom.createTextNode(System.lineSeparator() + "                    "));
            executions.appendChild(execution);
            executions.appendChild(pom.createTextNode(System.lineSeparator() + "                "));
            Element goals = pom.createElement("goals");
            execution.appendChild(pom.createTextNode(System.lineSeparator() + "                        "));
            execution.appendChild(goals);
            execution.appendChild(pom.createTextNode(System.lineSeparator() + "                    "));
            Element goal = pom.createElement("goal");
            goal.setTextContent("java");
            goals.appendChild(pom.createTextNode(System.lineSeparator() + "                            "));
            goals.appendChild(goal);
            goals.appendChild(pom.createTextNode(System.lineSeparator() + "                        "));
            Element configuration = pom.createElement("configuration");
            plugin.appendChild(pom.createTextNode(System.lineSeparator() + "                "));
            plugin.appendChild(configuration);
            plugin.appendChild(pom.createTextNode(System.lineSeparator() + "            "));
            Element mainClass = pom.createElement("mainClass");
            mainClass.setTextContent(this.getGeneratorClassName());
            configuration.appendChild(pom.createTextNode(System.lineSeparator() + "                    "));
            configuration.appendChild(mainClass);
            Element arguments = pom.createElement("arguments");
            configuration.appendChild(pom.createTextNode(System.lineSeparator() + "                    "));
            configuration.appendChild(arguments);
            configuration.appendChild(pom.createTextNode(System.lineSeparator() + "                "));
            Element modelPathArgument = pom.createElement("argument");
            modelPathArgument.setTextContent(this.modelPath);
            arguments.appendChild(pom.createTextNode(System.lineSeparator() + "                        "));
            arguments.appendChild(modelPathArgument);
            Element targetPathArgument = pom.createElement("argument");
            targetPathArgument.setTextContent(this.targetFolderPath);
            arguments.appendChild(pom.createTextNode(System.lineSeparator() + "                        "));
            arguments.appendChild(targetPathArgument);
            arguments.appendChild(pom.createTextNode(System.lineSeparator() + "                    "));
        }
        return buildCreated || pluginsCreated || needPluginNode;
    }

    private boolean sameParameters(Element mainClass) {
        boolean res;
        Node parent = mainClass.getParentNode();
        if (parent instanceof Element) {
            ArrayList<String> arguments = new ArrayList<String>();
            Element configuration = (Element)parent;
            NodeList argumentList = configuration.getElementsByTagName("argument");
            int j = 0;
            while (j < argumentList.getLength()) {
                if (argumentList.item(j) instanceof Element) {
                    Element argument = (Element)argumentList.item(j);
                    arguments.add(argument.getTextContent().trim());
                }
                ++j;
            }
            res = arguments.containsAll(Arrays.asList(this.modelPath, this.targetFolderPath));
        } else {
            res = false;
        }
        return res;
    }

    private boolean updateRepositories(Document pom, Element project) {
        boolean repositoriesCreated;
        boolean needRepositoriesNode;
        Element repositories;
        NodeList repositoriesList = project.getElementsByTagName("repositories");
        if (repositoriesList.getLength() > 0 && repositoriesList.item(0) instanceof Element) {
            repositories = (Element)repositoriesList.item(0);
            boolean needNewRepositories = true;
            int i = 0;
            block0: while (i < repositoriesList.getLength()) {
                if (repositoriesList.item(i) instanceof Element) {
                    Element currentResources = (Element)repositoriesList.item(i);
                    NodeList urlList = currentResources.getElementsByTagName("url");
                    int j = 0;
                    while (j < urlList.getLength()) {
                        Element url;
                        if (urlList.item(j) instanceof Element && (url = (Element)urlList.item(j)).getTextContent().startsWith("https://download.eclipse.org/acceleo/updates/")) {
                            needNewRepositories = false;
                            break block0;
                        }
                        ++j;
                    }
                }
                ++i;
            }
            needRepositoriesNode = needNewRepositories;
            repositoriesCreated = false;
        } else {
            repositories = pom.createElement("repositories");
            project.appendChild(pom.createTextNode("    "));
            project.appendChild(repositories);
            project.appendChild(pom.createTextNode(System.lineSeparator()));
            repositoriesCreated = true;
            needRepositoriesNode = true;
        }
        if (needRepositoriesNode) {
            Element repository = pom.createElement("repository");
            repositories.appendChild(pom.createTextNode(System.lineSeparator() + "        "));
            repositories.appendChild(repository);
            repositories.appendChild(pom.createTextNode(System.lineSeparator() + "    "));
            Element id = pom.createElement("id");
            repository.appendChild(pom.createTextNode(System.lineSeparator() + "            "));
            id.setTextContent("acceleo-repository");
            repository.appendChild(id);
            Element name = pom.createElement("name");
            repository.appendChild(pom.createTextNode(System.lineSeparator() + "            "));
            name.setTextContent("Acceleo Repository");
            repository.appendChild(name);
            Element url = pom.createElement("url");
            repository.appendChild(pom.createTextNode(System.lineSeparator() + "            "));
            url.setTextContent("https://download.eclipse.org/acceleo/updates/releases/4.1/R202502130921/");
            repository.appendChild(url);
            repository.appendChild(pom.createTextNode(System.lineSeparator() + "        "));
        }
        return repositoriesCreated || needRepositoriesNode;
    }
}

