/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.amp.amf.acore.edit.commands.test;

import org.eclipse.amp.amf.acore.edit.commands.test.CommandTest;
import org.eclipse.amp.amf.acore.edit.commands.test.SetLabel;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.edit.command.SetCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.metaabm.IID;
import org.metaabm.MetaABMPackage;
import org.metaabm.SAgent;
import org.metaabm.SAttribute;
import org.metaabm.SImplementation;
import org.metaabm.SImplementationMode;
import org.metaabm.act.AAct;
import org.metaabm.act.ABuild;
import org.metaabm.act.ACreateAgents;
import org.metaabm.act.AGroup;

public class RenameAgentCommand
extends SetLabel {
    public RenameAgentCommand() {
        super("Root Context Agent", "Test Agent");
    }

    public IID getIID() {
        return (IID)this.model.getAgents().get(0);
    }

    public Command getCommand() {
        SAgent newAgent = (SAgent)this.getIID();
        return SetCommand.create((EditingDomain)this.getDomain(), (Object)newAgent, (Object)MetaABMPackage.Literals.IID__LABEL, (Object)"Test Agent");
    }

    public void preCondition() {
        super.preCondition();
        SAgent newAgent = this.model.findAgent("testAgent");
        CommandTest.assertNull((Object)newAgent);
        SAgent oldAgent = this.model.findAgent("rootContextAgent");
        CommandTest.assertNotNull((Object)oldAgent);
        CommandTest.assertEquals((String)oldAgent.getLabel(), (String)"Root Context Agent");
    }

    public void postCondition() {
        super.postCondition();
        SAgent newAgent = this.model.findAgent("testAgent");
        CommandTest.assertNotNull((Object)newAgent);
        SAgent oldAgent = this.model.findAgent("rootContextAgent");
        CommandTest.assertNull((Object)oldAgent);
        CommandTest.assertEquals((String)newAgent.getLabel(), (String)"Test Agent");
        CommandTest.assertEquals((String)newAgent.getID(), (String)"testAgent");
        CommandTest.assertEquals((String)newAgent.getPluralLabel(), (String)"Test Agents");
        SImplementation impl = newAgent.getImplementation();
        CommandTest.assertEquals((String)impl.getClassName(), (String)"TestAgent");
        if (impl.getMode() == SImplementationMode.LOAD_LITERAL) {
            AGroup root = (AGroup)this.model.getRootActivity();
            AAct builder = (AAct)((AGroup)this.model.getRootActivity()).getMembers().get(0);
            CommandTest.assertEquals((String)builder.getLabel(), (String)"Build Root Context");
            EList targets = builder.getTargets();
            CommandTest.assertEquals((String)((AAct)targets.get(0)).getLabel(), (String)"Create Test Agent");
            AAct build = (AAct)root.getMembers().get(0);
            CommandTest.assertTrue((boolean)(build instanceof ABuild));
            CommandTest.assertSame((Object)build.getGroup(), (Object)root);
            AAct create = (AAct)build.getTargets().get(0);
            CommandTest.assertTrue((boolean)(create instanceof ACreateAgents));
            CommandTest.assertSame((Object)create.getGroup(), (Object)root);
            CommandTest.assertTrue((boolean)root.getMembers().contains((Object)create));
            CommandTest.assertSame((Object)build.getTargets().get(0), (Object)create);
            SAttribute countAttr = (SAttribute)((ACreateAgents)create).getAgentCount();
            CommandTest.assertTrue((boolean)this.model.getAttributes().contains((Object)countAttr));
            CommandTest.assertEquals((String)countAttr.getLabel(), (String)"Test Agent Count");
            CommandTest.assertEquals((String)countAttr.getDescription(), (String)"The number of test agent instances to create.");
        }
    }
}

