/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.draw3d.graphics3d.lwjgl.offscreen;

import java.util.Arrays;
import org.eclipse.draw3d.graphics3d.Graphics3D;
import org.eclipse.draw3d.graphics3d.Graphics3DOffscreenBufferConfig;
import org.eclipse.draw3d.util.ImageConverter;

public class LwjglOffscreenBufferConfig
implements Graphics3DOffscreenBufferConfig {
    private static final int SUPPORTED_BUFFERS = 16640;
    private final int m_buffers;
    private int m_colorBpp;
    private int m_colorDataType;
    private int m_colorPixelFormat;
    private int m_depthDataType;
    private Graphics3D graphics3D;

    public LwjglOffscreenBufferConfig(Graphics3D graphics3D, int i_buffers, int ... i_args) {
        this.graphics3D = graphics3D;
        if ((i_buffers & 0xFFFFBEFF) != 0) {
            throw new IllegalArgumentException("unsupported buffers: " + i_buffers);
        }
        boolean colorBuffer = (i_buffers & 0x4000) != 0;
        boolean depthBuffer = (i_buffers & 0x100) != 0;
        int index = 0;
        if (colorBuffer) {
            this.m_colorPixelFormat = this.getArg(index++, i_args);
            this.m_colorDataType = this.getArg(index++, i_args);
            this.m_colorBpp = ImageConverter.getColorBpp((int)this.m_colorPixelFormat, (int)this.m_colorDataType);
        }
        if (depthBuffer) {
            this.m_depthDataType = this.getArg(index++, i_args);
        }
        this.m_buffers = i_buffers;
    }

    public Graphics3D getGraphics3D() {
        return this.graphics3D;
    }

    private int getArg(int i_index, int[] i_args) {
        if (i_index > i_args.length - 1) {
            throw new IllegalArgumentException("invalid number of arguments: " + Arrays.toString(i_args));
        }
        return i_args[i_index];
    }

    public int getColorBpp() {
        if (!this.isEnabled(16384)) {
            throw new IllegalStateException("color buffer is disabled");
        }
        return this.m_colorBpp;
    }

    public int getColorDataType() {
        if (!this.isEnabled(16384)) {
            throw new IllegalStateException("color buffer is disabled");
        }
        return this.m_colorDataType;
    }

    public int getColorPixelFormat() {
        if (!this.isEnabled(16384)) {
            throw new IllegalStateException("color buffer is disabled");
        }
        return this.m_colorPixelFormat;
    }

    public int getDepthDataType() {
        if (!this.isEnabled(256)) {
            throw new IllegalStateException("depth buffer is disabled");
        }
        return this.m_depthDataType;
    }

    public boolean isEnabled(int i_buffer) {
        return (this.m_buffers & i_buffer) != 0;
    }
}

