/*******************************************************************************
 * Copyright (c) 2009 Jens von Pilgrim and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Kristian Duske - initial API and implementation
 ******************************************************************************/
package org.eclipse.draw3d.graphics.optimizer.primitive;

import org.eclipse.draw3d.geometry.IMatrix3f;
import org.eclipse.draw3d.graphics.optimizer.PrimitiveBounds;
import org.eclipse.draw3d.graphics.optimizer.RecordingGraphics;

/**
 * A graphical 2D primitive that is generated by a graphics
 * {@link RecordingGraphics optimizier}.
 * 
 * @author Kristian Duske
 * @version $Revision$
 * @since 22.12.2009
 */
public interface Primitive {

	/**
	 * The bounds rectangle of this primitive (after the transformation has been
	 * applied).
	 * 
	 * @return the bounds rectangle
	 */
	public PrimitiveBounds getBounds();

	/**
	 * The rendering rule that is to be applied to this primitive.
	 * 
	 * @return the rendering rule
	 */
	public RenderRule getRenderRule();

	/**
	 * The transformation that should be applied to this primitive.
	 * 
	 * @return the transformation
	 */
	public IMatrix3f getTransformation();

	/**
	 * Indicates whether this and the given primitive intersect.
	 * 
	 * @param i_primitive the primitive to check
	 * @return <code>true</code> if this primitive intersects with the given
	 *         primitive and <code>false</code> otherwise
	 */
	public boolean intersects(Primitive i_primitive);
}
