/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.draw3d.graphics.optimizer.primitive;

import org.eclipse.draw3d.geometry.IMatrix3f;
import org.eclipse.draw3d.geometry.Matrix3fImpl;
import org.eclipse.draw3d.graphics.optimizer.PrimitiveBounds;
import org.eclipse.draw3d.graphics.optimizer.primitive.Primitive;
import org.eclipse.draw3d.graphics.optimizer.primitive.RenderRule;

public abstract class AbstractPrimitive
implements Primitive {
    private PrimitiveBounds m_bounds;
    private RenderRule m_renderRule;
    private IMatrix3f m_transformation;

    protected AbstractPrimitive(IMatrix3f i_transformation, RenderRule i_renderRule) {
        if (i_renderRule == null) {
            throw new NullPointerException("i_renderRule must not be null");
        }
        if (i_transformation != null) {
            this.m_transformation = new Matrix3fImpl(i_transformation);
        }
        this.m_renderRule = i_renderRule;
    }

    protected abstract PrimitiveBounds calculateBounds();

    public PrimitiveBounds getBounds() {
        if (this.m_bounds == null) {
            this.m_bounds = this.calculateBounds();
        }
        return this.m_bounds;
    }

    public RenderRule getRenderRule() {
        return this.m_renderRule;
    }

    public IMatrix3f getTransformation() {
        return this.m_transformation;
    }

    public boolean intersects(Primitive i_primitive) {
        PrimitiveBounds bounds = i_primitive.getBounds();
        if (this.getBounds().intersects(bounds)) {
            return true;
        }
        if (this.getBounds().contains(bounds)) {
            return true;
        }
        return bounds.contains(this.getBounds());
    }
}

