/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.amp.agf.chart;

import java.util.List;
import org.eclipse.amp.agf.chart.BasicChartStrategy;
import org.eclipse.amp.agf.chart.IDataProvider;
import org.eclipse.birt.chart.model.Chart;
import org.eclipse.birt.chart.model.ChartWithAxes;
import org.eclipse.birt.chart.model.attribute.AxisType;
import org.eclipse.birt.chart.model.attribute.IntersectionType;
import org.eclipse.birt.chart.model.attribute.LegendItemType;
import org.eclipse.birt.chart.model.attribute.TickStyle;
import org.eclipse.birt.chart.model.attribute.impl.PaletteImpl;
import org.eclipse.birt.chart.model.component.Axis;
import org.eclipse.birt.chart.model.component.Series;
import org.eclipse.birt.chart.model.component.impl.SeriesImpl;
import org.eclipse.birt.chart.model.data.DataSet;
import org.eclipse.birt.chart.model.data.NumberDataSet;
import org.eclipse.birt.chart.model.data.SeriesDefinition;
import org.eclipse.birt.chart.model.data.TextDataSet;
import org.eclipse.birt.chart.model.data.impl.NumberDataSetImpl;
import org.eclipse.birt.chart.model.data.impl.SeriesDefinitionImpl;
import org.eclipse.birt.chart.model.data.impl.TextDataSetImpl;
import org.eclipse.birt.chart.model.impl.ChartWithAxesImpl;

public abstract class BasicAxesChartStrategy
extends BasicChartStrategy {
    private static final float AXIS_FONT_SIZE = 9.0f;

    @Override
    public void update() {
    }

    @Override
    public Chart createChart(IDataProvider newDataProvider, Object newDataSource) {
        this.dataProvider = newDataProvider;
        this.dataSource = newDataSource;
        ChartWithAxes chart = ChartWithAxesImpl.create();
        this.setChart((Chart)chart);
        chart.setUnitSpacing(20.0);
        Axis xAxisPrimary = this.getXAxisPrimary();
        xAxisPrimary.setType(AxisType.TEXT_LITERAL);
        xAxisPrimary.getTitle().getCaption().setValue("Period");
        xAxisPrimary.getTitle().setVisible(true);
        xAxisPrimary.getMajorGrid().setTickStyle(TickStyle.BELOW_LITERAL);
        xAxisPrimary.getOrigin().setType(IntersectionType.VALUE_LITERAL);
        xAxisPrimary.getLabel().getCaption().getFont().setSize(9.0f);
        this.createXSeriesDefinition();
        Axis yAxisPrimary = this.getYAxisPrimary();
        yAxisPrimary.getMajorGrid().setTickStyle(TickStyle.LEFT_LITERAL);
        yAxisPrimary.setType(AxisType.LINEAR_LITERAL);
        yAxisPrimary.getLabel().getCaption().getFont().setRotation(90.0);
        yAxisPrimary.getLabel().getCaption().getFont().setSize(9.0f);
        this.createYSeriesDefinition();
        TextDataSet periods = TextDataSetImpl.create(newDataProvider.getCategoryLabels(newDataSource));
        ((Series)this.getXSeriesDefinition().getSeries().get(0)).setDataSet((DataSet)periods);
        return chart;
    }

    @Override
    public void createLegend() {
        super.createLegend();
        this.getLegend().setItemType(LegendItemType.SERIES_LITERAL);
    }

    protected abstract void addValueSet(Object var1);

    @Override
    public void updateSelection() {
        List valueSets = this.dataProvider.getValueSets(this.dataSource);
        this.getValueSetsDefinition().getSeries().clear();
        for (Object valueSet : valueSets) {
            this.addValueSet(valueSet);
        }
    }

    private void createXSeriesDefinition() {
        SeriesDefinition xSeriesDefinition = SeriesDefinitionImpl.create();
        Axis xAxisPrimary = this.getXAxisPrimary();
        xAxisPrimary.getSeriesDefinitions().clear();
        xAxisPrimary.getSeriesDefinitions().add((Object)xSeriesDefinition);
        xSeriesDefinition.getSeriesPalette().shift(0);
        Series xSeriesCategory = SeriesImpl.create();
        xSeriesDefinition.getSeries().clear();
        xSeriesDefinition.getSeries().add((Object)xSeriesCategory);
    }

    private void createYSeriesDefinition() {
        SeriesDefinition ySeriesDefinition = SeriesDefinitionImpl.create();
        Axis yAxisPrimary = this.getYAxisPrimary();
        yAxisPrimary.getSeriesDefinitions().clear();
        yAxisPrimary.getSeriesDefinitions().add((Object)ySeriesDefinition);
        ySeriesDefinition.setSeriesPalette(PaletteImpl.create((int)0, (boolean)true));
    }

    protected void addValueSeries(Series series, Object valueSet) {
        NumberDataSet data = NumberDataSetImpl.create((Object)this.dataProvider.getValues(valueSet));
        series.setDataSet((DataSet)data);
        this.getValueSetsDefinition().getSeries().add((Object)series);
        series.getLabel().setVisible(false);
        series.setSeriesIdentifier((Object)this.dataProvider.getText(valueSet));
    }

    @Override
    public boolean isInitialized() {
        return this.getXSeriesDefinition().getSeries().size() > 0 && ((Series)this.getXSeriesDefinition().getSeries().get(0)).getDataSet() != null && !((List)((Series)this.getXSeriesDefinition().getSeries().get(0)).getDataSet().getValues()).isEmpty();
    }

    private Axis getXAxisPrimary() {
        return ((ChartWithAxes)this.getChart()).getPrimaryBaseAxes()[0];
    }

    private Axis getYAxisPrimary() {
        return ((ChartWithAxes)this.getChart()).getPrimaryOrthogonalAxis(this.getXAxisPrimary());
    }

    private SeriesDefinition getYSeriesDefinition() {
        return (SeriesDefinition)this.getYAxisPrimary().getSeriesDefinitions().get(0);
    }

    private SeriesDefinition getXSeriesDefinition() {
        return (SeriesDefinition)this.getXAxisPrimary().getSeriesDefinitions().get(0);
    }

    @Override
    public SeriesDefinition getValueSetsDefinition() {
        return this.getYSeriesDefinition();
    }
}

