/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.chart.ui.swt.series;

import org.eclipse.birt.chart.exception.ChartException;
import org.eclipse.birt.chart.log.ILogger;
import org.eclipse.birt.chart.log.Logger;
import org.eclipse.birt.chart.model.attribute.ColorDefinition;
import org.eclipse.birt.chart.model.attribute.LineStyle;
import org.eclipse.birt.chart.model.component.Series;
import org.eclipse.birt.chart.model.type.DifferenceSeries;
import org.eclipse.birt.chart.model.type.LineSeries;
import org.eclipse.birt.chart.model.type.impl.LineSeriesImpl;
import org.eclipse.birt.chart.ui.extension.i18n.Messages;
import org.eclipse.birt.chart.ui.swt.composites.LineAttributesComposite;
import org.eclipse.birt.chart.ui.swt.wizard.ChartWizardContext;
import org.eclipse.birt.chart.ui.util.ChartUIUtil;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;

public class DifferenceSeriesAttributeComposite
extends Composite
implements SelectionListener,
Listener {
    private Button btnCurve = null;
    private Group grpLine1 = null;
    private LineAttributesComposite liacLine1 = null;
    private Group grpLine2 = null;
    private LineAttributesComposite liacLine2 = null;
    private Button btnPalette = null;
    private Series series = null;
    private ChartWizardContext context;
    private static ILogger logger = Logger.getLogger((String)"org.eclipse.birt.chart.ui.extension/swt.series");

    public DifferenceSeriesAttributeComposite(Composite parent, int style, ChartWizardContext context, Series series) {
        super(parent, style);
        if (!(series instanceof LineSeriesImpl)) {
            try {
                throw new ChartException("org.eclipse.birt.chart.ui.extension", 30, "DifferenceSeriesAttributeComposite.Exception.IllegalArgument", new Object[]{series.getClass().getName()}, Messages.getResourceBundle());
            }
            catch (ChartException e) {
                logger.log((Exception)((Object)e));
                e.printStackTrace();
            }
        }
        this.series = series;
        this.context = context;
        this.init();
        this.placeComponents();
        ChartUIUtil.bindHelp((Control)parent, (String)this.getHelpId(series));
    }

    private String getHelpId(Series series) {
        String helpId = "org.eclipse.birt.chart.cshelp.FormatDifferenceChartYSeries_ID";
        return helpId;
    }

    private void init() {
        this.setSize(this.getParent().getClientArea().width, this.getParent().getClientArea().height);
    }

    private void placeComponents() {
        GridLayout glContent = new GridLayout(2, false);
        glContent.marginHeight = 2;
        glContent.marginWidth = 2;
        this.setLayout((Layout)glContent);
        Group grpLine = new Group((Composite)this, 0);
        GridLayout glGroup = new GridLayout(2, true);
        glGroup.horizontalSpacing = 5;
        grpLine.setLayout((Layout)glGroup);
        grpLine.setLayoutData((Object)new GridData(1808));
        grpLine.setText(Messages.getString("DifferenceSeriesAttributeComposite.Lbl.Line"));
        this.grpLine1 = new Group((Composite)grpLine, 0);
        GridData gdGRPLine = new GridData(1808);
        this.grpLine1.setLayout((Layout)new FillLayout());
        this.grpLine1.setLayoutData((Object)gdGRPLine);
        this.grpLine1.setText(Messages.getString("DifferenceSeriesAttributeComposite.Lbl.PositiveLine"));
        this.liacLine1 = new LineAttributesComposite((Composite)this.grpLine1, 0, this.context, ((DifferenceSeries)this.series).getLineAttributes(), true, true, true, true, true);
        this.liacLine1.addListener(this);
        this.grpLine2 = new Group((Composite)grpLine, 0);
        gdGRPLine = new GridData(1808);
        this.grpLine2.setLayout((Layout)new FillLayout());
        this.grpLine2.setLayoutData((Object)gdGRPLine);
        this.grpLine2.setText(Messages.getString("DifferenceSeriesAttributeComposite.Lbl.NegativeLine"));
        this.liacLine2 = new LineAttributesComposite((Composite)this.grpLine2, 0, this.context, ((DifferenceSeries)this.series).getNegativeLineAttributes(), true, true, true, true, true);
        this.liacLine2.addListener(this);
        Composite cmpButton = new Composite((Composite)grpLine, 0);
        GridData gd = new GridData();
        gd.horizontalSpan = 2;
        cmpButton.setLayoutData((Object)gd);
        cmpButton.setLayout((Layout)new GridLayout(2, true));
        this.btnPalette = new Button(cmpButton, 32);
        this.btnPalette.setLayoutData((Object)new GridData());
        this.btnPalette.setText(Messages.getString("DifferenceSeriesAttributeComposite.Lbl.LinePalette"));
        this.btnPalette.setSelection(((LineSeries)this.series).isPaletteLineColor());
        this.btnPalette.addSelectionListener((SelectionListener)this);
        this.btnCurve = new Button(cmpButton, 32);
        this.btnCurve.setLayoutData((Object)new GridData());
        this.btnCurve.setText(Messages.getString("DifferenceSeriesAttributeComposite.Lbl.ShowLinesAsCurves"));
        this.btnCurve.setSelection(((DifferenceSeries)this.series).isCurve());
        this.btnCurve.addSelectionListener((SelectionListener)this);
        this.enableLinePaletteSetting(((DifferenceSeries)this.series).getLineAttributes().isVisible() || ((DifferenceSeries)this.series).getNegativeLineAttributes().isVisible());
    }

    public Point getPreferredSize() {
        return new Point(400, 200);
    }

    public void widgetSelected(SelectionEvent e) {
        if (e.getSource().equals(this.btnCurve)) {
            ((DifferenceSeries)this.series).setCurve(this.btnCurve.getSelection());
        } else if (e.getSource().equals(this.btnPalette)) {
            ((DifferenceSeries)this.series).setPaletteLineColor(this.btnPalette.getSelection());
        }
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }

    public void handleEvent(Event event) {
        if (event.widget.equals((Object)this.liacLine1)) {
            if (event.type == 4) {
                ((DifferenceSeries)this.series).getLineAttributes().setVisible(((Boolean)event.data).booleanValue());
                this.enableLinePaletteSetting(((DifferenceSeries)this.series).getLineAttributes().isVisible() || ((DifferenceSeries)this.series).getNegativeLineAttributes().isVisible());
            } else if (event.type == 1) {
                ((DifferenceSeries)this.series).getLineAttributes().setStyle((LineStyle)event.data);
            } else if (event.type == 2) {
                ((DifferenceSeries)this.series).getLineAttributes().setThickness(((Integer)event.data).intValue());
            } else if (event.type == 3) {
                ((DifferenceSeries)this.series).getLineAttributes().setColor((ColorDefinition)event.data);
            }
        } else if (event.widget.equals((Object)this.liacLine2)) {
            if (event.type == 4) {
                ((DifferenceSeries)this.series).getNegativeLineAttributes().setVisible(((Boolean)event.data).booleanValue());
                this.enableLinePaletteSetting(((DifferenceSeries)this.series).getNegativeLineAttributes().isVisible() || ((DifferenceSeries)this.series).getLineAttributes().isVisible());
            } else if (event.type == 1) {
                ((DifferenceSeries)this.series).getNegativeLineAttributes().setStyle((LineStyle)event.data);
            } else if (event.type == 2) {
                ((DifferenceSeries)this.series).getNegativeLineAttributes().setThickness(((Integer)event.data).intValue());
            } else if (event.type == 3) {
                ((DifferenceSeries)this.series).getNegativeLineAttributes().setColor((ColorDefinition)event.data);
            }
        }
    }

    private void enableLinePaletteSetting(boolean isEnabled) {
        if (this.btnPalette != null) {
            this.btnPalette.setEnabled(isEnabled);
        }
    }
}

