/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.draw2d;

import org.eclipse.draw2d.AbstractHintLayout;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.ScrollBar;
import org.eclipse.draw2d.ScrollPane;
import org.eclipse.draw2d.ScrollPaneSolver;
import org.eclipse.draw2d.Viewport;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.draw2d.geometry.Rectangle;

public class ScrollPaneLayout
extends AbstractHintLayout {
    protected static final int NEVER = 0;
    protected static final int AUTO = 1;
    protected static final int ALWAYS = 2;

    public Dimension calculateMinimumSize(IFigure figure, int w, int h) {
        ScrollPane scrollpane = (ScrollPane)figure;
        Insets insets = scrollpane.getInsets();
        Dimension d = scrollpane.getViewport().getMinimumSize(w, h);
        return d.getExpanded(insets.getWidth(), insets.getHeight());
    }

    protected Dimension calculatePreferredSize(IFigure container, int wHint, int hHint) {
        ScrollPane scrollpane = (ScrollPane)container;
        ScrollBar hBar = scrollpane.getHorizontalScrollBar();
        ScrollBar vBar = scrollpane.getVerticalScrollBar();
        Insets insets = scrollpane.getInsets();
        int reservedWidth = insets.getWidth();
        int reservedHeight = insets.getHeight();
        if (scrollpane.getVerticalScrollBarVisibility() != 0) {
            reservedWidth += vBar.getPreferredSize().width;
        }
        if (scrollpane.getHorizontalScrollBarVisibility() != 0) {
            reservedHeight += hBar.getPreferredSize().height;
        }
        if (wHint > -1) {
            wHint = Math.max(0, wHint - reservedWidth);
        }
        if (hHint > -1) {
            hHint = Math.max(0, hHint - reservedHeight);
        }
        return scrollpane.getViewport().getPreferredSize(wHint, hHint).getExpanded(reservedWidth, reservedHeight);
    }

    public void layout(IFigure parent) {
        ScrollPane scrollpane = (ScrollPane)parent;
        Viewport viewport = scrollpane.getViewport();
        ScrollBar hBar = scrollpane.getHorizontalScrollBar();
        ScrollBar vBar = scrollpane.getVerticalScrollBar();
        ScrollPaneSolver.Result result = ScrollPaneSolver.solve(parent.getClientArea(), viewport, scrollpane.getHorizontalScrollBarVisibility(), scrollpane.getVerticalScrollBarVisibility(), vBar.getPreferredSize().width, hBar.getPreferredSize().height);
        if (result.showV) {
            vBar.setBounds(new Rectangle(result.viewportArea.right(), result.viewportArea.y, result.insets.right, result.viewportArea.height));
        }
        if (result.showH) {
            hBar.setBounds(new Rectangle(result.viewportArea.x, result.viewportArea.bottom(), result.viewportArea.width, result.insets.bottom));
        }
        vBar.setVisible(result.showV);
        hBar.setVisible(result.showH);
        int vStepInc = vBar.getStepIncrement();
        int vPageInc = vBar.getRangeModel().getExtent() - vStepInc;
        if (vPageInc < vStepInc) {
            vPageInc = vStepInc;
        }
        vBar.setPageIncrement(vPageInc);
        int hStepInc = hBar.getStepIncrement();
        int hPageInc = hBar.getRangeModel().getExtent() - hStepInc;
        if (hPageInc < hStepInc) {
            hPageInc = hStepInc;
        }
        hBar.setPageIncrement(hPageInc);
    }
}

