/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.launcher;

import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.internal.launching.launcher.BundleLauncherHelper;
import org.eclipse.pde.internal.launching.launcher.LaunchValidationOperation;
import org.eclipse.pde.internal.launching.launcher.OSGiValidationOperation;
import org.eclipse.pde.internal.ui.launcher.AbstractPluginBlock;
import org.eclipse.pde.ui.launcher.BundlesTab;

public class OSGiBundleBlock
extends AbstractPluginBlock {
    private ILaunchConfiguration fLaunchConfiguration;

    public OSGiBundleBlock(BundlesTab tab) {
        super(tab);
    }

    protected void savePluginState(ILaunchConfigurationWorkingCopy config) {
        Object[] selected = this.fPluginTreeViewer.getCheckedElements();
        AbstractPluginBlock.PluginModelNameBuffer wBuffer = new AbstractPluginBlock.PluginModelNameBuffer();
        AbstractPluginBlock.PluginModelNameBuffer tBuffer = new AbstractPluginBlock.PluginModelNameBuffer();
        int i = 0;
        while (i < selected.length) {
            if (selected[i] instanceof IPluginModelBase) {
                IPluginModelBase model = (IPluginModelBase)selected[i];
                if (model.getUnderlyingResource() == null) {
                    tBuffer.add(model);
                } else {
                    wBuffer.add(model);
                }
            }
            ++i;
        }
        config.setAttribute("workspace_bundles", wBuffer.toString());
        config.setAttribute("target_bundles", tBuffer.toString());
        AbstractPluginBlock.PluginModelNameBuffer buffer = new AbstractPluginBlock.PluginModelNameBuffer();
        if (this.fAddWorkspaceButton.getSelection()) {
            IPluginModelBase[] workspaceModels = this.getWorkspaceModels();
            int i2 = 0;
            while (i2 < workspaceModels.length) {
                if (!this.fPluginTreeViewer.getChecked((Object)workspaceModels[i2])) {
                    buffer.add(workspaceModels[i2]);
                }
                ++i2;
            }
        }
        config.setAttribute("deselected_workspace_plugins", buffer.toString());
    }

    public void initializeFrom(ILaunchConfiguration configuration) throws CoreException {
        super.initializeFrom(configuration, true);
        this.initWorkspacePluginsState(configuration);
        this.initExternalPluginsState(configuration);
        this.updateCounter();
        this.fLaunchConfiguration = configuration;
        this.handleFilterButton();
    }

    private void initExternalPluginsState(ILaunchConfiguration configuration) throws CoreException {
        Map map = BundleLauncherHelper.getTargetBundleMap((ILaunchConfiguration)configuration, (Set)Collections.EMPTY_SET, (String)"target_bundles");
        Iterator iter = map.keySet().iterator();
        this.fPluginTreeViewer.setSubtreeChecked((Object)this.fExternalPlugins, false);
        while (iter.hasNext()) {
            IPluginModelBase model = (IPluginModelBase)iter.next();
            if (!this.fPluginTreeViewer.setChecked((Object)model, true)) continue;
            this.setText(model, map.get(model).toString());
        }
        this.fNumExternalChecked = map.size();
        this.resetGroup(this.fExternalPlugins);
        this.fPluginTreeViewer.setChecked((Object)this.fExternalPlugins, this.fNumExternalChecked > 0);
        this.fPluginTreeViewer.setGrayed((Object)this.fExternalPlugins, this.fNumExternalChecked > 0 && this.fNumExternalChecked < this.getExternalModels().length);
    }

    private void initWorkspacePluginsState(ILaunchConfiguration configuration) throws CoreException {
        Map map = BundleLauncherHelper.getWorkspaceBundleMap((ILaunchConfiguration)configuration);
        Iterator iter = map.keySet().iterator();
        this.fPluginTreeViewer.setSubtreeChecked((Object)this.fWorkspacePlugins, false);
        while (iter.hasNext()) {
            IPluginModelBase model = (IPluginModelBase)iter.next();
            if (!this.fPluginTreeViewer.setChecked((Object)model, true)) continue;
            this.setText(model, map.get(model).toString());
        }
        this.fNumWorkspaceChecked = map.size();
        this.resetGroup(this.fWorkspacePlugins);
        this.fPluginTreeViewer.setChecked((Object)this.fWorkspacePlugins, this.fNumWorkspaceChecked > 0);
        this.fPluginTreeViewer.setGrayed((Object)this.fWorkspacePlugins, this.fNumWorkspaceChecked > 0 && this.fNumWorkspaceChecked < this.getWorkspaceModels().length);
    }

    protected LaunchValidationOperation createValidationOperation() {
        return new OSGiValidationOperation(this.fLaunchConfiguration);
    }
}

