/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.views.plugins;

import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.pde.internal.core.FileAdapter;
import org.eclipse.swt.dnd.DragSource;
import org.eclipse.swt.dnd.DragSourceAdapter;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.swt.dnd.FileTransfer;
import org.eclipse.swt.widgets.Control;

public class PluginsDragAdapter
extends DragSourceAdapter {
    ISelectionProvider selectionProvider;

    public PluginsDragAdapter(ISelectionProvider provider) {
        this.selectionProvider = provider;
    }

    public void dragSetData(DragSourceEvent event) {
        if (!FileTransfer.getInstance().isSupportedType(event.dataType)) {
            return;
        }
        FileAdapter[] files = this.getSelectedFiles();
        int len = files.length;
        String[] fileNames = new String[len];
        int i = 0;
        int length = len;
        while (i < length) {
            fileNames[i] = files[i].getFile().getAbsolutePath();
            ++i;
        }
        event.data = fileNames;
    }

    public void dragStart(DragSourceEvent event) {
        DragSource dragSource = (DragSource)event.widget;
        Control control = dragSource.getControl();
        if (control != control.getDisplay().getFocusControl()) {
            event.doit = false;
            return;
        }
        FileAdapter[] files = this.getSelectedFiles();
        if (files.length == 0) {
            event.doit = false;
            return;
        }
        event.doit = true;
    }

    private FileAdapter[] getSelectedFiles() {
        IStructuredSelection selection = (IStructuredSelection)this.selectionProvider.getSelection();
        ArrayList files = new ArrayList();
        Iterator iter = selection.iterator();
        while (iter.hasNext()) {
            Object obj = iter.next();
            if (obj instanceof FileAdapter) {
                files.add(obj);
                continue;
            }
            return new FileAdapter[0];
        }
        return files.toArray(new FileAdapter[files.size()]);
    }
}

