/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.builder.builderState;

import com.google.common.collect.ImmutableList;
import com.google.inject.Inject;
import java.util.List;
import org.apache.log4j.Logger;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.xtext.builder.builderState.IMarkerUpdater;
import org.eclipse.xtext.builder.builderState.Messages;
import org.eclipse.xtext.resource.IResourceDescription;
import org.eclipse.xtext.resource.IResourceServiceProvider;
import org.eclipse.xtext.ui.MarkerTypes;
import org.eclipse.xtext.ui.editor.validation.MarkerCreator;
import org.eclipse.xtext.ui.resource.IStorage2UriMapper;
import org.eclipse.xtext.util.CancelIndicator;
import org.eclipse.xtext.util.Pair;
import org.eclipse.xtext.validation.CheckMode;
import org.eclipse.xtext.validation.CheckType;
import org.eclipse.xtext.validation.IResourceValidator;
import org.eclipse.xtext.validation.Issue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MarkerUpdaterImpl
implements IMarkerUpdater {
    @Inject
    private IResourceServiceProvider.Registry resourceServiceProviderRegistry;
    @Inject
    private MarkerCreator markerCreator;
    @Inject
    private IStorage2UriMapper mapper;
    private static final Logger log = Logger.getLogger(MarkerUpdaterImpl.class);

    @Override
    public void updateMarker(ResourceSet resourceSet, ImmutableList<IResourceDescription.Delta> resourceDescriptionDeltas, IProgressMonitor monitor) {
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (String)Messages.MarkerUpdaterImpl_ValidateResources, (int)resourceDescriptionDeltas.size());
        subMonitor.subTask(Messages.MarkerUpdaterImpl_ValidateResources);
        for (IResourceDescription.Delta delta : resourceDescriptionDeltas) {
            Iterable storages;
            if (subMonitor.isCanceled()) {
                throw new OperationCanceledException();
            }
            if (delta.getNew() != null) {
                storages = this.mapper.getStorages(delta.getNew().getURI());
                SubMonitor child = subMonitor.newChild(1);
                child.setWorkRemaining(3);
                for (Pair pair : storages) {
                    child.setWorkRemaining(3);
                    if (pair.getFirst() instanceof IFile) {
                        IFile file = (IFile)pair.getFirst();
                        if (file.isReadOnly() || ((IProject)pair.getSecond()).isHidden()) continue;
                        Resource resource = resourceSet.getResource(delta.getNew().getURI(), true);
                        this.addMarkers(file, resource, (IProgressMonitor)child.newChild(2));
                        continue;
                    }
                    child.worked(1);
                }
                continue;
            }
            storages = this.mapper.getStorages(delta.getOld().getURI());
            for (Pair pair : storages) {
                IFile file;
                if (!(pair.getFirst() instanceof IFile) || (file = (IFile)pair.getFirst()).isReadOnly() || !file.isAccessible()) continue;
                try {
                    file.deleteMarkers("org.eclipse.xtext.ui.check.fast", true, 0);
                    file.deleteMarkers("org.eclipse.xtext.ui.check.normal", true, 0);
                }
                catch (CoreException ex) {
                    log.error((Object)ex.getMessage(), (Throwable)ex);
                }
            }
            subMonitor.worked(1);
        }
    }

    protected void addMarkers(IFile file, Resource resource, IProgressMonitor monitor) {
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)1);
        try {
            IResourceServiceProvider provider = this.resourceServiceProviderRegistry.getResourceServiceProvider(resource.getURI());
            if (provider == null) {
                return;
            }
            IResourceValidator resourceValidator = provider.getResourceValidator();
            List list = resourceValidator.validate(resource, CheckMode.NORMAL_AND_FAST, this.getCancelIndicator((IProgressMonitor)subMonitor));
            if (subMonitor.isCanceled()) {
                throw new OperationCanceledException();
            }
            subMonitor.worked(1);
            file.deleteMarkers("org.eclipse.xtext.ui.check.fast", true, 0);
            file.deleteMarkers("org.eclipse.xtext.ui.check.normal", true, 0);
            for (Issue issue : list) {
                this.markerCreator.createMarker(issue, (IResource)file, MarkerTypes.forCheckType((CheckType)issue.getType()));
            }
        }
        catch (CoreException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    private CancelIndicator getCancelIndicator(final IProgressMonitor monitor) {
        return new CancelIndicator(){

            public boolean isCanceled() {
                return monitor.isCanceled();
            }
        };
    }
}

