/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ui.editor.model;

import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITypedRegion;
import org.eclipse.jface.text.Region;

public class DocumentUtil {
    public IRegion searchBackwardsInSamePartition(String toFind, IDocument document, int endOffset) throws BadLocationException {
        if (endOffset < 0) {
            return null;
        }
        ITypedRegion partition = document.getPartition(endOffset);
        int indexOf = this.preProcessSearchString(document.get(0, endOffset)).lastIndexOf(toFind);
        while (indexOf >= 0) {
            ITypedRegion partition2 = document.getPartition(indexOf);
            if (partition2.getType().equals(partition.getType())) {
                return new Region(indexOf, toFind.length());
            }
            indexOf = this.preProcessSearchString(document.get(0, partition2.getOffset())).lastIndexOf(toFind);
        }
        String trimmed = toFind.trim();
        if (trimmed.length() > 0 && trimmed.length() != toFind.length()) {
            return this.searchBackwardsInSamePartition(trimmed, document, endOffset);
        }
        return null;
    }

    protected String preProcessSearchString(String string) {
        return string;
    }

    public IRegion searchInSamePartition(String toFind, IDocument document, int startOffset) throws BadLocationException {
        if (startOffset >= document.getLength()) {
            return null;
        }
        ITypedRegion partition = document.getPartition(startOffset);
        int ignoredPrefix = startOffset;
        int subtractMe = 0;
        while (toFind.length() > subtractMe && Character.isWhitespace(toFind.charAt(subtractMe))) {
            ++subtractMe;
        }
        ignoredPrefix = Math.max(ignoredPrefix - subtractMe, 0);
        int indexOf = this.preProcessSearchString(document.get().substring(ignoredPrefix)).indexOf(toFind);
        if (indexOf != -1) {
            indexOf += ignoredPrefix;
        }
        while (indexOf >= 0 && indexOf < document.getLength()) {
            ITypedRegion partition2 = document.getPartition(indexOf);
            if (partition2.getType().equals(partition.getType())) {
                return new Region(indexOf, toFind.length());
            }
            ignoredPrefix = partition2.getOffset() + partition2.getLength();
            indexOf = this.preProcessSearchString(document.get().substring(ignoredPrefix)).indexOf(toFind);
            if (indexOf == -1) continue;
            indexOf += ignoredPrefix;
        }
        String trimmed = toFind.trim();
        if (trimmed.length() > 0 && trimmed.length() != toFind.length()) {
            return this.searchInSamePartition(trimmed, document, startOffset);
        }
        return null;
    }

    public boolean isSameLine(IDocument doc, int offset, int offset2) throws BadLocationException {
        return doc.getLineOfOffset(offset) == doc.getLineOfOffset(offset2);
    }

    public int findNextOffSetInPartition(IDocument doc, int partitionOffSet, int minIndex) throws BadLocationException {
        ITypedRegion partition = doc.getPartition(partitionOffSet);
        ITypedRegion partition2 = doc.getPartition(minIndex);
        if (partition.getType().equals(partition2.getType())) {
            return minIndex;
        }
        return this.findNextOffSetInPartition(doc, partitionOffSet, minIndex + partition2.getLength());
    }
}

