/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ui.refactoring.ui;

import com.google.inject.Inject;
import com.google.inject.Provider;
import org.apache.log4j.Logger;
import org.eclipse.emf.common.util.WrappedException;
import org.eclipse.ltk.core.refactoring.participants.ProcessorBasedRefactoring;
import org.eclipse.ltk.core.refactoring.participants.RenameProcessor;
import org.eclipse.ltk.ui.refactoring.RefactoringWizard;
import org.eclipse.ltk.ui.refactoring.RefactoringWizardOpenOperation;
import org.eclipse.xtext.resource.IGlobalServiceProvider;
import org.eclipse.xtext.ui.refactoring.IRenameProcessorAdapter;
import org.eclipse.xtext.ui.refactoring.IRenameRefactoringProvider;
import org.eclipse.xtext.ui.refactoring.ui.IRenameElementContext;
import org.eclipse.xtext.ui.refactoring.ui.IRenameSupport;
import org.eclipse.xtext.ui.refactoring.ui.RenameElementWizard;
import org.eclipse.xtext.ui.refactoring.ui.RenameRefactoringExecuter;

public class DefaultRenameSupport
implements IRenameSupport {
    private static final Logger LOG = Logger.getLogger(DefaultRenameSupport.class);
    private DeclaringLanguageComponentFactory declaringLanguage;
    private ProcessorBasedRefactoring renameRefactoring;
    private IRenameElementContext renameElementContext;
    private IRenameProcessorAdapter renameProcessorAdapter;

    protected DefaultRenameSupport(DeclaringLanguageComponentFactory declaringLanguage, IRenameElementContext renameElementContext, String newName) {
        this.declaringLanguage = declaringLanguage;
        this.renameElementContext = renameElementContext;
        this.renameRefactoring = declaringLanguage.createRenameRefactoring(renameElementContext);
        this.renameProcessorAdapter = declaringLanguage.getRenameProcessorAdapter(this.renameRefactoring);
        this.renameProcessorAdapter.setNewName(newName);
    }

    public void startRefactoringWithDialog(final boolean previewOnly) throws InterruptedException {
        RenameElementWizard renameElementWizard = new RenameElementWizard(this.renameRefactoring, this.renameProcessorAdapter){

            protected void addUserInputPages() {
                if (!previewOnly) {
                    super.addUserInputPages();
                }
            }
        };
        if (previewOnly) {
            renameElementWizard.setForcePreviewReview(true);
        }
        RefactoringWizardOpenOperation openOperation = new RefactoringWizardOpenOperation((RefactoringWizard)renameElementWizard);
        openOperation.run(this.renameElementContext.getTriggeringEditor().getSite().getShell(), "Rename Element");
    }

    public void startDirectRefactoring() throws InterruptedException {
        RenameRefactoringExecuter renameRefactoringExecuter = this.declaringLanguage.createRenameRefactoringExecuter();
        renameRefactoringExecuter.execute(this.renameElementContext.getTriggeringEditor(), this.renameRefactoring);
    }

    protected static class DeclaringLanguageComponentFactory {
        @Inject
        private Provider<RenameRefactoringExecuter> renameRefactoringExecuterProvider;
        @Inject
        private IRenameRefactoringProvider renameRefactoringProvider;
        @Inject
        private IRenameProcessorAdapter.Factory renameProcessAdapterFactory;

        protected DeclaringLanguageComponentFactory() {
        }

        public RenameRefactoringExecuter createRenameRefactoringExecuter() {
            return (RenameRefactoringExecuter)this.renameRefactoringExecuterProvider.get();
        }

        public ProcessorBasedRefactoring createRenameRefactoring(IRenameElementContext renameElementContext) {
            return this.renameRefactoringProvider.getRenameRefactoring(renameElementContext);
        }

        public IRenameProcessorAdapter getRenameProcessorAdapter(ProcessorBasedRefactoring renameRefactoring) {
            return this.renameProcessAdapterFactory.create((RenameProcessor)renameRefactoring.getProcessor());
        }
    }

    public static class Factory
    implements IRenameSupport.Factory {
        @Inject
        private IGlobalServiceProvider globalServiceProvider;

        public IRenameSupport create(Object context, String newName) {
            if (context instanceof IRenameElementContext) {
                IRenameElementContext renameElementContext = (IRenameElementContext)context;
                return new DefaultRenameSupport(this.getDeclaringLanguageComponentFactory(renameElementContext), renameElementContext, newName);
            }
            return null;
        }

        protected DeclaringLanguageComponentFactory getDeclaringLanguageComponentFactory(IRenameElementContext renameElementContext) {
            try {
                DeclaringLanguageComponentFactory languageComponentFactory = (DeclaringLanguageComponentFactory)this.globalServiceProvider.findService(renameElementContext.getTargetElementURI(), DeclaringLanguageComponentFactory.class);
                return languageComponentFactory;
            }
            catch (Exception e) {
                LOG.error((Object)"Error getting refactoring components from declaring language", (Throwable)e);
                throw new WrappedException(e);
            }
        }
    }
}

