/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.util.formallang;

import com.google.common.base.Predicate;
import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.xtext.util.formallang.INfaAdapter;
import org.eclipse.xtext.util.formallang.ITokenNfaAdapter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NfaUtil {
    protected <STATE> void collectFinalStates(INfaAdapter<STATE> nfa, STATE owner, STATE last, Set<STATE> result, Set<STATE> visited, Set<STATE> ends, Predicate<STATE> filter) {
        if (!visited.add(owner)) {
            return;
        }
        if (filter.apply(owner)) {
            last = owner;
        }
        if (last != null && ends.contains(owner)) {
            result.add(last);
        }
        for (STATE follower : nfa.getFollowers(owner)) {
            this.collectFinalStates(nfa, follower, last, result, visited, ends, filter);
        }
    }

    protected <STATE> void collectFollowers(INfaAdapter<STATE> nfa, STATE owner, Set<STATE> result, Set<STATE> visited, Predicate<STATE> filter) {
        if (!visited.add(owner)) {
            return;
        }
        if (filter.apply(owner)) {
            result.add(owner);
            return;
        }
        for (STATE follower : nfa.getFollowers(owner)) {
            this.collectFollowers(nfa, follower, result, visited, filter);
        }
    }

    public <STATE> INfaAdapter<STATE> filter(final INfaAdapter<STATE> nfa, final Predicate<STATE> filter) {
        return new INfaAdapter<STATE>(){

            @Override
            public Iterable<STATE> getFinalStates() {
                return NfaUtil.this.filterFinalStates(nfa, filter);
            }

            @Override
            public Iterable<STATE> getFollowers(STATE node) {
                return NfaUtil.this.filterFollowers(nfa, nfa.getFollowers(node), filter);
            }

            @Override
            public Iterable<STATE> getStartStates() {
                return NfaUtil.this.filterFollowers(nfa, nfa.getStartStates(), filter);
            }
        };
    }

    public <STATE, TOKEN> ITokenNfaAdapter<STATE, TOKEN> filter(final ITokenNfaAdapter<STATE, TOKEN> nfa, final Predicate<STATE> filter) {
        return new ITokenNfaAdapter<STATE, TOKEN>(){

            @Override
            public Iterable<STATE> getFinalStates() {
                return NfaUtil.this.filterFinalStates(nfa, filter);
            }

            @Override
            public Iterable<STATE> getFollowers(STATE node) {
                return NfaUtil.this.filterFollowers(nfa, nfa.getFollowers(node), filter);
            }

            @Override
            public Iterable<STATE> getStartStates() {
                return NfaUtil.this.filterFollowers(nfa, nfa.getStartStates(), filter);
            }

            @Override
            public TOKEN getToken(STATE owner) {
                return filter.apply(owner) ? (Object)nfa.getToken(owner) : null;
            }
        };
    }

    public <STATE> Iterable<STATE> filterFinalStates(INfaAdapter<STATE> nfa, Predicate<STATE> filter) {
        HashSet ends = Sets.newHashSet(nfa.getFinalStates());
        HashSet result = Sets.newHashSet();
        for (STATE start : nfa.getStartStates()) {
            this.collectFinalStates(nfa, start, null, result, Sets.newHashSet(), ends, filter);
        }
        return result;
    }

    public <STATE> Iterable<STATE> filterFollowers(INfaAdapter<STATE> nfa, Iterable<STATE> followers, Predicate<STATE> filter) {
        HashSet result = Sets.newHashSet();
        for (STATE follower : followers) {
            this.collectFollowers(nfa, follower, result, Sets.newHashSet(), filter);
        }
        return result;
    }
}

