/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.app4mc.amalthea.converters081.impl;

import java.io.File;
import java.util.List;
import java.util.Map;
import org.eclipse.app4mc.amalthea.converters.common.base.ICache;
import org.eclipse.app4mc.amalthea.converters.common.base.IConverter;
import org.eclipse.app4mc.amalthea.converters.common.converter.AbstractConverter;
import org.eclipse.app4mc.amalthea.converters.common.utils.AmaltheaNamespaceRegistry;
import org.eclipse.app4mc.amalthea.converters.common.utils.HelperUtil;
import org.eclipse.app4mc.amalthea.converters081.utils.HelperUtils081;
import org.eclipse.app4mc.util.sessionlog.SessionLogger;
import org.jdom2.Attribute;
import org.jdom2.Content;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.Namespace;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"input_model_version=0.8.0", "output_model_version=0.8.1"}, service={IConverter.class})
public class OSConverter
extends AbstractConverter {
    private static final String KEY = "key";
    private static final String VALUE = "value";
    private static final String TYPE = "type";
    private static final String CUSTOM_PROPERTIES = "customProperties";
    private static final String SCHEDULE_UNIT_PRIORITY = "scheduleUnitPriority";
    @Reference
    SessionLogger logger;

    @Activate
    protected void activate(Map<String, Object> properties) {
        super.activate(properties);
    }

    public void convert(File targetFile, Map<File, Document> filename2documentMap, List<ICache> caches) {
        this.logger.info("Migration from 0.8.0 to 0.8.1 : Executing OS converter for model file : {0}", new Object[]{targetFile.getName()});
        Document root = filename2documentMap.get(targetFile);
        if (root == null) {
            return;
        }
        Element rootElement = root.getRootElement();
        this.updateOSModel(rootElement);
    }

    private void updateOSModel(Element rootElement) {
        StringBuilder xpathBuffer = new StringBuilder();
        xpathBuffer.append("./osModel/operatingSystems/interruptControllers");
        xpathBuffer.append("|");
        xpathBuffer.append("./osModel/operatingSystems/taskSchedulers");
        List sourceElements = HelperUtil.getXpathResult((Element)rootElement, (String)xpathBuffer.toString(), Element.class, (Namespace[])new Namespace[]{AmaltheaNamespaceRegistry.getGenericNamespace((String)"xsi")});
        for (Element schedulerElement : sourceElements) {
            List algorithmParameterElements = HelperUtil.getXpathResult((Element)schedulerElement, (String)"./schedulingAlgorithm[@xsi:type=\"am:UserSpecificSchedulingAlgorithm\"]/parameter", Element.class, (Namespace[])new Namespace[]{AmaltheaNamespaceRegistry.getGenericNamespace((String)"xsi")});
            for (Element algorithmParameterElement : algorithmParameterElements) {
                algorithmParameterElement.setName("parameterExtensions");
            }
            String scheduleUnitPriority = schedulerElement.getAttributeValue(SCHEDULE_UNIT_PRIORITY);
            if (scheduleUnitPriority != null && !"0".equals(scheduleUnitPriority)) {
                HelperUtils081.addCustomProperty(schedulerElement, SCHEDULE_UNIT_PRIORITY, schedulerElement.getAttributeValue(SCHEDULE_UNIT_PRIORITY));
            }
            schedulerElement.removeAttribute(SCHEDULE_UNIT_PRIORITY);
            Element schedulingUnitElement = schedulerElement.getChild("schedulingUnit");
            if (schedulingUnitElement == null) continue;
            this.logger.warn("SchedulingUnit removed from Scheduler : {0}", new Object[]{schedulerElement.getAttributeValue("name")});
            String schedulingUnitType = schedulingUnitElement.getAttributeValue(TYPE, AmaltheaNamespaceRegistry.getGenericNamespace((String)"xsi"));
            if (schedulingUnitType != null) {
                if ("am:SchedulingHWUnit".equals(schedulingUnitType)) {
                    this.moveCustomPropertiesOfSchedulingUnit(schedulerElement, schedulingUnitElement, "SchedulingHWUnit_CustomProperty__");
                    Element delayElement = schedulingUnitElement.getChild("delay");
                    if (delayElement != null) {
                        delayElement.detach();
                        Element customPropertiesElement = new Element(CUSTOM_PROPERTIES);
                        customPropertiesElement.setAttribute(KEY, "SchedulingHWUnit___delay");
                        delayElement.setName(VALUE);
                        delayElement.setAttribute(TYPE, "am:TimeObject", AmaltheaNamespaceRegistry.getGenericNamespace((String)"xsi"));
                        customPropertiesElement.addContent((Content)delayElement);
                        schedulerElement.addContent((Content)customPropertiesElement);
                        HelperUtils081.addCustomProperty(schedulerElement, "SchedulingHWUnit___delay", schedulerElement.getAttributeValue("delay"));
                    }
                } else if ("am:SchedulingSWUnit".equals(schedulingUnitType)) {
                    this.moveCustomPropertiesOfSchedulingUnit(schedulerElement, schedulingUnitElement, "SchedulingSWUnit_CustomProperty__");
                    List instructionElements = schedulingUnitElement.getChildren("instructions");
                    if (!instructionElements.isEmpty()) {
                        this.logger.warn("-- Instructions inside SchedulingSWUnit are migrated to RunnableInstructions element", new Object[0]);
                    }
                    for (Element instructionElement : instructionElements) {
                        Element clone = instructionElement.clone();
                        clone.setName("default");
                        Element computationItemElement = new Element("computationItems");
                        computationItemElement.setAttribute(TYPE, "am:RunnableInstructions", AmaltheaNamespaceRegistry.getGenericNamespace((String)"xsi"));
                        computationItemElement.addContent((Content)clone);
                        schedulerElement.addContent((Content)computationItemElement);
                    }
                    String priority = schedulingUnitElement.getAttributeValue("priority");
                    if (priority != null && !"0".equals(priority)) {
                        HelperUtils081.addCustomProperty(schedulerElement, "SchedulingSWUnit___priority", priority);
                    }
                    if (schedulingUnitElement.removeAttribute("interruptController") || schedulingUnitElement.removeChild("interruptController")) {
                        this.logger.warn("-- InterruptController inside SchedulingSWUnit is removed, as there is no equivalent element for it in AMALTHEA 0.8.1", new Object[0]);
                    }
                }
            }
            schedulerElement.removeChild("schedulingUnit");
        }
    }

    private void moveCustomPropertiesOfSchedulingUnit(Element schedulerElement, Element schedulingUnitElement, String prefix) {
        List customPropertyElements = schedulingUnitElement.getChildren(CUSTOM_PROPERTIES);
        for (Element customProperty : customPropertyElements) {
            Element cloneCustomProperty = customProperty.clone();
            Attribute keyAttribute = cloneCustomProperty.getAttribute(KEY);
            if (keyAttribute != null) {
                String value = keyAttribute.getValue();
                keyAttribute.setValue(String.valueOf(prefix) + value);
            }
            schedulerElement.addContent((Content)cloneCustomProperty);
        }
    }
}

