/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.app4mc.amalthea.converters093.impl;

import java.io.File;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.app4mc.amalthea.converters.common.base.ICache;
import org.eclipse.app4mc.amalthea.converters.common.base.IConverter;
import org.eclipse.app4mc.amalthea.converters.common.converter.AbstractConverter;
import org.eclipse.app4mc.amalthea.converters.common.utils.AmaltheaNamespaceRegistry;
import org.eclipse.app4mc.amalthea.converters.common.utils.HelperUtil;
import org.eclipse.app4mc.amalthea.converters.common.utils.ModelVersion;
import org.eclipse.app4mc.amalthea.converters093.utils.HWCacheBuilder;
import org.eclipse.app4mc.amalthea.converters093.utils.HelperUtils093;
import org.eclipse.app4mc.amalthea.converters093.utils.PUDefinitionIPCData;
import org.eclipse.app4mc.util.sessionlog.SessionLogger;
import org.jdom2.Attribute;
import org.jdom2.Content;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.Namespace;
import org.jdom2.Parent;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"input_model_version=0.9.2", "output_model_version=0.9.3"}, service={IConverter.class})
public class SwConverter
extends AbstractConverter {
    private static final String AM = "am";
    private static final String XSI = "xsi";
    private static final String TYPE = "type";
    private static final String KEY = "key";
    private static final String VALUE = "value";
    private static final String INTERRUPT_CONTROLLER = "InterruptController";
    private static final String TASK_SCHEDULER = "TaskScheduler";
    @Reference
    SessionLogger logger;
    private PUDefinitionIPCData cache;

    @Activate
    protected void activate(Map<String, Object> properties) {
        super.activate(properties);
    }

    public void convert(File targetFile, Map<File, Document> fileDocumentMapping, List<ICache> caches) {
        this.logger.info("Migration from 0.9.2 to 0.9.3 : Executing Sw converter for model file : {0}", new Object[]{targetFile.getName()});
        this.cache = this.getHWCache(caches);
        if (this.cache == null) {
            throw new IllegalStateException("PUDefinition_IPCData is not built and Object of it is not available in Converters");
        }
        Document root = fileDocumentMapping.get(targetFile);
        if (root == null) {
            return;
        }
        Element rootElement = root.getRootElement();
        this.updateExecutionNeed(rootElement);
        this.updateChunkProcessingInstructions(rootElement);
        this.updateActivations(rootElement);
    }

    private void updateActivations(Element rootElement) {
        StringBuilder xpathBuffer = new StringBuilder();
        xpathBuffer.append("./swModel/activations");
        List activationElements = HelperUtil.getXpathResult((Element)rootElement, (String)xpathBuffer.toString(), Element.class, (Namespace[])new Namespace[]{AmaltheaNamespaceRegistry.getNamespace((ModelVersion)ModelVersion.VERSION_093, (String)AM), AmaltheaNamespaceRegistry.getGenericNamespace((String)XSI)});
        for (Element activationElement : activationElements) {
            Element activationDeviationElement;
            int indexOf;
            Element migratedElement;
            String activationType = activationElement.getAttributeValue(TYPE, AmaltheaNamespaceRegistry.getGenericNamespace((String)XSI));
            if (activationType == null) continue;
            if ("am:VariableRateActivation".equals(activationType)) {
                Element occurrencesPerStepDeviationElement = activationElement.getChild("occurrencesPerStep");
                if (occurrencesPerStepDeviationElement == null) continue;
                migratedElement = HelperUtils093.migrateDeviationElementContainingDoubleValue(occurrencesPerStepDeviationElement, "occurrencesPerStep", this.logger);
                indexOf = activationElement.indexOf((Content)occurrencesPerStepDeviationElement);
                activationElement.removeContent((Content)occurrencesPerStepDeviationElement);
                if (migratedElement == null) continue;
                activationElement.addContent(indexOf, (Content)migratedElement);
                continue;
            }
            if (!"am:SporadicActivation".equals(activationType) || (activationDeviationElement = activationElement.getChild("activationDeviation")) == null) continue;
            migratedElement = HelperUtils093.migrateDeviationElementContainingTimeValue(activationDeviationElement, "activationDeviation", this.logger);
            indexOf = activationElement.indexOf((Content)activationDeviationElement);
            activationElement.removeContent((Content)activationDeviationElement);
            if (migratedElement == null) continue;
            activationElement.addContent(indexOf, (Content)migratedElement);
            migratedElement.setName("occurrence");
        }
    }

    private void updateChunkProcessingInstructions(Element rootElement) {
        StringBuilder xpathBuffer = new StringBuilder();
        xpathBuffer.append("./swModel/runnables//*[@xsi:type=\"am:LabelAccess\" or @xsi:type=\"am:ChannelSend\" or @xsi:type=\"am:ChannelReceive\"]/transmissionPolicy");
        xpathBuffer.append("|");
        xpathBuffer.append("./osModel/operatingSystems/taskSchedulers/computationItems[@xsi:type=\"am:LabelAccess\"]/transmissionPolicy");
        xpathBuffer.append("|");
        xpathBuffer.append("./osModel/operatingSystems/interruptControllers/computationItems[@xsi:type=\"am:LabelAccess\"]/transmissionPolicy");
        List transmissionPolicyElements = HelperUtil.getXpathResult((Element)rootElement, (String)xpathBuffer.toString(), Element.class, (Namespace[])new Namespace[]{AmaltheaNamespaceRegistry.getNamespace((ModelVersion)ModelVersion.VERSION_093, (String)AM), AmaltheaNamespaceRegistry.getGenericNamespace((String)XSI)});
        for (Element transmissionPolicyElement : transmissionPolicyElements) {
            Attribute attribute = transmissionPolicyElement.getAttribute("chunkProcessingInstructions");
            if (attribute == null) continue;
            attribute.setName("chunkProcessingTicks");
        }
    }

    private void updateExecutionNeed(Element rootElement) {
        StringBuilder xpathBuffer = new StringBuilder();
        xpathBuffer.append("./swModel/runnables//*[@xsi:type=\"am:ExecutionNeed\"]");
        xpathBuffer.append("|");
        xpathBuffer.append("./osModel/operatingSystems/taskSchedulers/computationItems[@xsi:type=\"am:ExecutionNeed\"]");
        xpathBuffer.append("|");
        xpathBuffer.append("./osModel/operatingSystems/interruptControllers/computationItems[@xsi:type=\"am:ExecutionNeed\"]");
        List executionNeeds = HelperUtil.getXpathResult((Element)rootElement, (String)xpathBuffer.toString(), Element.class, (Namespace[])new Namespace[]{AmaltheaNamespaceRegistry.getNamespace((ModelVersion)ModelVersion.VERSION_093, (String)AM), AmaltheaNamespaceRegistry.getGenericNamespace((String)XSI)});
        for (Element executionNeedElement : executionNeeds) {
            String containerElementName = null;
            String containerType = "";
            Element parentElement = HelperUtil.getParentElementOfName((Element)executionNeedElement, (String[])new String[]{"runnables", "taskSchedulers", "interruptControllers"});
            if (parentElement != null) {
                containerElementName = parentElement.getAttributeValue("name");
                if ("runnables".equals(parentElement.getName())) {
                    containerType = "Runnable";
                } else if ("taskSchedulers".equals(parentElement.getName())) {
                    containerType = TASK_SCHEDULER;
                } else if ("interruptControllers".equals(parentElement.getName())) {
                    containerType = INTERRUPT_CONTROLLER;
                }
            }
            String nodeName = executionNeedElement.getName();
            List defaultElements = executionNeedElement.getChildren("default");
            LinkedHashMap<String, Element> defaultElementsMap = new LinkedHashMap<String, Element>();
            for (Element defaultElement : defaultElements) {
                String key = defaultElement.getAttributeValue(KEY);
                if (key == null) continue;
                defaultElementsMap.put(key, defaultElement);
            }
            Element newExecutionTicksElement = null;
            Element newExecutionNeedsElement = null;
            Set entrySet = defaultElementsMap.entrySet();
            for (Map.Entry next : entrySet) {
                Element newNeedElementValue;
                Element valueElement;
                Attribute typeAttribute;
                String key = (String)next.getKey();
                if ("Instructions".equals(key)) {
                    Element defaultInstructionsElement = (Element)defaultElementsMap.get("Instructions");
                    newExecutionTicksElement = new Element(nodeName);
                    typeAttribute = new Attribute(TYPE, "am:Ticks", AmaltheaNamespaceRegistry.getGenericNamespace((String)XSI));
                    newExecutionTicksElement.getAttributes().add(typeAttribute);
                    Element valueElement2 = defaultInstructionsElement.getChild(VALUE);
                    Element defaultExecutionTicksElement = this.createTicksElementFromNeed(valueElement2, "default", 1.0);
                    if (defaultExecutionTicksElement == null) continue;
                    newExecutionTicksElement.addContent((Content)defaultExecutionTicksElement);
                    continue;
                }
                if (TASK_SCHEDULER.equals(containerType) || INTERRUPT_CONTROLLER.equals(containerType)) {
                    this.logger.warn("In {0} : {1}, ExecutionNeed element's NeedEntry (having HwFeatureCategory : {2})-> can not be migrated. As this is not supported in 0.9.3. \nIn {3} element only NeedEntry elements having HwFeatureCategory Instructions are migrated to Ticks", new Object[]{containerType, containerElementName, key, containerType});
                    continue;
                }
                Element defaultExecutionNeedElement = (Element)defaultElementsMap.get(key);
                if (newExecutionNeedsElement == null) {
                    newExecutionNeedsElement = new Element(nodeName);
                    typeAttribute = new Attribute(TYPE, "am:ExecutionNeed", AmaltheaNamespaceRegistry.getGenericNamespace((String)XSI));
                    newExecutionNeedsElement.getAttributes().add(typeAttribute);
                }
                if ((valueElement = defaultExecutionNeedElement.getChild(VALUE)) == null || (newNeedElementValue = this.createTicksElementFromNeed(valueElement, VALUE, 1.0)) == null) continue;
                Element needsElement = new Element("needs");
                needsElement.setAttribute(new Attribute(KEY, key));
                needsElement.addContent((Content)newNeedElementValue);
                newExecutionNeedsElement.addContent((Content)needsElement);
            }
            List extendedElements = executionNeedElement.getChildren("extended");
            for (Element extendedElement : extendedElements) {
                Double ipcValue = this.getIPCValue(extendedElement);
                List valueElements = HelperUtil.getXpathResult((Element)extendedElement, (String)"./value[@key=\"Instructions\"]", Element.class, (Namespace[])new Namespace[]{AmaltheaNamespaceRegistry.getNamespace((ModelVersion)ModelVersion.VERSION_093, (String)AM)});
                if (valueElements.isEmpty()) continue;
                Element extendedExecutionTicksElement = new Element("extended");
                HelperUtil.copyElementAttributeOrElement((Element)extendedElement, (Element)extendedExecutionTicksElement, (String)KEY);
                Element valueElement = (Element)valueElements.get(0);
                Element valueValueElement = valueElement.getChild(VALUE);
                Element valueExecutionTicksElement = this.createTicksElementFromNeed(valueValueElement, VALUE, ipcValue);
                if (valueExecutionTicksElement == null) continue;
                extendedExecutionTicksElement.addContent((Content)valueExecutionTicksElement);
                if (newExecutionTicksElement == null) {
                    newExecutionTicksElement = new Element(nodeName);
                    Attribute typeAttribute = new Attribute(TYPE, "am:Ticks", AmaltheaNamespaceRegistry.getGenericNamespace((String)XSI));
                    newExecutionTicksElement.getAttributes().add(typeAttribute);
                }
                newExecutionTicksElement.addContent((Content)extendedExecutionTicksElement);
            }
            ArrayList<Element> newRunnableItemElementsList = new ArrayList<Element>();
            if (newExecutionTicksElement != null) {
                newRunnableItemElementsList.add(newExecutionTicksElement);
            }
            if (newExecutionNeedsElement != null) {
                newRunnableItemElementsList.add(newExecutionNeedsElement);
            }
            Parent parent = executionNeedElement.getParent();
            int indexOf = parent.indexOf((Content)executionNeedElement);
            if (!newRunnableItemElementsList.isEmpty()) {
                parent.addContent(indexOf, newRunnableItemElementsList);
            }
            List skippedValuesExtended = HelperUtil.getXpathResult((Element)executionNeedElement, (String)"./extended/value[not(@key=\"Instructions\")]", Element.class, (Namespace[])new Namespace[]{AmaltheaNamespaceRegistry.getNamespace((ModelVersion)ModelVersion.VERSION_093, (String)AM)});
            List skippedValuesDefault = HelperUtil.getXpathResult((Element)executionNeedElement, (String)"./default[not(@key=\"Instructions\")]", Element.class, (Namespace[])new Namespace[]{AmaltheaNamespaceRegistry.getNamespace((ModelVersion)ModelVersion.VERSION_093, (String)AM)});
            StringBuilder extendedElementsbuffer = new StringBuilder();
            for (Element elementKey : skippedValuesExtended) {
                String attributeValue = elementKey.getAttributeValue(KEY);
                extendedElementsbuffer.append(attributeValue);
                extendedElementsbuffer.append(",");
            }
            StringBuilder defaultElementsbuffer = new StringBuilder();
            for (Element elementKey : skippedValuesDefault) {
                String attributeValue = elementKey.getAttributeValue(KEY);
                defaultElementsbuffer.append(attributeValue);
                defaultElementsbuffer.append(",");
            }
            if (extendedElementsbuffer.length() > 0) {
                this.logger.info("In {0} : \"{1}, \" Entries of ExecutionNeed (extended elements) with following keys can not be migrated : {2} -> (only supported \"HwFeatureCategory\" as key is : \"Instructions\")", new Object[]{containerType, containerElementName, extendedElementsbuffer.toString().substring(0, extendedElementsbuffer.length() - 1)});
            }
            if (defaultElementsbuffer.length() > 0 && (TASK_SCHEDULER.equals(containerType) || INTERRUPT_CONTROLLER.equals(containerType))) {
                this.logger.info("In {0} : \"{1}, \" Entries of ExecutionNeed (default elements) with following keys can not be migrated : {2} ->(only supported \"HwFeatureCategory\" as key is : \"Instructions\")", new Object[]{containerType, containerElementName, defaultElementsbuffer.toString().substring(0, defaultElementsbuffer.length() - 1)});
            }
            parent.removeContent((Content)executionNeedElement);
        }
    }

    private Double getIPCValue(Element extendedElement) {
        Double ipcValue;
        String ipcFeatureElement;
        String puDefinition = HelperUtil.getSingleElementNameFromAttributeOrChildeElement((String)KEY, (Element)extendedElement);
        if (puDefinition != null && (ipcFeatureElement = this.cache.getPuDefinitionIPCFeatureMap().get(puDefinition)) != null && (ipcValue = this.cache.getIpcFeatureValueMap().get(ipcFeatureElement)) != null) {
            return ipcValue;
        }
        return 1.0;
    }

    private Element createTicksElementFromNeed(Element valueElement, String newElementName, double ipcValue) {
        if (valueElement != null) {
            String valueType = valueElement.getAttributeValue(TYPE, AmaltheaNamespaceRegistry.getGenericNamespace((String)XSI));
            if (valueType != null && "am:NeedConstant".equals(valueType)) {
                Element executionTicksElement = new Element(newElementName);
                Attribute defaultExecutionTicksTypeAttribute = new Attribute(TYPE, "am:DiscreteValueConstant", AmaltheaNamespaceRegistry.getGenericNamespace((String)XSI));
                executionTicksElement.getAttributes().add(defaultExecutionTicksTypeAttribute);
                String valueValue = valueElement.getAttributeValue(VALUE);
                if (valueValue != null) {
                    executionTicksElement.getAttributes().add(new Attribute(VALUE, HelperUtils093.getValueAfterApplyingIPC(valueValue, ipcValue, this.logger)));
                }
                return executionTicksElement;
            }
            if (valueType != null && "am:NeedDeviation".equals(valueType)) {
                Element deviationElement = valueElement.getChild("deviation");
                return HelperUtils093.migrateDeviationElementContainingLongValue(deviationElement, newElementName, ipcValue, this.logger);
            }
        }
        return null;
    }

    private PUDefinitionIPCData getHWCache(List<ICache> caches) {
        if (caches != null) {
            for (ICache c : caches) {
                Map map;
                Map cacheMap;
                if (!(c instanceof HWCacheBuilder) || (cacheMap = c.getCacheMap()) == null || cacheMap.isEmpty() || (map = (Map)cacheMap.values().iterator().next()) == null) continue;
                Object object = map.get("globalCache");
                return (PUDefinitionIPCData)object;
            }
        }
        return null;
    }
}

