/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.app4mc.amalthea.converters.ui.dialog;

import java.util.Map;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.TableColumnLayout;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Widget;

public class MigrationResultDialog
extends Dialog {
    private final Map<String, String> results;

    public MigrationResultDialog(Shell parentShell, Map<String, String> results) {
        super(parentShell);
        this.setShellStyle(67696);
        this.results = results;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText("AMALTHEA Model Migration Result");
    }

    protected Point getInitialSize() {
        return new Point(700, 400);
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
    }

    protected Control createDialogArea(Composite parent) {
        parent.setToolTipText("AMALTHEA Model Migration Result");
        Composite parentComposite = (Composite)super.createDialogArea(parent);
        GridLayout gridLayout = (GridLayout)parentComposite.getLayout();
        gridLayout.numColumns = 1;
        Composite tableComposite = this.createFileTableViewer(parentComposite);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)tableComposite);
        return parentComposite;
    }

    private Composite createFileTableViewer(Composite parent) {
        Composite tableComposite = new Composite(parent, 0);
        TableColumnLayout tableColumnLayout = new TableColumnLayout();
        tableComposite.setLayout((Layout)tableColumnLayout);
        TableViewer tableViewer = new TableViewer(tableComposite, 68352);
        Table table = tableViewer.getTable();
        table.setLinesVisible(true);
        table.setHeaderVisible(true);
        TableViewerColumn filepathColumn = new TableViewerColumn(tableViewer, 0);
        filepathColumn.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                Map.Entry entry = (Map.Entry)element;
                return super.getText(entry.getKey());
            }
        });
        TableColumn column = filepathColumn.getColumn();
        column.setText("Relative file paths");
        tableColumnLayout.setColumnData((Widget)column, (ColumnLayoutData)new ColumnWeightData(50, true));
        TableViewerColumn resultColumn = new TableViewerColumn(tableViewer, 0);
        resultColumn.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                Map.Entry entry = (Map.Entry)element;
                return super.getText(entry.getValue());
            }
        });
        column = resultColumn.getColumn();
        column.setText("Migration Result");
        tableColumnLayout.setColumnData((Widget)column, (ColumnLayoutData)new ColumnWeightData(50, true));
        tableViewer.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        tableViewer.setInput(this.results.entrySet());
        tableViewer.setComparator(new ViewerComparator());
        return tableComposite;
    }
}

