/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.app4mc.amalthea.converters093.impl;

import java.io.File;
import java.util.List;
import java.util.Map;
import org.eclipse.app4mc.amalthea.converters.common.base.ICache;
import org.eclipse.app4mc.amalthea.converters.common.base.IConverter;
import org.eclipse.app4mc.amalthea.converters.common.converter.AbstractConverter;
import org.eclipse.app4mc.amalthea.converters.common.utils.AmaltheaNamespaceRegistry;
import org.eclipse.app4mc.amalthea.converters.common.utils.HelperUtil;
import org.eclipse.app4mc.amalthea.converters.common.utils.ModelVersion;
import org.eclipse.app4mc.amalthea.converters093.utils.HelperUtils093;
import org.eclipse.app4mc.util.sessionlog.SessionLogger;
import org.jdom2.Attribute;
import org.jdom2.Content;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.Namespace;
import org.jdom2.Parent;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"input_model_version=0.9.2", "output_model_version=0.9.3"}, service={IConverter.class})
public class HwConverter
extends AbstractConverter {
    @Reference
    SessionLogger logger;

    @Activate
    protected void activate(Map<String, Object> properties) {
        super.activate(properties);
    }

    public void convert(File targetFile, Map<File, Document> filename2documentMap, List<ICache> caches) {
        this.logger.info("Migration from 0.9.2 to 0.9.3 : Executing Hw converter for model file : {0}", new Object[]{targetFile.getName()});
        Document root = filename2documentMap.get(targetFile);
        if (root == null) {
            return;
        }
        Element rootElement = root.getRootElement();
        this.updateLatency(rootElement);
    }

    private void updateLatency(Element rootElement) {
        StringBuilder xpathBuffer = new StringBuilder();
        xpathBuffer.append("./hwModel//accessLatency");
        xpathBuffer.append("|");
        xpathBuffer.append("./hwModel//readLatency");
        xpathBuffer.append("|");
        xpathBuffer.append("./hwModel//writeLatency");
        List latencyElements = HelperUtil.getXpathResult((Element)rootElement, (String)xpathBuffer.toString(), Element.class, (Namespace[])new Namespace[]{AmaltheaNamespaceRegistry.getNamespace((ModelVersion)ModelVersion.VERSION_093, (String)"am"), AmaltheaNamespaceRegistry.getGenericNamespace((String)"xsi")});
        for (Element latencyElement : latencyElements) {
            Attribute typeAttribute = latencyElement.getAttribute("type", AmaltheaNamespaceRegistry.getGenericNamespace((String)"xsi"));
            if (typeAttribute == null) continue;
            String type = typeAttribute.getValue();
            if ("am:LatencyConstant".equals(type)) {
                type = "am:DiscreteValueConstant";
                typeAttribute.setValue(type);
                Attribute cyclesAttribute = latencyElement.getAttribute("cycles");
                if (cyclesAttribute == null) continue;
                cyclesAttribute.setName("value");
                continue;
            }
            if (!"am:LatencyDeviation".equals(type)) continue;
            String elementName = latencyElement.getName();
            Parent parentElement = latencyElement.getParent();
            int indexOf = parentElement.indexOf((Content)latencyElement);
            Element migratedElement = HelperUtils093.migrateDeviationElementContainingLongValue(latencyElement.getChild("cycles"), elementName, 1.0, this.logger);
            parentElement.removeContent((Content)latencyElement);
            if (migratedElement == null) continue;
            parentElement.addContent(indexOf, (Content)migratedElement);
        }
    }
}

