/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.app4mc.amalthea.model.check;

import java.io.OutputStream;
import java.io.PrintStream;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import org.eclipse.app4mc.amalthea.model.Amalthea;
import org.eclipse.app4mc.amalthea.model.IReferable;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.EContentsEList;
import org.eclipse.emf.ecore.util.EcoreUtil;

public class ModelStructureCheck {
    private ModelStructureCheck() {
        throw new IllegalStateException("Utility class");
    }

    public static boolean checkModel(Amalthea model, PrintStream stream, boolean verbose) {
        boolean result = true;
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss:SSS");
        if (model == null) {
            return false;
        }
        Throwable throwable = null;
        Object var6_7 = null;
        try (PrintStream nullStream = ModelStructureCheck.getNullPrintStream();){
            PrintStream out = stream != null ? stream : nullStream;
            out.println("++++ Model check startet at " + dateFormat.format(new Date()));
            HashMap<String, IReferable> idMap = new HashMap<String, IReferable>();
            TreeIterator iterator = EcoreUtil.getAllContents((EObject)model, (boolean)false);
            while (iterator.hasNext()) {
                EObject element = (EObject)iterator.next();
                if (!(element instanceof IReferable)) continue;
                IReferable refObj = (IReferable)element;
                String id = refObj.getUniqueName();
                if (idMap.containsKey(id)) {
                    IReferable oldObj = idMap.put(id, null);
                    if (oldObj != null) {
                        out.println("Name is not unique: " + id);
                    }
                    out.println("Name is not unique: " + id);
                    continue;
                }
                idMap.put(id, refObj);
            }
            TreeIterator objIter = model.eAllContents();
            while (objIter.hasNext()) {
                EObject content = (EObject)objIter.next();
                EContentsEList.FeatureIterator featureIterator = (EContentsEList.FeatureIterator)content.eCrossReferences().iterator();
                while (featureIterator.hasNext()) {
                    StringBuilder sb;
                    EObject eObj = (EObject)featureIterator.next();
                    EReference eRef = (EReference)featureIterator.feature();
                    if (eRef.isTransient()) continue;
                    if (!(eObj instanceof IReferable)) {
                        out.println("ERROR -- unknown reference " + eRef.getName() + " to " + eObj.getClass().getSimpleName());
                        continue;
                    }
                    IReferable refObj = (IReferable)eObj;
                    if (idMap.containsKey(refObj.getUniqueName())) {
                        if (!verbose) continue;
                        sb = new StringBuilder();
                        sb.append("    reference: ");
                        ModelStructureCheck.addReferenceDescription(eRef, content, refObj, sb);
                        out.println(sb.toString());
                        continue;
                    }
                    result = false;
                    sb = new StringBuilder();
                    sb.append("Illegal target: ");
                    ModelStructureCheck.addReferenceDescription(eRef, content, refObj, sb);
                    out.println(sb.toString());
                }
            }
            idMap.clear();
            out.println("++++ Model check finished at " + dateFormat.format(new Date()));
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        return result;
    }

    private static PrintStream getNullPrintStream() {
        OutputStream nullOutputStream = new OutputStream(){

            @Override
            public void write(int b) {
            }
        };
        return new PrintStream(nullOutputStream);
    }

    private static String getName(EObject obj) {
        EStructuralFeature sf = obj.eClass().getEStructuralFeature("name");
        if (sf == null) {
            return "";
        }
        String name = (String)obj.eGet(sf);
        if (name == null || name.length() == 0) {
            return "???";
        }
        return name;
    }

    private static void addShortString(EObject obj, StringBuilder sb) {
        sb.append(obj.getClass().getSimpleName());
        sb.append("@");
        sb.append(Integer.toHexString(obj.hashCode()));
    }

    private static void addReferenceDescription(EReference ref, EObject source, EObject target, StringBuilder sb) {
        ModelStructureCheck.addShortString(source, sb);
        sb.append("[ ");
        sb.append(ModelStructureCheck.getName(source));
        sb.append(" ] --- ");
        sb.append(ref.getName());
        sb.append(" --> ");
        ModelStructureCheck.addShortString(target, sb);
        sb.append("[ ");
        sb.append(ModelStructureCheck.getName(target));
        sb.append(" ]");
    }
}

