/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.app4mc.amalthea.model.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.app4mc.amalthea.model.Amalthea;
import org.eclipse.app4mc.amalthea.model.AmaltheaFactory;
import org.eclipse.app4mc.amalthea.model.HwFeature;
import org.eclipse.app4mc.amalthea.model.HwFeatureCategory;
import org.eclipse.app4mc.amalthea.model.ISR;
import org.eclipse.app4mc.amalthea.model.ISRAllocation;
import org.eclipse.app4mc.amalthea.model.Label;
import org.eclipse.app4mc.amalthea.model.MappingModel;
import org.eclipse.app4mc.amalthea.model.Memory;
import org.eclipse.app4mc.amalthea.model.MemoryMapping;
import org.eclipse.app4mc.amalthea.model.Process;
import org.eclipse.app4mc.amalthea.model.ProcessingUnit;
import org.eclipse.app4mc.amalthea.model.ProcessingUnitDefinition;
import org.eclipse.app4mc.amalthea.model.SchedulerAllocation;
import org.eclipse.app4mc.amalthea.model.Task;
import org.eclipse.app4mc.amalthea.model.TaskAllocation;
import org.eclipse.app4mc.amalthea.model.TaskScheduler;
import org.eclipse.app4mc.amalthea.model.util.ModelUtil;
import org.eclipse.emf.common.util.EList;

public class DeploymentUtil {
    private DeploymentUtil() {
        throw new IllegalStateException("Utility class");
    }

    public static Set<Process> getProcessesMappedToCore(ProcessingUnit core, Amalthea model) {
        HashSet<Process> result = new HashSet<Process>();
        result.addAll(DeploymentUtil.getTasksMappedToCore(core, model));
        result.addAll(DeploymentUtil.getISRsMappedToCore(core, model));
        return result;
    }

    public static Set<Task> getTasksMappedToCore(ProcessingUnit core, Amalthea model) {
        HashSet<Task> tasks = new HashSet<Task>();
        MappingModel mappingModel = model.getMappingModel();
        if (mappingModel == null) {
            return tasks;
        }
        HashSet<TaskScheduler> schedulers = new HashSet<TaskScheduler>();
        for (SchedulerAllocation schedAlloc : mappingModel.getSchedulerAllocation()) {
            if (!(schedAlloc.getScheduler() instanceof TaskScheduler) || !schedAlloc.getResponsibility().contains((Object)core)) continue;
            schedulers.add((TaskScheduler)schedAlloc.getScheduler());
        }
        for (TaskAllocation taskAlloc : mappingModel.getTaskAllocation()) {
            if (!schedulers.contains(taskAlloc.getScheduler())) continue;
            if (taskAlloc.getAffinity().isEmpty()) {
                tasks.add(taskAlloc.getTask());
                continue;
            }
            if (!taskAlloc.getAffinity().contains((Object)core)) continue;
            tasks.add(taskAlloc.getTask());
        }
        return tasks;
    }

    public static Set<ISR> getISRsMappedToCore(ProcessingUnit core, Amalthea model) {
        if (core == null || model.getSwModel() == null || model.getSwModel().getIsrs() == null || model.getMappingModel() == null || model.getMappingModel().getIsrAllocation() == null) {
            return null;
        }
        HashSet<ISR> result = new HashSet<ISR>();
        EList<ISRAllocation> isrAlloc = model.getMappingModel().getIsrAllocation();
        EList<SchedulerAllocation> schedulerAllocs = model.getMappingModel().getSchedulerAllocation();
        for (ISR isr : model.getSwModel().getIsrs()) {
            for (ISRAllocation ia : isrAlloc) {
                if (ia.getIsr() == null || !ia.getIsr().equals(isr)) continue;
                for (SchedulerAllocation coreAlloc : schedulerAllocs) {
                    if (!coreAlloc.getResponsibility().contains((Object)core) || coreAlloc.getScheduler() != ia.getController()) continue;
                    result.add(isr);
                }
            }
        }
        return result;
    }

    public static List<TaskAllocation> getTaskAllocations(Task task, Amalthea model) {
        ArrayList<TaskAllocation> allocs = new ArrayList<TaskAllocation>();
        for (TaskAllocation ta : model.getMappingModel().getTaskAllocation()) {
            if (ta.getTask() == null || !ta.getTask().equals(task)) continue;
            allocs.add(ta);
        }
        return allocs;
    }

    public static boolean isMapped(Label label) {
        return !DeploymentUtil.getLabelMapping(label).isEmpty();
    }

    public static Set<Memory> getLabelMapping(Label label) {
        HashSet<Memory> locations = new HashSet<Memory>();
        for (MemoryMapping mapping : label.getMappings()) {
            locations.add(mapping.getMemory());
        }
        return locations;
    }

    public static MemoryMapping setLabelMapping(Label label, Memory mem, Amalthea model) {
        if (mem == null || label == null) {
            return null;
        }
        MemoryMapping mapping = AmaltheaFactory.eINSTANCE.createMemoryMapping();
        mapping.setAbstractElement(label);
        mapping.setMemory(mem);
        ModelUtil.getOrCreateMappingModel(model).getMemoryMapping().add((Object)mapping);
        return mapping;
    }

    public static Set<ProcessingUnit> getAssignedCoreForProcess(Process process, Amalthea model) {
        if (model == null || process == null) {
            return null;
        }
        MappingModel mappingModel = model.getMappingModel();
        if (mappingModel == null) {
            return null;
        }
        HashSet<ProcessingUnit> processingUnits = new HashSet<ProcessingUnit>();
        if (process instanceof Task) {
            DeploymentUtil.getAssignedCoresForTask((Task)process, mappingModel, processingUnits);
        }
        if (process instanceof ISR) {
            DeploymentUtil.getAssignedCoresForISR((ISR)process, mappingModel, processingUnits);
        }
        return processingUnits;
    }

    private static void getAssignedCoresForISR(ISR isr, MappingModel mappingModel, Set<ProcessingUnit> processingUnits) {
        for (ISRAllocation isrAlloc : mappingModel.getIsrAllocation()) {
            if (isrAlloc.getIsr() == null || !isrAlloc.getIsr().equals(isr)) continue;
            for (SchedulerAllocation coreAlloc : mappingModel.getSchedulerAllocation()) {
                if (coreAlloc.getScheduler() == null || !coreAlloc.getScheduler().equals(isrAlloc.getController())) continue;
                processingUnits.addAll((Collection<ProcessingUnit>)coreAlloc.getResponsibility());
            }
        }
    }

    private static void getAssignedCoresForTask(Task task, MappingModel mappingModel, Set<ProcessingUnit> processingUnits) {
        HashSet<TaskAllocation> taskAllocations = new HashSet<TaskAllocation>();
        for (TaskAllocation taskAlloc : mappingModel.getTaskAllocation()) {
            if (taskAlloc.getTask() == null || !taskAlloc.getTask().equals(task)) continue;
            taskAllocations.add(taskAlloc);
        }
        for (SchedulerAllocation schedAlloc : mappingModel.getSchedulerAllocation()) {
            if (!(schedAlloc.getScheduler() instanceof TaskScheduler)) continue;
            TaskScheduler scheduler1 = (TaskScheduler)schedAlloc.getScheduler();
            for (TaskAllocation taskAlloc : taskAllocations) {
                TaskScheduler scheduler2 = taskAlloc.getScheduler();
                if (scheduler1 == null || !scheduler1.equals(scheduler2) && !scheduler1.getChildSchedulers().contains((Object)scheduler2)) continue;
                if (!taskAlloc.getAffinity().isEmpty()) {
                    for (ProcessingUnit core : taskAlloc.getAffinity()) {
                        if (!schedAlloc.getResponsibility().contains((Object)core)) continue;
                        processingUnits.add(core);
                    }
                    continue;
                }
                processingUnits.addAll((Collection<ProcessingUnit>)schedAlloc.getResponsibility());
            }
        }
    }

    public static List<HwFeatureCategory> getFeatureCategories(ProcessingUnitDefinition procUnitDef) {
        ArrayList<HwFeatureCategory> result = new ArrayList<HwFeatureCategory>();
        for (HwFeature feature : procUnitDef.getFeatures()) {
            if (result.contains(feature.getContainingCategory())) continue;
            result.add(feature.getContainingCategory());
        }
        return result;
    }

    public static List<ProcessingUnitDefinition> getProcessingUnitDefinitionsForHwCategories(HwFeatureCategory hwFeatureCat, List<ProcessingUnitDefinition> procUnitDefinitons) {
        ArrayList<ProcessingUnitDefinition> result = new ArrayList<ProcessingUnitDefinition>();
        for (ProcessingUnitDefinition procUnitDef : procUnitDefinitons) {
            for (HwFeature feature : hwFeatureCat.getFeatures()) {
                if (!procUnitDef.getFeatures().contains((Object)feature)) continue;
                result.add(procUnitDef);
            }
        }
        return result;
    }

    public static List<ProcessingUnitDefinition> getProcessingUnitDefinitionsForHwFeature(HwFeature feature, List<ProcessingUnitDefinition> procUnitDefinitons) {
        ArrayList<ProcessingUnitDefinition> result = new ArrayList<ProcessingUnitDefinition>();
        for (ProcessingUnitDefinition procUnitDef : procUnitDefinitons) {
            if (!procUnitDef.getFeatures().contains((Object)feature)) continue;
            result.add(procUnitDef);
        }
        return result;
    }
}

