/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.app4mc.amalthea.validations.sim.software;

import java.util.List;
import org.eclipse.app4mc.amalthea.model.AbstractMemoryElement;
import org.eclipse.app4mc.amalthea.model.ActivityGraphItem;
import org.eclipse.app4mc.amalthea.model.Label;
import org.eclipse.app4mc.amalthea.model.LabelAccess;
import org.eclipse.app4mc.amalthea.validation.core.AmaltheaValidation;
import org.eclipse.app4mc.amalthea.validations.sim.software.SimSoftwareMemoryAccessFeasibility;
import org.eclipse.app4mc.validation.annotation.Validation;
import org.eclipse.app4mc.validation.core.ValidationDiagnostic;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;

@Validation(id="Sim-Software-LabelAccessFeasibility", checks={"Checks if a label access can be performed from certain runnable, as a hosting processing unit must be able to access the label's memory location."})
public class SimSoftwareLabelAccessFeasibility
extends AmaltheaValidation {
    public EClassifier getEClassifier() {
        return ePackage.getLabelAccess();
    }

    public void validate(EObject eObject, List<ValidationDiagnostic> results) {
        if (eObject instanceof LabelAccess) {
            LabelAccess labelAccess = (LabelAccess)eObject;
            if (labelAccess == null || labelAccess.getData() == null) {
                return;
            }
            Label abstractMemoryElement = labelAccess.getData();
            if (!SimSoftwareMemoryAccessFeasibility.validate(results, (ActivityGraphItem)labelAccess, (AbstractMemoryElement)abstractMemoryElement)) {
                this.addIssue(results, (EObject)labelAccess, (EStructuralFeature)ePackage.getLabelAccess_Data(), SimSoftwareLabelAccessFeasibility.getMessage());
            }
        }
    }

    public static String getMessage() {
        return "Label's memory location is not accessible from each core, onto which this activity item is deployed.";
    }
}

