/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.app4mc.amalthea.validations.sim.software;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.app4mc.amalthea.model.AbstractMemoryElement;
import org.eclipse.app4mc.amalthea.model.ActivityGraphItem;
import org.eclipse.app4mc.amalthea.model.AmaltheaIndex;
import org.eclipse.app4mc.amalthea.model.HwAccessElement;
import org.eclipse.app4mc.amalthea.model.Memory;
import org.eclipse.app4mc.amalthea.model.Process;
import org.eclipse.app4mc.amalthea.model.ProcessingUnit;
import org.eclipse.app4mc.amalthea.model.RunnableCall;
import org.eclipse.app4mc.amalthea.model.Scheduler;
import org.eclipse.app4mc.amalthea.model.SchedulerAllocation;
import org.eclipse.app4mc.amalthea.model.util.DeploymentUtil;
import org.eclipse.app4mc.validation.annotation.Validation;
import org.eclipse.app4mc.validation.core.ValidationDiagnostic;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;

@Validation(id="Sim-Software-LabelAccessFeasibility", checks={"Checks if a label access can be performed from certain runnable, as a hosting processing unit must be able to access the label's memory location."})
class SimSoftwareMemoryAccessFeasibility {
    SimSoftwareMemoryAccessFeasibility() {
    }

    public static boolean validate(List<ValidationDiagnostic> results, ActivityGraphItem activityGraphItem, AbstractMemoryElement abstractMemoryElement) {
        Set memories = DeploymentUtil.getMapping((AbstractMemoryElement)abstractMemoryElement);
        if (memories.isEmpty() || memories.size() > 1) {
            return true;
        }
        HashSet processingUnits = new HashSet();
        if (activityGraphItem.getContainingRunnable() != null) {
            EList runnableCalls = activityGraphItem.getContainingRunnable().getRunnableCalls();
            for (RunnableCall runnableCall : runnableCalls) {
                if (runnableCall.getContainingProcess() == null) continue;
                processingUnits.addAll(DeploymentUtil.getAssignedCoreForProcess((Process)runnableCall.getContainingProcess()));
            }
        } else if (activityGraphItem.getContainingProcess() != null) {
            processingUnits.addAll(DeploymentUtil.getAssignedCoreForProcess((Process)activityGraphItem.getContainingProcess()));
        } else if (activityGraphItem.eContainingFeature() instanceof Scheduler) {
            Scheduler scheduler = (Scheduler)activityGraphItem.eContainingFeature();
            for (SchedulerAllocation schedulerAllocation : AmaltheaIndex.getReferringObjects((EObject)scheduler, SchedulerAllocation.class)) {
                processingUnits.addAll(schedulerAllocation.getResponsibility());
            }
        }
        if (processingUnits.isEmpty()) {
            return true;
        }
        for (ProcessingUnit processingUnit : processingUnits) {
            for (Memory memory : memories) {
                Set hwAccessElements = AmaltheaIndex.getReferringObjects((EObject)memory, HwAccessElement.class);
                boolean foundAccessElement = false;
                for (HwAccessElement hwAccessElement : hwAccessElements) {
                    if (hwAccessElement.getSource() != processingUnit) continue;
                    foundAccessElement = true;
                    break;
                }
                if (foundAccessElement) continue;
                return false;
            }
        }
        return true;
    }
}

