/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.app4mc.atdb._import.btf;

import java.lang.reflect.InvocationTargetException;
import java.sql.SQLException;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.eclipse.app4mc.atdb.ATDBConnection;
import org.eclipse.app4mc.atdb.EntityType;
import org.eclipse.app4mc.atdb._import.btf.model.BTFCombiState;
import org.eclipse.app4mc.atdb._import.btf.model.BTFCountMetric;
import org.eclipse.app4mc.atdb._import.btf.model.BTFEntityState;
import org.eclipse.app4mc.atdb._import.btf.model.BTFEntityType;
import org.eclipse.app4mc.atdb._import.btf.model.BTFInterInstanceMetric;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.util.Enumerator;
import org.eclipse.jface.operation.IRunnableWithProgress;

public class ATDBMetricCalculator
implements IRunnableWithProgress {
    private final ATDBConnection con;

    public ATDBMetricCalculator(ATDBConnection con) {
        this.con = con;
    }

    public void run(IProgressMonitor progressMonitor) throws InvocationTargetException {
        progressMonitor.beginTask("Calculating metrics...", 1);
        try {
            try {
                this.con.executeBatchUpdate(atdbCon -> {
                    void var3_9;
                    for (BTFEntityState state : BTFEntityState.actStates) {
                        for (Map.Entry entry : state.entityType2InOutEvents.entrySet()) {
                            BTFEntityType entityType = (BTFEntityType)((Object)((Object)entry.getKey()));
                            List incomingEvents = ((List)((Map.Entry)entry.getValue()).getKey()).stream().map(e -> e.toString().toLowerCase()).collect(Collectors.toList());
                            List outgoingEvents = ((List)((Map.Entry)entry.getValue()).getValue()).stream().map(e -> e.toString().toLowerCase()).collect(Collectors.toList());
                            atdbCon.insertEntityInstanceStateMetricValuesForEntityType((Object)((Object)state) + "Time", (EntityType)entityType, incomingEvents, outgoingEvents);
                        }
                    }
                    Object object = BTFCombiState.values();
                    int n = ((BTFCombiState[])object).length;
                    int n2 = 0;
                    while (n2 < n) {
                        Object cState = object[n2];
                        List relevantStates = ((BTFCombiState)((Object)((Object)cState))).getStates().stream().map(s -> (Object)s + "Time").collect(Collectors.toList());
                        atdbCon.insertCombinedEntityInstanceStateMetricValuesForEntityType(cState + "Time", (EntityType)BTFEntityType.PROCESS, relevantStates);
                        ++n2;
                    }
                    object = BTFInterInstanceMetric.values();
                    int n3 = ((BTFInterInstanceMetric[])object).length;
                    n2 = 0;
                    while (n2 < n3) {
                        Object metric = object[n2];
                        for (Map.Entry<BTFEntityType, Map.Entry<Enumerator, Enumerator>> et2fs : ((BTFInterInstanceMetric)((Object)((Object)metric))).entityType2FirstAndSecond.entrySet()) {
                            BTFEntityType entityType = et2fs.getKey();
                            String firstInstanceEvent = et2fs.getValue().getKey().toString();
                            String secondInstanceEvent = et2fs.getValue().getValue().toString();
                            atdbCon.insertInterEntityInstanceMetricValuesForEntityType(((Enum)metric).toString(), (EntityType)entityType, firstInstanceEvent, secondInstanceEvent);
                        }
                        ++n2;
                    }
                    String activateEvent = BTFInterInstanceMetric.activateToActivate.entityType2FirstAndSecond.entrySet().iterator().next().getValue().getKey().toString();
                    atdbCon.insertInterSourceEntityInstanceMetricValuesForEntityType(BTFInterInstanceMetric.activateToActivate.toString(), (EntityType)BTFEntityType.PROCESS, activateEvent);
                    atdbCon.insertAggregatedEntityInstanceMetricsForDimension("time");
                    BTFCountMetric[] bTFCountMetricArray = BTFCountMetric.values();
                    int n4 = bTFCountMetricArray.length;
                    boolean bl = false;
                    while (var3_9 < n4) {
                        BTFCountMetric cm = bTFCountMetricArray[var3_9];
                        atdbCon.insertMetric(cm.toString(), "count");
                        atdbCon.insertCountsForEntityTypeAndEvent(cm.toString(), (EntityType)cm.entityType, cm.eventToCount.toString().toLowerCase());
                        ++var3_9;
                    }
                });
                progressMonitor.worked(1);
            }
            catch (SQLException e) {
                throw new InvocationTargetException(e);
            }
        }
        finally {
            progressMonitor.done();
        }
    }
}

