/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.app4mc.amalthea.model.editor.contribution.menu;

import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.eclipse.e4.ui.model.application.ui.menu.MHandledMenuItem;
import org.eclipse.e4.ui.model.application.ui.menu.MMenu;
import org.eclipse.e4.ui.model.application.ui.menu.MMenuElement;
import org.eclipse.e4.ui.model.application.ui.menu.MMenuFactory;

public class MenuBuilder {
    private Map<String, MenuBuilder> subMenus = new HashMap<String, MenuBuilder>();
    private Map<String, MHandledMenuItem> menuItems = new HashMap<String, MHandledMenuItem>();

    public void addMenuItem(String path, MHandledMenuItem menuItem) {
        StringTokenizer tokenizer = new StringTokenizer(path, "|");
        this.addMenuItem(tokenizer, menuItem);
    }

    private void addMenuItem(StringTokenizer tokenizer, MHandledMenuItem menuItem) {
        String label = tokenizer.nextToken().trim();
        if (tokenizer.countTokens() == 0) {
            menuItem.setLabel(label);
            this.menuItems.put(label, menuItem);
        } else {
            MenuBuilder builder = this.subMenus.computeIfAbsent(label, k -> new MenuBuilder());
            builder.addMenuItem(tokenizer, menuItem);
        }
    }

    public void populateMenuElementsList(List<MMenuElement> items) {
        this.subMenus.entrySet().stream().sorted(Comparator.comparing(Map.Entry::getKey)).forEachOrdered(e -> {
            MMenu subMenu = MMenuFactory.INSTANCE.createMenu();
            subMenu.setLabel((String)e.getKey());
            items.add((MMenuElement)subMenu);
            ((MenuBuilder)e.getValue()).populateMenuElementsList(subMenu.getChildren());
        });
        this.menuItems.entrySet().stream().sorted(Comparator.comparing(Map.Entry::getKey)).forEachOrdered(e -> {
            boolean bl = items.add((MMenuElement)e.getValue());
        });
    }
}

